/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.handler.def.simple;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.util.TemporaryListener;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.def.SimpleSkillResult;
import io.lumine.mythic.lib.version.Sounds;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class Bunny_Mode
extends SkillHandler<SimpleSkillResult> {
    private static final long JUMP_COOLDOWN = 300L;

    public Bunny_Mode() {
        this.registerModifiers("duration", "jump-force", "speed");
    }

    @Override
    public SimpleSkillResult getResult(SkillMetadata meta) {
        return new SimpleSkillResult();
    }

    @Override
    public void whenCast(SimpleSkillResult result, SkillMetadata skillMeta) {
        final double duration = skillMeta.getParameter("duration") * 20.0;
        final double y = skillMeta.getParameter("jump-force");
        final double xz = skillMeta.getParameter("speed");
        final Player caster = skillMeta.getCaster().getPlayer();
        new BukkitRunnable(){
            final BunnyModeEffect handler;
            int j;
            long lastJump;
            {
                this.handler = new BunnyModeEffect(caster);
                this.j = 0;
                this.lastJump = 0L;
            }

            public void run() {
                int n = this.j++;
                if ((double)n > duration) {
                    this.handler.close(60L);
                    this.cancel();
                    return;
                }
                if (caster.getLocation().add(0.0, -0.3, 0.0).getBlock().getType().isSolid() && System.currentTimeMillis() - this.lastJump > 300L) {
                    this.lastJump = System.currentTimeMillis();
                    Vector dir = UtilityMethods.safeNormalize(caster.getEyeLocation().getDirection().setY(0), new Vector(0, 1, 0));
                    caster.setVelocity(dir.multiply(0.8 * xz).setY(0.5 * y));
                    caster.getWorld().playSound(caster.getLocation(), Sounds.ENTITY_ENDER_DRAGON_FLAP, 2.0f, 1.0f);
                    for (double a = 0.0; a < Math.PI * 2; a += 0.2617993877991494) {
                        caster.getWorld().spawnParticle(Particle.CLOUD, caster.getLocation(), 0, Math.cos(a), 0.0, Math.sin(a), 0.2);
                    }
                }
            }
        }.runTaskTimer((Plugin)MythicLib.plugin, 0L, 1L);
    }

    public static class BunnyModeEffect
    extends TemporaryListener {
        private final Player player;

        public BunnyModeEffect(Player player) {
            super(new HandlerList[0]);
            this.player = player;
        }

        @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
        public void a(EntityDamageEvent event) {
            if (event.getEntity().equals((Object)this.player) && event.getCause() == EntityDamageEvent.DamageCause.FALL) {
                event.setCancelled(true);
            }
        }
    }
}

