/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.handler.def.simple;

import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.def.SimpleSkillResult;
import io.lumine.mythic.lib.version.Sounds;
import io.lumine.mythic.lib.version.VParticle;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class Blink
extends SkillHandler<SimpleSkillResult> {
    private static final double MIN_RANGE = 1.0;

    public Blink() {
        this.registerModifiers("range");
    }

    @Override
    public SimpleSkillResult getResult(SkillMetadata meta) {
        return new SimpleSkillResult();
    }

    @Override
    public void whenCast(SimpleSkillResult result, SkillMetadata skillMeta) {
        Player caster = skillMeta.getCaster().getPlayer();
        double range = Math.max(1.0, skillMeta.getParameter("range"));
        Vector dir = caster.getEyeLocation().getDirection();
        caster.getWorld().spawnParticle(VParticle.LARGE_EXPLOSION.get(), caster.getLocation().add(0.0, 1.0, 0.0), 0);
        caster.getWorld().spawnParticle(VParticle.INSTANT_EFFECT.get(), caster.getLocation().add(0.0, 1.0, 0.0), 32, 0.0, 0.0, 0.0, 0.1);
        caster.getWorld().playSound(caster.getLocation(), Sounds.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
        RayTraceResult rtResult = caster.getWorld().rayTraceBlocks(caster.getEyeLocation(), dir, range, FluidCollisionMode.NEVER, true);
        Location loc = rtResult == null || rtResult.getHitBlock() == null ? caster.getLocation().add(dir.clone().multiply(range)) : rtResult.getHitPosition().add(rtResult.getHitBlockFace().getDirection().multiply(0.3)).toLocation(caster.getWorld());
        loc.setYaw(caster.getLocation().getYaw());
        loc.setPitch(caster.getLocation().getPitch());
        caster.teleport(loc);
        caster.getWorld().spawnParticle(VParticle.LARGE_EXPLOSION.get(), caster.getLocation().add(0.0, 1.0, 0.0), 0);
        caster.getWorld().spawnParticle(VParticle.INSTANT_EFFECT.get(), caster.getLocation().add(0.0, 1.0, 0.0), 32, 0.0, 0.0, 0.0, 0.1);
    }
}

