/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.script.variable.def;

import io.lumine.mythic.lib.script.variable.SimpleVariableRegistry;
import io.lumine.mythic.lib.script.variable.Variable;
import io.lumine.mythic.lib.script.variable.VariableMetadata;
import io.lumine.mythic.lib.script.variable.VariableRegistry;
import io.lumine.mythic.lib.script.variable.def.AttributesVariable;
import io.lumine.mythic.lib.script.variable.def.DoubleVariable;
import io.lumine.mythic.lib.script.variable.def.IntegerVariable;
import io.lumine.mythic.lib.script.variable.def.PlayerVariable;
import io.lumine.mythic.lib.script.variable.def.PositionVariable;
import io.lumine.mythic.lib.script.variable.def.StringVariable;
import org.bukkit.attribute.Attributable;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

@VariableMetadata(name="entity")
public class EntityVariable
extends Variable<Entity> {
    public static final SimpleVariableRegistry<Entity> VARIABLE_REGISTRY = new SimpleVariableRegistry();

    public EntityVariable(String name, Entity entity) {
        super(name, entity);
    }

    @Override
    public VariableRegistry<Variable<Entity>> getVariableRegistry() {
        return VARIABLE_REGISTRY;
    }

    @Override
    public String toString() {
        return this.getStored() == null ? "None" : String.valueOf(((Entity)this.getStored()).getEntityId());
    }

    static {
        VARIABLE_REGISTRY.registerVariable("id", var -> new IntegerVariable("temp", var.getEntityId()), new String[0]);
        VARIABLE_REGISTRY.registerVariable("uuid", var -> new StringVariable("temp", var.getUniqueId().toString()), new String[0]);
        VARIABLE_REGISTRY.registerVariable("type", var -> new StringVariable("temp", var.getType().name()), new String[0]);
        VARIABLE_REGISTRY.registerVariable("location", var -> new PositionVariable("temp", var.getLocation()), new String[0]);
        VARIABLE_REGISTRY.registerVariable("bb_center", var -> new PositionVariable("temp", var.getBoundingBox().getCenter().toLocation(var.getWorld())), new String[0]);
        VARIABLE_REGISTRY.registerVariable("eye_location", var -> new PositionVariable("temp", ((LivingEntity)var).getEyeLocation()), new String[0]);
        VARIABLE_REGISTRY.registerVariable("health", var -> new DoubleVariable("temp", ((Damageable)var).getHealth()), new String[0]);
        VARIABLE_REGISTRY.registerVariable("looking", var -> new PositionVariable("temp", var.getWorld(), ((LivingEntity)var).getEyeLocation().getDirection()), new String[0]);
        VARIABLE_REGISTRY.registerVariable("velocity", var -> new PositionVariable("temp", var.getWorld(), var.getVelocity()), new String[0]);
        VARIABLE_REGISTRY.registerVariable("height", var -> new DoubleVariable("temp", var.getHeight()), new String[0]);
        VARIABLE_REGISTRY.registerVariable("attribute", var -> new AttributesVariable("temp", (Attributable)var), new String[0]);
        VARIABLE_REGISTRY.registerVariable("fire_ticks", var -> new IntegerVariable("temp", var.getFireTicks()), new String[0]);
        VARIABLE_REGISTRY.transferTo(PlayerVariable.VARIABLE_REGISTRY);
    }
}

