/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.script.variable;

import io.lumine.mythic.lib.script.variable.Variable;
import io.lumine.mythic.lib.script.variable.VariableContainer;
import io.lumine.mythic.lib.script.variable.VariableScope;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.util.lang3.Validate;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class VariableList
implements VariableContainer {
    private final VariableScope scope;
    private final Map<String, Variable> vars = new HashMap<String, Variable>();

    public VariableList(@NotNull VariableScope scope) {
        this.scope = scope;
    }

    @NotNull
    public VariableScope getScope() {
        return this.scope;
    }

    @Override
    @Nullable
    public Variable getVariable(@NotNull String name) {
        return this.vars.get(name);
    }

    public void registerVariable(@NotNull Variable var) {
        Validate.isTrue(!SkillMetadata.RESERVED_VARIABLE_NAMES.contains(var.getName()), "Cannot use reserved variable name '" + var.getName() + "'", new Object[0]);
        this.vars.put(var.getName(), var);
    }
}

