/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.script.variable;

import io.lumine.mythic.lib.script.variable.Variable;
import io.lumine.mythic.lib.script.variable.VariableMetadata;
import io.lumine.mythic.lib.script.variable.VariableRegistry;
import io.lumine.mythic.lib.util.lang3.Validate;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class SimpleVariableRegistry<D>
implements VariableRegistry<Variable<D>> {
    private final Map<String, Function<D, Variable<?>>> registered = new HashMap();

    @Override
    @NotNull
    public Variable<?> accessVariable(@NotNull Variable<D> d, @NotNull String name) {
        Function<D, Variable<?>> supplier = this.registered.get(name);
        Validate.notNull(supplier, "Cannot find subvariable '" + name + "' in variable type '" + d.getClass().getAnnotation(VariableMetadata.class).name() + "'", new Object[0]);
        return supplier.apply(d.getStored());
    }

    @Override
    public boolean hasVariable(String name) {
        return this.registered.containsKey(name);
    }

    public <E extends D> void transferTo(@NotNull SimpleVariableRegistry<E> registry) {
        this.registered.forEach((key, getter) -> registry.registered.put((String)key, var -> (Variable)getter.apply(var)));
    }

    public void registerVariable(@NotNull String name, @NotNull Function<D, Variable<?>> supplier, String ... aliases) {
        Validate.isTrue(!this.registered.containsKey(name), "A subvariable with the name '" + name + "' already exists", new Object[0]);
        Validate.notNull(supplier, "Supplier cannot be null", new Object[0]);
        this.registered.put(name, supplier);
        for (String alias : aliases) {
            this.registerVariable(alias, supplier, new String[0]);
        }
    }
}

