/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.script.mechanic.buff;

import io.lumine.mythic.lib.player.cooldown.CooldownInfo;
import io.lumine.mythic.lib.script.mechanic.type.TargetMechanic;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.util.DoubleFormula;
import io.lumine.mythic.lib.util.configobject.ConfigObject;
import java.util.function.BiConsumer;
import org.bukkit.entity.Entity;

public class ReduceCooldownMechanic
extends TargetMechanic {
    private final DoubleFormula value;
    private final ReductionType type;
    private final String cooldownPath;

    public ReduceCooldownMechanic(ConfigObject config) {
        super(config);
        config.validateKeys("value", "path");
        this.cooldownPath = config.getString("path");
        this.type = config.contains("type") ? ReductionType.valueOf(config.getString("type").toUpperCase()) : ReductionType.FLAT;
        this.value = new DoubleFormula(config.getString("value"));
    }

    @Override
    public void cast(SkillMetadata meta, Entity target) {
        CooldownInfo info = meta.getCaster().getData().getCooldownMap().getInfo(this.cooldownPath);
        if (info == null || info.hasEnded()) {
            return;
        }
        this.type.apply(info, this.value.evaluate(meta));
    }

    public static enum ReductionType {
        FLAT((info, value) -> info.reduceFlat((double)value)),
        INITIAL((info, value) -> info.reduceInitialCooldown((double)value)),
        REMAINING((info, value) -> info.reduceRemainingCooldown((double)value));

        private final BiConsumer<CooldownInfo, Double> effect;

        private ReductionType(BiConsumer<CooldownInfo, Double> effect) {
            this.effect = effect;
        }

        public void apply(CooldownInfo info, double value) {
            this.effect.accept(info, value);
        }
    }
}

