/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.player.skill;

import io.lumine.mythic.lib.api.player.EquipmentSlot;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.player.modifier.ModifierMap;
import io.lumine.mythic.lib.player.skill.PassiveSkill;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.trigger.TriggerMetadata;
import io.lumine.mythic.lib.skill.trigger.TriggerType;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.GameMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PassiveSkillMap
extends ModifierMap<PassiveSkill> {
    private final Map<String, Long> lastCast = new HashMap<String, Long>();

    public PassiveSkillMap(MMOPlayerData playerData) {
        super(playerData);
    }

    @Nullable
    public PassiveSkill getSkill(@NotNull SkillHandler handler) {
        for (PassiveSkill passive : this.getModifiers()) {
            if (!handler.equals(passive.getTriggeredSkill().getHandler())) continue;
            return passive;
        }
        return null;
    }

    public void tickTimerSkills() {
        TriggerMetadata triggerMeta = new TriggerMetadata(this.getPlayerData(), TriggerType.TIMER, EquipmentSlot.MAIN_HAND, null, null, null, null, null);
        for (PassiveSkill passive : this.getModifiers()) {
            long lastCast;
            if (!passive.getType().equals(TriggerType.TIMER) || this.getPlayerData().getPlayer().getGameMode() == GameMode.SPECTATOR) continue;
            String key = passive.getTriggeredSkill().getHandler().getId();
            @Nullable Long mapValue = this.lastCast.get(key);
            long l = lastCast = mapValue == null ? 0L : mapValue;
            if (lastCast + passive.getTimerPeriod() > System.currentTimeMillis()) continue;
            this.lastCast.put(key, System.currentTimeMillis());
            passive.getTriggeredSkill().cast(triggerMeta);
        }
    }
}

