/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.module;

import io.lumine.mythic.lib.module.MMOPluginImpl;
import io.lumine.mythic.lib.module.ModuleInfo;
import io.lumine.mythic.lib.util.lang3.Validate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.NamespacedKey;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public abstract class Module {
    protected final MMOPluginImpl plugin;
    protected final NamespacedKey key;
    protected final List<NamespacedKey> dependencies = new ArrayList<NamespacedKey>();
    protected final boolean load;
    protected final List<Module> resolvedDependencies = new ArrayList<Module>();
    protected boolean loaded;
    protected boolean enabled;

    protected Module(MMOPluginImpl plugin) {
        this.plugin = plugin;
        ModuleInfo info = this.getClass().getAnnotation(ModuleInfo.class);
        Validate.notNull(info, "Could not find annotation data ModuleInfo", new Object[0]);
        this.key = NamespacedKey.fromString((String)info.key(), (Plugin)plugin);
        this.load = info.load();
    }

    protected Module(@NotNull MMOPluginImpl plugin, @NotNull String key, boolean load) {
        this.plugin = plugin;
        this.key = new NamespacedKey((Plugin)plugin, key);
        this.load = true;
    }

    public boolean isLoaded() {
        return !this.load || this.loaded;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void load() {
        Validate.isTrue(!this.loaded, "Module is already loaded", new Object[0]);
        this.loaded = true;
        this.onLoad();
    }

    public void enable() {
        Validate.isTrue(!this.load || this.loaded, "Module is not loaded yet", new Object[0]);
        Validate.isTrue(!this.enabled, "Module is already enabled", new Object[0]);
        this.enabled = true;
        this.onEnable();
    }

    public void reset() {
        Validate.isTrue(this.loaded || this.enabled, "Module is already reset", new Object[0]);
        this.loaded = false;
        this.enabled = false;
        this.onReset();
    }

    public void onLoad() {
    }

    public void onEnable() {
    }

    public void onReset() {
    }

    public void addDependencies(NamespacedKey ... dependencies) {
        Collections.addAll(this.dependencies, dependencies);
    }

    @NotNull
    public List<NamespacedKey> getDependencies() {
        return this.dependencies;
    }

    @NotNull
    public NamespacedKey getNamespacedKey() {
        return this.key;
    }

    @NotNull
    public MMOPluginImpl getPlugin() {
        return this.plugin;
    }

    public void reload() {
        this.reset();
        this.load();
        this.enable();
    }
}

