/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.manager;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.module.GeneralManager;
import io.lumine.mythic.lib.module.MMOPluginImpl;
import io.lumine.mythic.lib.module.ModuleInfo;
import io.lumine.mythic.lib.script.Script;
import io.lumine.mythic.lib.script.condition.Condition;
import io.lumine.mythic.lib.script.condition.generic.BooleanCondition;
import io.lumine.mythic.lib.script.condition.generic.CompareCondition;
import io.lumine.mythic.lib.script.condition.generic.InBetweenCondition;
import io.lumine.mythic.lib.script.condition.generic.StringEqualsCondition;
import io.lumine.mythic.lib.script.condition.location.BiomeCondition;
import io.lumine.mythic.lib.script.condition.location.CuboidCondition;
import io.lumine.mythic.lib.script.condition.location.DistanceCondition;
import io.lumine.mythic.lib.script.condition.location.WorldCondition;
import io.lumine.mythic.lib.script.condition.misc.CanTargetCondition;
import io.lumine.mythic.lib.script.condition.misc.CooldownCondition;
import io.lumine.mythic.lib.script.condition.misc.FoodCondition;
import io.lumine.mythic.lib.script.condition.misc.HasAmmoMechanic;
import io.lumine.mythic.lib.script.condition.misc.HasDamageTypeCondition;
import io.lumine.mythic.lib.script.condition.misc.IsLivingCondition;
import io.lumine.mythic.lib.script.condition.misc.OnFireCondition;
import io.lumine.mythic.lib.script.condition.misc.PermissionCondition;
import io.lumine.mythic.lib.script.condition.misc.TimeCondition;
import io.lumine.mythic.lib.script.mechanic.Mechanic;
import io.lumine.mythic.lib.script.mechanic.buff.FeedMechanic;
import io.lumine.mythic.lib.script.mechanic.buff.HealMechanic;
import io.lumine.mythic.lib.script.mechanic.buff.ReduceCooldownMechanic;
import io.lumine.mythic.lib.script.mechanic.buff.SaturateMechanic;
import io.lumine.mythic.lib.script.mechanic.buff.stat.AddStatModifierMechanic;
import io.lumine.mythic.lib.script.mechanic.buff.stat.RemoveStatModifierMechanic;
import io.lumine.mythic.lib.script.mechanic.misc.ApplyCooldownMechanic;
import io.lumine.mythic.lib.script.mechanic.misc.DelayMechanic;
import io.lumine.mythic.lib.script.mechanic.misc.DispatchCommandMechanic;
import io.lumine.mythic.lib.script.mechanic.misc.EntityEffectMechanic;
import io.lumine.mythic.lib.script.mechanic.misc.LightningStrikeMechanic;
import io.lumine.mythic.lib.script.mechanic.misc.ScriptMechanic;
import io.lumine.mythic.lib.script.mechanic.movement.TeleportMechanic;
import io.lumine.mythic.lib.script.mechanic.movement.VelocityMechanic;
import io.lumine.mythic.lib.script.mechanic.offense.AdditiveDamageBuffMechanic;
import io.lumine.mythic.lib.script.mechanic.offense.DamageMechanic;
import io.lumine.mythic.lib.script.mechanic.offense.MultiplyDamageMechanic;
import io.lumine.mythic.lib.script.mechanic.offense.PotionMechanic;
import io.lumine.mythic.lib.script.mechanic.offense.RemovePotionMechanic;
import io.lumine.mythic.lib.script.mechanic.offense.SetOnFireMechanic;
import io.lumine.mythic.lib.script.mechanic.player.GiveItemMechanic;
import io.lumine.mythic.lib.script.mechanic.player.SudoMechanic;
import io.lumine.mythic.lib.script.mechanic.projectile.ShootArrowMechanic;
import io.lumine.mythic.lib.script.mechanic.projectile.ShulkerBulletMechanic;
import io.lumine.mythic.lib.script.mechanic.raytrace.RayTraceBlocksMechanic;
import io.lumine.mythic.lib.script.mechanic.raytrace.RayTraceEntitiesMechanic;
import io.lumine.mythic.lib.script.mechanic.shaped.HelixMechanic;
import io.lumine.mythic.lib.script.mechanic.shaped.LineMechanic;
import io.lumine.mythic.lib.script.mechanic.shaped.ParabolaMechanic;
import io.lumine.mythic.lib.script.mechanic.shaped.ProjectileMechanic;
import io.lumine.mythic.lib.script.mechanic.shaped.RayTraceMechanic;
import io.lumine.mythic.lib.script.mechanic.shaped.SlashMechanic;
import io.lumine.mythic.lib.script.mechanic.shaped.SphereMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.IncrementMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.SetBooleanMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.SetDoubleMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.SetIntegerMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.SetStringMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.SetVectorMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.vector.AddVectorMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.vector.CopyVectorMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.vector.CrossProductMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.vector.DotProductMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.vector.HadamardProductMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.vector.MultiplyVectorMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.vector.NormalizeVectorMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.vector.OrientVectorMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.vector.SetXMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.vector.SetYMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.vector.SetZMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.vector.SubtractVectorMechanic;
import io.lumine.mythic.lib.script.mechanic.visual.ParticleMechanic;
import io.lumine.mythic.lib.script.mechanic.visual.PlayerSoundMechanic;
import io.lumine.mythic.lib.script.mechanic.visual.SoundMechanic;
import io.lumine.mythic.lib.script.mechanic.visual.TellMechanic;
import io.lumine.mythic.lib.script.targeter.EntityTargeter;
import io.lumine.mythic.lib.script.targeter.LocationTargeter;
import io.lumine.mythic.lib.script.targeter.entity.CasterTargeter;
import io.lumine.mythic.lib.script.targeter.entity.ConeTargeter;
import io.lumine.mythic.lib.script.targeter.entity.LookingAtTargeter;
import io.lumine.mythic.lib.script.targeter.entity.NearbyEntitiesTargeter;
import io.lumine.mythic.lib.script.targeter.entity.NearestEntityTargeter;
import io.lumine.mythic.lib.script.targeter.entity.TargetTargeter;
import io.lumine.mythic.lib.script.targeter.entity.VariableEntityTargeter;
import io.lumine.mythic.lib.script.targeter.location.CasterLocationTargeter;
import io.lumine.mythic.lib.script.targeter.location.CircleLocationTargeter;
import io.lumine.mythic.lib.script.targeter.location.CustomLocationTargeter;
import io.lumine.mythic.lib.script.targeter.location.SourceLocationTargeter;
import io.lumine.mythic.lib.script.targeter.location.TargetEntityLocationTargeter;
import io.lumine.mythic.lib.script.targeter.location.TargetLocationTargeter;
import io.lumine.mythic.lib.script.targeter.location.VariableLocationTargeter;
import io.lumine.mythic.lib.skill.handler.FabledSkillHandler;
import io.lumine.mythic.lib.skill.handler.MythicLibSkillHandler;
import io.lumine.mythic.lib.skill.handler.MythicMobsSkillHandler;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.util.FileUtils;
import io.lumine.mythic.lib.util.PostLoadException;
import io.lumine.mythic.lib.util.configobject.ConfigObject;
import io.lumine.mythic.lib.util.lang3.Validate;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ModuleInfo(key="stats", load=false)
public class SkillManager
extends GeneralManager {
    private final Map<String, Function<ConfigObject, Mechanic>> mechanics = new HashMap<String, Function<ConfigObject, Mechanic>>();
    private final Map<String, Function<ConfigObject, Condition>> conditions = new HashMap<String, Function<ConfigObject, Condition>>();
    private final Map<String, Function<ConfigObject, EntityTargeter>> entityTargets = new HashMap<String, Function<ConfigObject, EntityTargeter>>();
    private final Map<String, Function<ConfigObject, LocationTargeter>> locationTargets = new HashMap<String, Function<ConfigObject, LocationTargeter>>();
    private final Map<String, Script> scripts = new HashMap<String, Script>();
    private final Map<String, SkillHandler> handlers = new HashMap<String, SkillHandler>();
    private final Map<Predicate<ConfigurationSection>, Function<ConfigurationSection, SkillHandler>> skillHandlerTypes = new HashMap<Predicate<ConfigurationSection>, Function<ConfigurationSection, SkillHandler>>();
    private boolean registration = true;

    public SkillManager(MMOPluginImpl plugin) {
        super(plugin);
        this.registerMechanic("add_stat", config -> new AddStatModifierMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("remove_stat", config -> new RemoveStatModifierMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("feed", config -> new FeedMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("heal", config -> new HealMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("reduce_cooldown", config -> new ReduceCooldownMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("saturate", config -> new SaturateMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("apply_cooldown", ApplyCooldownMechanic::new, new String[0]);
        this.registerMechanic("delay", DelayMechanic::new, new String[0]);
        this.registerMechanic("dispatch_command", DispatchCommandMechanic::new, new String[0]);
        this.registerMechanic("entity_effect", EntityEffectMechanic::new, new String[0]);
        this.registerMechanic("lightning", config -> new LightningStrikeMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("script", config -> new ScriptMechanic((ConfigObject)config), "skill", "cast");
        this.registerMechanic("teleport", config -> new TeleportMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("set_velocity", config -> new VelocityMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("additive_damage_buff", config -> new AdditiveDamageBuffMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("damage", config -> new DamageMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("multiply_damage", config -> new MultiplyDamageMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("potion", config -> new PotionMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("remove_potion", config -> new RemovePotionMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("set_on_fire", config -> new SetOnFireMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("give_item", config -> new GiveItemMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("sudo", config -> new SudoMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("shoot_arrow", config -> new ShootArrowMechanic((ConfigObject)config), "fire_arrow", "bowshoot", "bow_shoot", "shoot_bow");
        this.registerMechanic("shulker_bullet", config -> new ShulkerBulletMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("raytrace_blocks", config -> new RayTraceBlocksMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("raytrace_entities", config -> new RayTraceEntitiesMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("draw_helix", config -> new HelixMechanic((ConfigObject)config), "helix");
        this.registerMechanic("draw_line", LineMechanic::new, "line");
        this.registerMechanic("draw_parabola", ParabolaMechanic::new, "parabola", "spawn_parabola");
        this.registerMechanic("projectile", config -> new ProjectileMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("ray_trace", config -> new RayTraceMechanic((ConfigObject)config), "cast_ray", "raytrace", "ray_cast", "raycast");
        this.registerMechanic("slash", config -> new SlashMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("draw_sphere", config -> new SphereMechanic((ConfigObject)config), "sphere");
        this.registerMechanic("add_vector", config -> new AddVectorMechanic((ConfigObject)config), "add_vec");
        this.registerMechanic("cross_product", config -> new CrossProductMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("dot_product", config -> new DotProductMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("hadamard_product", config -> new HadamardProductMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("multiply_vector", config -> new MultiplyVectorMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("normalize_vector", config -> new NormalizeVectorMechanic((ConfigObject)config), "normalize");
        this.registerMechanic("orient_vector", config -> new OrientVectorMechanic((ConfigObject)config), "orient_vec");
        this.registerMechanic("save_vector", config -> new CopyVectorMechanic((ConfigObject)config), "save_vec", "copy_vec", "copy_vector");
        this.registerMechanic("set_x", config -> new SetXMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("set_y", config -> new SetYMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("set_z", config -> new SetZMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("subtract_vector", config -> new SubtractVectorMechanic((ConfigObject)config), "sub_vec", "sub_vector", "subvec");
        this.registerMechanic("increment", config -> new IncrementMechanic((ConfigObject)config), "incr");
        this.registerMechanic("set_boolean", config -> new SetBooleanMechanic((ConfigObject)config), "set_bool");
        this.registerMechanic("set_double", config -> new SetDoubleMechanic((ConfigObject)config), "set_float");
        this.registerMechanic("set_integer", config -> new SetIntegerMechanic((ConfigObject)config), "set_int");
        this.registerMechanic("set_string", config -> new SetStringMechanic((ConfigObject)config), "set_str");
        this.registerMechanic("set_vector", config -> new SetVectorMechanic((ConfigObject)config), "set_vec");
        this.registerMechanic("particle", config -> new ParticleMechanic((ConfigObject)config), "spawn_particle", "par");
        this.registerMechanic("sound", config -> new SoundMechanic((ConfigObject)config), "play_world_sound", "play_sound", "world_sound");
        this.registerMechanic("player_sound", config -> new PlayerSoundMechanic((ConfigObject)config), "play_player_sound");
        this.registerMechanic("tell", config -> new TellMechanic((ConfigObject)config), "message", "msg", "send", "send_message", "send_msg");
        this.registerEntityTargeter("caster", config -> new CasterTargeter());
        this.registerEntityTargeter("cone", config -> new ConeTargeter((ConfigObject)config));
        this.registerEntityTargeter("nearby_entities", config -> new NearbyEntitiesTargeter((ConfigObject)config));
        this.registerEntityTargeter("nearest_entity", config -> new NearestEntityTargeter((ConfigObject)config));
        this.registerEntityTargeter("target", config -> new TargetTargeter());
        this.registerEntityTargeter("variable", config -> new VariableEntityTargeter((ConfigObject)config));
        this.registerEntityTargeter("looking_at", config -> new LookingAtTargeter((ConfigObject)config));
        this.registerLocationTargeter("caster", config -> new CasterLocationTargeter((ConfigObject)config));
        this.registerLocationTargeter("circle", config -> new CircleLocationTargeter((ConfigObject)config));
        this.registerLocationTargeter("custom", config -> new CustomLocationTargeter((ConfigObject)config));
        this.registerLocationTargeter("looking_at", config -> new io.lumine.mythic.lib.script.targeter.location.LookingAtTargeter((ConfigObject)config));
        this.registerLocationTargeter("source_location", config -> new SourceLocationTargeter());
        this.registerLocationTargeter("target", config -> new TargetEntityLocationTargeter((ConfigObject)config));
        this.registerLocationTargeter("target_location", config -> new TargetLocationTargeter());
        this.registerLocationTargeter("variable", config -> new VariableLocationTargeter((ConfigObject)config));
        this.registerCondition("boolean", config -> new BooleanCondition((ConfigObject)config), new String[0]);
        this.registerCondition("compare", config -> new CompareCondition((ConfigObject)config), new String[0]);
        this.registerCondition("in_between", config -> new InBetweenCondition((ConfigObject)config), new String[0]);
        this.registerCondition("string_equals", config -> new StringEqualsCondition((ConfigObject)config), new String[0]);
        this.registerCondition("biome", config -> new BiomeCondition((ConfigObject)config), new String[0]);
        this.registerCondition("cuboid", config -> new CuboidCondition((ConfigObject)config), new String[0]);
        this.registerCondition("distance", config -> new DistanceCondition((ConfigObject)config), new String[0]);
        this.registerCondition("world", config -> new WorldCondition((ConfigObject)config), new String[0]);
        this.registerCondition("can_target", config -> new CanTargetCondition((ConfigObject)config), "can_tgt", "cantarget", "ctgt");
        this.registerCondition("cooldown", config -> new CooldownCondition((ConfigObject)config), new String[0]);
        this.registerCondition("food", config -> new FoodCondition((ConfigObject)config), new String[0]);
        this.registerCondition("ammo", config -> new HasAmmoMechanic((ConfigObject)config), new String[0]);
        this.registerCondition("has_damage_type", config -> new HasDamageTypeCondition((ConfigObject)config), new String[0]);
        this.registerCondition("is_living", config -> new IsLivingCondition((ConfigObject)config), new String[0]);
        this.registerCondition("on_fire", config -> new OnFireCondition((ConfigObject)config), new String[0]);
        this.registerCondition("permission", config -> new PermissionCondition((ConfigObject)config), new String[0]);
        this.registerCondition("time", config -> new TimeCondition((ConfigObject)config), new String[0]);
        this.registerSkillHandlerType(config -> config.contains("mythiclib-skill-id"), config -> new MythicLibSkillHandler((ConfigurationSection)config, this.getScriptOrThrow(config.getString("mythiclib-skill-id"))));
        this.registerSkillHandlerType(config -> config.contains("mechanics"), config -> new MythicLibSkillHandler(new Script((ConfigurationSection)config)));
    }

    public void registerSkillHandlerType(Predicate<ConfigurationSection> matcher, Function<ConfigurationSection, SkillHandler> provider) {
        Validate.notNull(matcher);
        Validate.notNull(provider);
        this.skillHandlerTypes.put(matcher, provider);
    }

    @NotNull
    public SkillHandler<?> loadSkillHandler(Object obj) throws IllegalArgumentException, IllegalStateException {
        if (obj instanceof String) {
            return this.getHandlerOrThrow(UtilityMethods.enumName((String)obj));
        }
        if (obj instanceof ConfigurationSection) {
            ConfigurationSection config = (ConfigurationSection)obj;
            for (Map.Entry<Predicate<ConfigurationSection>, Function<ConfigurationSection, SkillHandler>> type : this.skillHandlerTypes.entrySet()) {
                if (!type.getKey().test(config)) continue;
                return type.getValue().apply(config);
            }
            throw new IllegalArgumentException("Could not match handler type to config");
        }
        throw new IllegalArgumentException("Provide either a string or configuration section instead of " + obj.getClass().getSimpleName());
    }

    public void registerSkillHandler(SkillHandler<?> handler) {
        Validate.isTrue(this.handlers.putIfAbsent(handler.getId(), handler) == null, "A skill handler with the same name already exists", new Object[0]);
        if (!this.registration && handler instanceof Listener) {
            Bukkit.getPluginManager().registerEvents((Listener)handler, (Plugin)MythicLib.plugin);
        }
    }

    @NotNull
    public SkillHandler<?> getHandlerOrThrow(String id) {
        return Objects.requireNonNull(this.handlers.get(id), "Could not find handler with ID '" + id + "'");
    }

    public Collection<SkillHandler> getHandlers() {
        return this.handlers.values();
    }

    @Nullable
    public SkillHandler getHandler(String handlerId) {
        return this.handlers.get(handlerId);
    }

    public void registerScript(@NotNull Script script) {
        Validate.isTrue(!this.scripts.containsKey(script.getId()), "A script with the same name already exists", new Object[0]);
        this.scripts.put(script.getId(), script);
    }

    @NotNull
    public Script getScriptOrThrow(String name) {
        return Objects.requireNonNull(this.scripts.get(name), "Could not find script with name '" + name + "'");
    }

    @NotNull
    public Script loadScript(Object obj) {
        if (obj instanceof String) {
            return this.getScriptOrThrow(obj.toString());
        }
        if (obj instanceof ConfigurationSection) {
            Script skill = new Script((ConfigurationSection)obj);
            skill.getPostLoadAction().performAction();
            return skill;
        }
        throw new IllegalArgumentException("Provide either a string or configuration section");
    }

    @NotNull
    public Collection<Script> getScripts() {
        return this.scripts.values();
    }

    @NotNull
    private String findEffectiveObjectType(String objectType, ConfigObject config) {
        if (config.contains("type")) {
            return config.getString("type");
        }
        if (config.hasKey()) {
            return config.getKey();
        }
        throw new IllegalArgumentException("Could not find " + objectType + " type");
    }

    public void registerCondition(String name, Function<ConfigObject, Condition> condition, String ... aliases) {
        Validate.isTrue(this.registration, "Condition registration is disabled", new Object[0]);
        Validate.isTrue(!this.conditions.containsKey(name), "A condition with the same name already exists", new Object[0]);
        Validate.notNull(condition, "Function cannot be null", new Object[0]);
        this.conditions.put(name, condition);
        for (String alias : aliases) {
            this.registerCondition(alias, condition, new String[0]);
        }
    }

    @NotNull
    public Condition loadCondition(ConfigObject config) {
        String key = this.findEffectiveObjectType("condition", config);
        Function<ConfigObject, Condition> supplier = this.conditions.get(key);
        Validate.notNull(supplier, "Could not match condition to '" + key + "'", new Object[0]);
        return supplier.apply(config);
    }

    public void registerMechanic(@NotNull String name, @NotNull Function<ConfigObject, Mechanic> mechanic, String ... aliases) {
        Validate.isTrue(this.registration, "Mechanic registration is disabled", new Object[0]);
        Validate.isTrue(!this.mechanics.containsKey(name), "A mechanic with the name '" + name + "' already exists", new Object[0]);
        Validate.notNull(mechanic, "Function cannot be null", new Object[0]);
        this.mechanics.put(name, mechanic);
        for (String alias : aliases) {
            this.registerMechanic(alias, mechanic, new String[0]);
        }
    }

    @NotNull
    public Mechanic loadMechanic(ConfigObject config) {
        String key = this.findEffectiveObjectType("mechanic", config);
        Function<ConfigObject, Mechanic> supplier = this.mechanics.get(key);
        Validate.notNull(supplier, "Could not match mechanic to '" + key + "'", new Object[0]);
        return supplier.apply(config);
    }

    public void registerEntityTargeter(String name, Function<ConfigObject, EntityTargeter> entityTarget) {
        Validate.isTrue(this.registration, "Targeter registration is disabled", new Object[0]);
        Validate.isTrue(!this.entityTargets.containsKey(name), "A targeter with the same name already exists", new Object[0]);
        Validate.notNull(entityTarget, "Function cannot be null", new Object[0]);
        this.entityTargets.put(name, entityTarget);
    }

    @NotNull
    public EntityTargeter loadEntityTargeter(ConfigObject config) {
        String key = this.findEffectiveObjectType("targeter", config);
        Function<ConfigObject, EntityTargeter> supplier = this.entityTargets.get(key);
        Validate.notNull(supplier, "Could not match targeter to '" + key + "'", new Object[0]);
        return supplier.apply(config);
    }

    public void registerLocationTargeter(String name, Function<ConfigObject, LocationTargeter> locationTarget) {
        Validate.isTrue(this.registration, "Targeter registration is disabled", new Object[0]);
        Validate.isTrue(!this.locationTargets.containsKey(name), "A targeter with the same name already exists", new Object[0]);
        Validate.notNull(locationTarget, "Function cannot be null", new Object[0]);
        this.locationTargets.put(name, locationTarget);
    }

    @NotNull
    public LocationTargeter loadLocationTargeter(ConfigObject config) {
        String key = this.findEffectiveObjectType("targeter", config);
        Function<ConfigObject, LocationTargeter> supplier = this.locationTargets.get(key);
        Validate.notNull(supplier, "Could not match targeter to '" + key + "'", new Object[0]);
        return supplier.apply(config);
    }

    public void initialize(boolean clearBefore) {
        if (clearBefore) {
            for (SkillHandler handler : this.handlers.values()) {
                if (!(handler instanceof Listener)) continue;
                HandlerList.unregisterAll((Listener)((Listener)handler));
            }
            this.handlers.clear();
            this.scripts.clear();
        } else {
            File scriptFolder;
            this.registration = false;
            File skillsFolder = new File(MythicLib.plugin.getDataFolder() + "/skill");
            if (!skillsFolder.exists()) {
                skillsFolder.mkdir();
            }
            if (!(scriptFolder = new File(MythicLib.plugin.getDataFolder() + "/script")).exists()) {
                UtilityMethods.loadDefaultFile("script", "elemental_attacks.yml");
                UtilityMethods.loadDefaultFile("script", "mmoitems_scripts.yml");
                UtilityMethods.loadDefaultFile("script", "example_skills.yml");
            }
            if (Bukkit.getPluginManager().getPlugin("MythicMobs") != null) {
                this.registerSkillHandlerType(config -> config.contains("mythicmobs-skill-id"), MythicMobsSkillHandler::new);
            }
            if (Bukkit.getPluginManager().getPlugin("Fabled") != null) {
                this.registerSkillHandlerType(config -> config.contains("fabled-skill-id") || config.contains("skillapi-skill-id"), FabledSkillHandler::new);
            }
        }
        try {
            JarFile file2 = new JarFile(MythicLib.plugin.getJarFile());
            Enumeration<JarEntry> enu = file2.entries();
            while (enu.hasMoreElements()) {
                String name = enu.nextElement().getName().replace("/", ".");
                if (name.contains("$") || !name.endsWith(".class") || !name.startsWith("io.lumine.mythic.lib.skill.handler.def.")) continue;
                SkillHandler ability = (SkillHandler)Class.forName(name.substring(0, name.length() - 6)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.registerSkillHandler(ability);
            }
            file2.close();
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            exception.printStackTrace();
        }
        FileUtils.loadObjectsFromFolder((Plugin)MythicLib.plugin, "script", false, (key, config) -> this.registerScript(new Script(Objects.requireNonNull(config, "Config is null"))), "Could not load script '%s' from file '%s': '%s'");
        for (Script script : this.scripts.values()) {
            try {
                ConfigurationSection config2 = script.getPostLoadAction().getCachedConfig();
                script.getPostLoadAction().performAction();
                this.registerSkillHandler(new MythicLibSkillHandler(config2, script));
            }
            catch (PostLoadException config2) {
            }
            catch (RuntimeException exception) {
                MythicLib.plugin.getLogger().log(Level.WARNING, "Could not load script '" + script.getId() + "': " + exception.getMessage());
            }
        }
        FileUtils.loadObjectsFromFolderRaw((Plugin)MythicLib.plugin, "skill", file -> {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            if (config.contains("modifiers")) {
                try {
                    this.registerSkillHandler(this.loadSkillHandler(YamlConfiguration.loadConfiguration((File)file)));
                }
                catch (RuntimeException exception) {
                    MythicLib.plugin.getLogger().log(Level.WARNING, "Could not load skill handler '" + file.getName() + "': " + exception.getMessage());
                }
            } else {
                for (String key : config.getKeys(false)) {
                    try {
                        this.registerSkillHandler(this.loadSkillHandler(config.getConfigurationSection(key)));
                    }
                    catch (RuntimeException exception) {
                        MythicLib.plugin.getLogger().log(Level.WARNING, "Could not load skill handler '" + key + "' from file '" + file.getName() + "': " + exception.getMessage());
                    }
                }
            }
        }, "Could not load skill '%s': %s");
    }
}

