/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.manager;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.element.Element;
import io.lumine.mythic.lib.module.GeneralManager;
import io.lumine.mythic.lib.module.MMOPluginImpl;
import io.lumine.mythic.lib.module.ModuleInfo;
import io.lumine.mythic.lib.util.ConfigFile;
import io.lumine.mythic.lib.util.lang3.Validate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ModuleInfo(key="elements")
public class ElementManager
extends GeneralManager {
    private final Map<String, Element> mapped = new HashMap<String, Element>();

    public ElementManager(MMOPluginImpl plugin) {
        super(plugin);
    }

    public void register(Element element) {
        Validate.isTrue(!this.mapped.containsKey(element.getId()), "An element already exists with the ID '" + element.getId() + "'", new Object[0]);
        this.mapped.put(element.getId(), element);
    }

    public void reload(boolean clearBefore) {
        if (clearBefore) {
            this.mapped.clear();
        } else {
            UtilityMethods.loadDefaultFile("", "elements.yml");
        }
        FileConfiguration config = new ConfigFile("elements").getConfig();
        for (String key : config.getKeys(false)) {
            try {
                this.register(new Element(config.getConfigurationSection(key)));
            }
            catch (RuntimeException exception) {
                MythicLib.plugin.getLogger().log(Level.WARNING, "Could not load element '" + key + "': " + exception.getMessage());
            }
        }
    }

    @NotNull
    public Element get(String id) {
        return Objects.requireNonNull(this.mapped.get(id), "No element found with ID '" + id + "'");
    }

    @Nullable
    public Element getOrNull(String id) {
        return this.mapped.get(id);
    }

    public Collection<Element> getAll() {
        return this.mapped.values();
    }
}

