/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.hologram.factory;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.hologram.Hologram;
import io.lumine.mythic.lib.hologram.HologramFactory;
import io.lumine.mythic.lib.util.lang3.Validate;
import java.util.List;
import me.filoghost.holographicdisplays.api.HolographicDisplaysAPI;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class HDHologramFactory
implements HologramFactory {
    @Override
    @NotNull
    public Hologram newHologram(@NotNull Location loc, @NotNull List<String> lines) {
        return new HologramImpl(loc, lines);
    }

    private static final class HologramImpl
    extends Hologram {
        private final me.filoghost.holographicdisplays.api.hologram.Hologram holo;
        private final List<String> lines;
        private boolean spawned = true;

        public HologramImpl(Location loc, List<String> list) {
            this.holo = HolographicDisplaysAPI.get((Plugin)MythicLib.plugin).createHologram(loc);
            this.lines = list;
            for (String line : this.lines) {
                this.holo.getLines().appendText(line);
            }
        }

        @Override
        public List<String> getLines() {
            return this.lines;
        }

        @Override
        public void updateLines(@NotNull List<String> list) {
            throw new RuntimeException("Adding lines is not supported");
        }

        @Override
        public Location getLocation() {
            return this.holo.getPosition().toLocation();
        }

        @Override
        public void updateLocation(@NotNull Location loc) {
            this.holo.setPosition(loc);
        }

        @Override
        public void despawn() {
            Validate.isTrue(this.spawned, "Hologram is already despawned", new Object[0]);
            this.holo.delete();
            this.spawned = false;
        }

        @Override
        public boolean isSpawned() {
            return this.spawned;
        }
    }
}

