/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.hologram;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.listener.option.GameIndicators;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public abstract class Hologram {
    public abstract void despawn();

    public abstract boolean isSpawned();

    public abstract void updateLocation(@NotNull Location var1);

    public void flyOut(final @NotNull GameIndicators settings, final @NotNull Vector dir) {
        new BukkitRunnable(){
            final Location loc;
            double v;
            int i;
            private final double acc;
            private static final double DT = 0.15;
            {
                this.loc = Hologram.this.getLocation().clone();
                this.v = 6.0 * settings.initialUpwardVelocity;
                this.i = 0;
                this.acc = -10.0 * settings.gravity;
            }

            public void run() {
                if (this.i == 0) {
                    dir.multiply(2.0 * settings.radialVelocity);
                }
                if ((long)this.i++ >= settings.lifespan) {
                    Hologram.this.despawn();
                    this.cancel();
                    return;
                }
                this.v += this.acc * 0.15;
                this.loc.add(dir.getX() * 0.15, this.v * 0.15, dir.getZ() * 0.15);
                Hologram.this.updateLocation(this.loc);
            }
        }.runTaskTimer((Plugin)MythicLib.plugin, 0L, settings.tickPeriod);
    }

    public abstract void updateLines(List<String> var1);

    public abstract List<String> getLines();

    public abstract Location getLocation();

    public static Hologram create(Location loc, List<String> lines) {
        return MythicLib.plugin.getHologramFactory().newHologram(loc, lines);
    }
}

