/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.data;

import fr.phoenixdevt.profiles.ProfileDataModule;
import fr.phoenixdevt.profiles.ProfileProvider;
import fr.phoenixdevt.profiles.placeholder.PlaceholderProcessor;
import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.event.SynchronizedDataLoadEvent;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.comp.profile.LegacyProfiles;
import io.lumine.mythic.lib.comp.profile.ProfileMode;
import io.lumine.mythic.lib.data.AutoSaveRunnable;
import io.lumine.mythic.lib.data.OfflineDataHolder;
import io.lumine.mythic.lib.data.SynchronizedDataHandler;
import io.lumine.mythic.lib.data.SynchronizedDataHolder;
import io.lumine.mythic.lib.util.Autosaveable;
import io.lumine.mythic.lib.util.Closeable;
import io.lumine.mythic.lib.util.Tasks;
import io.lumine.mythic.lib.util.lang3.Validate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SynchronizedDataManager<H extends SynchronizedDataHolder, O extends OfflineDataHolder>
implements Closeable {
    private final JavaPlugin owning;
    private final Map<UUID, H> activeData = Collections.synchronizedMap(new HashMap());
    private final boolean profilePlugin;
    @NotNull
    private SynchronizedDataHandler<H, O> dataHandler;
    private static final Listener FICTIVE_LISTENER = new Listener(){};

    public SynchronizedDataManager(@NotNull JavaPlugin owning, @NotNull SynchronizedDataHandler<H, O> dataHandler) {
        this(owning, dataHandler, false);
    }

    public SynchronizedDataManager(@NotNull JavaPlugin owning, @NotNull SynchronizedDataHandler<H, O> dataHandler, boolean profilePlugin) {
        this.owning = Objects.requireNonNull(owning, "Plugin cannot be null");
        this.dataHandler = Objects.requireNonNull(dataHandler, "Data handler cannot be null");
        this.profilePlugin = profilePlugin;
    }

    public void setDataHandler(@NotNull SynchronizedDataHandler<H, O> dataHandler) {
        this.dataHandler = Objects.requireNonNull(dataHandler, "Data handler cannot be null");
        dataHandler.setup();
    }

    @NotNull
    public SynchronizedDataHandler<H, O> getDataHandler() {
        return this.dataHandler;
    }

    @NotNull
    public JavaPlugin getOwningPlugin() {
        return this.owning;
    }

    @NotNull
    public H get(OfflinePlayer player) {
        return this.get(player.getUniqueId());
    }

    @NotNull
    public H get(UUID uuid) {
        return (H)Objects.requireNonNull((SynchronizedDataHolder)this.activeData.get(uuid), "Player data is not loaded");
    }

    @Nullable
    public H getOrNull(OfflinePlayer player) {
        return this.getOrNull(player.getUniqueId());
    }

    @Nullable
    public H getOrNull(UUID uuid) {
        return (H)((SynchronizedDataHolder)this.activeData.get(uuid));
    }

    @NotNull
    public O getOffline(UUID uuid) {
        return (O)(this.isLoaded(uuid) ? (OfflineDataHolder)this.activeData.get(uuid) : this.dataHandler.getOffline(uuid));
    }

    public void autosave() {
        for (SynchronizedDataHolder holder : this.getLoaded()) {
            if (!holder.isSynchronized()) continue;
            if (holder instanceof Autosaveable) {
                ((Autosaveable)((Object)holder)).prepareSaving(true);
            }
            Tasks.runAsync((Plugin)this.owning, () -> this.getDataHandler().saveData(holder, true));
        }
    }

    public void initialize(@NotNull EventPriority joinEventPriority, @NotNull EventPriority quitEventPriority) {
        Bukkit.getOnlinePlayers().forEach(this::setup);
        if (this.owning.getConfig().getBoolean("auto-save.enabled")) {
            new AutoSaveRunnable(this);
        }
        UtilityMethods.registerEvent(PlayerJoinEvent.class, FICTIVE_LISTENER, joinEventPriority, event -> this.setup(event.getPlayer()), (Plugin)this.owning, false);
        if (this.profilePlugin || MythicLib.plugin.getProfileMode() != ProfileMode.LEGACY) {
            UtilityMethods.registerEvent(PlayerQuitEvent.class, FICTIVE_LISTENER, quitEventPriority, event -> this.unregister(event.getPlayer()), (Plugin)this.owning, false);
        }
        if (!this.profilePlugin && MythicLib.plugin.hasProfiles()) {
            this.owning.getLogger().log(Level.INFO, "Hooked onto ProfileAPI");
            ProfileProvider profilePlugin = (ProfileProvider)Bukkit.getServicesManager().getRegistration(ProfileProvider.class).getProvider();
            ProfileDataModule module = (ProfileDataModule)this.newProfileDataModule();
            if (module instanceof PlaceholderProcessor) {
                profilePlugin.registerPlaceholders((PlaceholderProcessor)module);
            }
            if (MythicLib.plugin.getProfileMode() == ProfileMode.LEGACY) {
                LegacyProfiles.hook(profilePlugin, module, this, FICTIVE_LISTENER, joinEventPriority, quitEventPriority);
            }
        }
    }

    @Override
    public void close() {
        for (SynchronizedDataHolder holder : this.getLoaded()) {
            if (!holder.isSynchronized()) continue;
            if (holder instanceof Closeable) {
                ((Closeable)((Object)holder)).close();
            }
            this.getDataHandler().saveData(holder, false);
        }
        this.owning.getLogger().log(Level.INFO, "Waiting for other threads, please wait...");
        Tasks.executePendingSafe((Plugin)this.owning);
        Tasks.waitSafe((Plugin)this.owning);
        this.dataHandler.close();
    }

    @NotNull
    public CompletableFuture<Void> loadData(@NotNull H playerData) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        AtomicBoolean success = new AtomicBoolean();
        Tasks.runAsync((Plugin)this.owning, () -> success.set(this.dataHandler.loadData((SynchronizedDataHolder)playerData))).thenAccept((Consumer)Tasks.sync((Plugin)this.owning, ignored -> {
            if (!success.get()) {
                return;
            }
            if (!playerData.getMMOPlayerData().isLookup() && !playerData.getMMOPlayerData().isOnline()) {
                this.saveData(playerData);
                return;
            }
            future.complete(null);
        }));
        return future;
    }

    public CompletableFuture<Void> saveData(@NotNull H playerData) {
        return Tasks.runSafeAsync((Plugin)this.owning, () -> this.dataHandler.saveData((SynchronizedDataHolder)playerData, false));
    }

    public H setup(@NotNull Player player) {
        @NotNull SynchronizedDataHolder playerData = this.activeData.computeIfAbsent(player.getUniqueId(), uuid -> this.newPlayerData(MMOPlayerData.get(player.getUniqueId())));
        if (this.requiresSynchronizationOnLogin(playerData)) {
            this.loadData(playerData).thenAccept((Consumer)Tasks.sync((Plugin)this.owning, v -> {
                playerData.markAsSynchronized();
                Bukkit.getPluginManager().callEvent((Event)new SynchronizedDataLoadEvent(this, playerData));
            }));
        }
        return (H)playerData;
    }

    private boolean requiresSynchronizationOnLogin(@NotNull H holder) {
        if (((SynchronizedDataHolder)holder).isSynchronized()) {
            return false;
        }
        if (this.profilePlugin) {
            return true;
        }
        if (MythicLib.plugin.getProfileMode() == null) {
            return true;
        }
        if (MythicLib.plugin.getProfileMode() == ProfileMode.LEGACY) {
            return false;
        }
        if (MythicLib.plugin.getProfileMode() == ProfileMode.PROXY) {
            return ((SynchronizedDataHolder)holder).getMMOPlayerData().hasProfile();
        }
        throw new RuntimeException("Unhandled profile mode");
    }

    @NotNull
    public CompletableFuture<Void> unregister(@NotNull Player player) {
        SynchronizedDataHolder playerData = (SynchronizedDataHolder)this.activeData.remove(player.getUniqueId());
        Validate.notNull(playerData, "Could not find player data of player '" + player.getUniqueId() + "'", new Object[0]);
        if (playerData instanceof Closeable) {
            ((Closeable)((Object)playerData)).close();
        }
        return playerData.isSynchronized() ? this.saveData(playerData) : CompletableFuture.completedFuture(null);
    }

    public abstract H newPlayerData(@NotNull MMOPlayerData var1);

    public abstract Object newProfileDataModule();

    public boolean isLoaded(UUID uuid) {
        return this.activeData.containsKey(uuid);
    }

    public Collection<H> getLoaded() {
        return this.activeData.values();
    }

    @Deprecated
    public void saveAll(boolean autosave) {
        if (autosave) {
            this.autosave();
        } else {
            this.close();
        }
    }

    @Deprecated
    public void unregisterSafely(H playerData) {
        this.unregister(((SynchronizedDataHolder)playerData).getPlayer());
    }
}

