/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.data;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.data.OfflineDataHolder;
import io.lumine.mythic.lib.util.MMOPlugin;
import io.lumine.mythic.lib.util.lang3.Validate;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public abstract class SynchronizedDataHolder
implements OfflineDataHolder {
    private final MMOPlayerData playerData;
    private final MMOPlugin mmoPlugin;
    private boolean sync;

    public SynchronizedDataHolder(@NotNull MMOPlugin mmoPlugin, @NotNull MMOPlayerData playerData) {
        this.mmoPlugin = mmoPlugin;
        this.playerData = playerData;
    }

    @NotNull
    public MMOPlayerData getMMOPlayerData() {
        return this.playerData;
    }

    @Override
    @NotNull
    public UUID getUniqueId() {
        return this.playerData.getUniqueId();
    }

    @NotNull
    public UUID getProfileId() {
        return this.playerData.getProfileId();
    }

    @NotNull
    public UUID getOfficialId() {
        return this.playerData.getOfficialId();
    }

    @NotNull
    public Player getPlayer() {
        return this.playerData.getPlayer();
    }

    @NotNull
    public UUID getEffectiveId() {
        if (MythicLib.plugin.getProfileMode() == null) {
            return this.getUniqueId();
        }
        if (this.mmoPlugin.hasProfiles()) {
            return this.playerData.hasOfficialId() ? this.getOfficialId() : this.getUniqueId();
        }
        return this.playerData.hasProfile() ? this.getProfileId() : this.getUniqueId();
    }

    @Deprecated
    public boolean shouldBeSaved() {
        return this.isSynchronized();
    }

    public boolean isSynchronized() {
        return this.sync;
    }

    public void markAsSynchronized() {
        Validate.isTrue(!this.sync, "Data holder already synchronized", new Object[0]);
        Validate.isTrue(this.playerData.isOnline() || this.playerData.isLookup(), "Cannot synchronize non-lookup offline player data", new Object[0]);
        this.sync = true;
        this.playerData.markAsSynchronized(this.mmoPlugin, this);
    }
}

