/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.api.util.ui;

import io.lumine.mythic.lib.api.util.ui.PlusMinusPercent;
import io.lumine.mythic.lib.api.util.ui.QuickNumberRange;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScoreRequirements
extends QuickNumberRange {
    @NotNull
    String objectiveName;
    @Nullable
    Objective objective;

    @NotNull
    public String getObjectiveName() {
        return this.objectiveName;
    }

    @Nullable
    public Objective getObjective() {
        return this.objective;
    }

    public boolean validObjective() {
        return this.objective != null;
    }

    public ScoreRequirements(@Nullable Double min, @Nullable Double max, @NotNull String objective) {
        super(min, max);
        this.objectiveName = objective;
        this.objective = ScoreRequirements.getObjective(objective);
    }

    public ScoreRequirements(@NotNull QuickNumberRange range, @NotNull String objective) {
        super(range.getMinimumInclusive(), range.getMaximumInclusive());
        this.objectiveName = objective;
        this.objective = ScoreRequirements.getObjective(objective);
    }

    @NotNull
    public static ArrayList<ScoreRequirements> getFromCompactString(@Nullable String source) {
        String[] splitSR;
        ArrayList<ScoreRequirements> ret = new ArrayList<ScoreRequirements>();
        if (source == null) {
            return ret;
        }
        source = SilentNumbers.unwrapFromCurlyBrackets(source);
        for (String str : splitSR = source.split(",")) {
            ScoreRequirements sR = ScoreRequirements.getFromString(str);
            if (sR == null) continue;
            ret.add(sR);
        }
        return ret;
    }

    @Nullable
    public static ScoreRequirements getFromString(@Nullable String source) {
        QuickNumberRange qnr;
        String[] args;
        if (source == null) {
            return null;
        }
        if (source.contains("=") && (args = source.split("=")).length == 2 && (qnr = QuickNumberRange.getFromString(args[1])) != null) {
            return new ScoreRequirements(qnr, args[0]);
        }
        return null;
    }

    @Override
    public String toString() {
        return this.objectiveName + "=" + super.toString();
    }

    @Override
    @NotNull
    public String toStringColored() {
        if (this.validObjective()) {
            return ChatColor.GREEN + this.objectiveName + " \u00a77: \u00a7e" + super.toStringColored();
        }
        return ChatColor.RED + this.objectiveName + " \u00a77: \u00a7e" + super.toStringColored();
    }

    @Nullable
    public static Objective getObjective(@Nullable String name) {
        if (name == null) {
            return null;
        }
        ScoreboardManager manager = Bukkit.getScoreboardManager();
        if (manager == null) {
            return null;
        }
        Scoreboard targetScoreboard = manager.getMainScoreboard();
        return targetScoreboard.getObjective(name);
    }

    public static void setPlayerScore(@NotNull Objective objective, @NotNull Player player, @NotNull PlusMinusPercent score) {
        ScoreRequirements.setEntryScore(objective, player.getName(), score);
    }

    public static void setEntryScore(@NotNull Objective objective, @NotNull String entree, @NotNull PlusMinusPercent score) {
        ScoreRequirements.setEntryScore(objective, entree, SilentNumbers.round(score.apply((double)ScoreRequirements.getEntryScore(objective, entree) + 0.0)));
    }

    public static int getPlayerScore(@NotNull Objective objective, @NotNull Player player) {
        return ScoreRequirements.getEntryScore(objective, player.getName());
    }

    public static int getEntryScore(@NotNull Objective objective, @NotNull String entree) {
        Score sc = objective.getScore(entree);
        return sc.getScore();
    }

    public static void setPlayerScore(@NotNull Objective objective, @NotNull Player player, int score) {
        ScoreRequirements.setEntryScore(objective, player.getName(), score);
    }

    public static void setEntryScore(@NotNull Objective objective, @NotNull String entry, int score) {
        objective.getScore(entry).setScore(score);
    }

    public static void setEntityScore(@NotNull Objective objective, @NotNull Entity player, @NotNull PlusMinusPercent score) {
        ScoreRequirements.setEntityScore(objective, player, SilentNumbers.round(score.apply((double)ScoreRequirements.getEntityScore(objective, player) + 0.0)));
    }

    public static int getEntityScore(@NotNull Objective objective, @NotNull Entity player) {
        return objective.getScore(player.getUniqueId().toString()).getScore();
    }

    public static void setEntityScore(@NotNull Objective objective, @NotNull Entity player, int score) {
        objective.getScore(player.getUniqueId().toString()).setScore(score);
    }
}

