/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.api.util;

public enum NBTTypeHelper {
    TAG_END(0),
    BYTE(1),
    BOOLEAN(1),
    SHORT(2),
    INT(3),
    LONG(4),
    FLOAT(5),
    DOUBLE(6),
    BYTE_ARRAY(7),
    STRING(8),
    LIST(9),
    COMPOUND(10),
    INT_ARRAY(11),
    LONG_ARRAY(12);

    private final int typeId;

    private NBTTypeHelper(int id) {
        this.typeId = id;
    }

    public boolean is(int typeId) {
        return this.typeId == typeId;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public static NBTTypeHelper getFrom(Class<?> clazz) {
        if (clazz.isAssignableFrom(Byte.class) || clazz.isAssignableFrom(Boolean.class)) {
            return BYTE;
        }
        if (clazz.isAssignableFrom(Short.class)) {
            return SHORT;
        }
        if (clazz.isAssignableFrom(Integer.class)) {
            return INT;
        }
        if (clazz.isAssignableFrom(Long.class)) {
            return LONG;
        }
        if (clazz.isAssignableFrom(Double.class)) {
            return DOUBLE;
        }
        if (clazz.isAssignableFrom(Float.class)) {
            return FLOAT;
        }
        if (clazz.isAssignableFrom(String.class)) {
            return STRING;
        }
        return TAG_END;
    }
}

