/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.api.stat.api;

import io.lumine.mythic.lib.api.player.EquipmentSlot;
import io.lumine.mythic.lib.api.stat.api.InstanceModifier;
import io.lumine.mythic.lib.player.modifier.ModifierType;
import io.lumine.mythic.lib.player.modifier.PlayerModifier;
import io.lumine.mythic.lib.util.Closeable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModifiedInstance<T extends InstanceModifier> {
    protected final Map<UUID, T> modifiers = new ConcurrentHashMap<UUID, T>();

    public double getTotal(double base) {
        return this.getFilteredTotal(base, EquipmentSlot.MAIN_HAND::isCompatible, mod -> mod);
    }

    public double getFilteredTotal(double base, Predicate<T> filter) {
        return this.getFilteredTotal(base, filter, mod -> mod);
    }

    public double getTotal(double base, Function<T, T> modification) {
        return this.getFilteredTotal(base, EquipmentSlot.MAIN_HAND::isCompatible, modification);
    }

    public double getFilteredTotal(double base, Predicate<T> filter, Function<T, T> modification) {
        for (InstanceModifier mod : this.modifiers.values()) {
            if (mod.getType() != ModifierType.FLAT || !filter.test(mod)) continue;
            base += ((InstanceModifier)modification.apply(mod)).getValue();
        }
        for (InstanceModifier mod : this.modifiers.values()) {
            if (mod.getType() != ModifierType.RELATIVE || !filter.test(mod)) continue;
            base *= 1.0 + ((InstanceModifier)modification.apply(mod)).getValue() / 100.0;
        }
        return base;
    }

    @Deprecated
    @Nullable
    public T getModifier(@Nullable String key) {
        for (InstanceModifier modifier : this.modifiers.values()) {
            if (!modifier.getKey().equals(key)) continue;
            return (T)modifier;
        }
        return null;
    }

    @Nullable
    public T getModifier(@NotNull UUID uniqueId) {
        return (T)((InstanceModifier)this.modifiers.get(uniqueId));
    }

    @Deprecated
    public void addModifier(@NotNull T modifier) {
        this.removeIf(((PlayerModifier)modifier).getKey()::equals);
        this.registerModifier(modifier);
    }

    public void registerModifier(@NotNull T modifier) {
        this.modifiers.put(((PlayerModifier)modifier).getUniqueId(), modifier);
    }

    public void removeModifier(@NotNull UUID uniqueId) {
        this.modifiers.remove(uniqueId);
    }

    @Deprecated
    public void remove(@NotNull String key) {
        this.removeIf(key::equals);
    }

    public boolean isEmpty() {
        return this.modifiers.isEmpty();
    }

    public void removeIf(@NotNull Predicate<String> condition) {
        Iterator<T> iterator = this.modifiers.values().iterator();
        while (iterator.hasNext()) {
            InstanceModifier modifier = (InstanceModifier)iterator.next();
            if (!condition.test(modifier.getKey())) continue;
            if (modifier instanceof Closeable) {
                ((Closeable)((Object)modifier)).close();
            }
            iterator.remove();
        }
    }

    @NotNull
    public Collection<T> getModifiers() {
        return this.modifiers.values();
    }

    @NotNull
    public Set<UUID> getIds() {
        return this.modifiers.keySet();
    }

    @Deprecated
    @NotNull
    public Set<String> getKeys() {
        return this.modifiers.values().stream().map(mod -> mod.getKey()).collect(Collectors.toSet());
    }

    public boolean contains(String key) {
        return this.modifiers.containsKey(key);
    }
}

