/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.api.itemtype;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.itemtype.MMOItemType;
import io.lumine.mythic.lib.api.itemtype.VanillaType;
import io.lumine.mythic.lib.util.lang3.Validate;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public interface ItemType {
    public boolean matches(ItemStack var1);

    public String display();

    public int hashCode();

    public boolean equals(Object var1);

    public static ItemType fromString(String input) {
        if (input.contains(".") || input.contains("%") || input.contains("?")) {
            String[] split = input.split("[.%?]");
            Validate.isTrue(split.length == 2, "Please specify a type and ID", new Object[0]);
            return new MMOItemType(split[0], split[1]);
        }
        return new VanillaType(Material.valueOf((String)UtilityMethods.enumName(input)));
    }

    public static ItemType fromItemStack(ItemStack item) {
        NBTItem nbtItem = NBTItem.get(item);
        if (nbtItem.hasTag("MMOITEMS_ITEM_TYPE")) {
            return new MMOItemType(nbtItem.getString("MMOITEMS_ITEM_TYPE"), nbtItem.getString("MMOITEMS_ITEM_ID"));
        }
        return new VanillaType(item.getType());
    }
}

