/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.api.item;

import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.item.SupportedNBTTagValues;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import io.lumine.mythic.lib.gson.JsonArray;
import io.lumine.mythic.lib.gson.JsonElement;
import io.lumine.mythic.lib.gson.JsonObject;
import io.lumine.mythic.lib.gson.JsonParser;
import io.lumine.mythic.lib.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemTag {
    @NotNull
    private final String path;
    @NotNull
    private final Object value;
    static final String compression_STRING = "_\u00f1str";
    static final String compression_DOUBLE = "_\u00f1dbl";
    static final String compression_BOOLEAN = "_\u00f1bol";
    static final String compression_INTEGER = "_\u00f1int";
    static final String compression_SLIST = "_\u00f1lst";

    public ItemTag(@NotNull String path, @NotNull Object value) {
        this.path = path;
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ItemTag)) {
            return false;
        }
        if (!((ItemTag)obj).getValue().equals(this.getValue())) {
            return false;
        }
        return ((ItemTag)obj).getPath().equals(this.getPath());
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    @NotNull
    public Object getValue() {
        return this.value;
    }

    @Nullable
    public static ItemTag getTagAtPath(@NotNull String path, @NotNull ArrayList<ItemTag> from) {
        for (ItemTag str : from) {
            if (str == null || !path.equals(str.getPath())) continue;
            return str;
        }
        return null;
    }

    @Nullable
    public static ItemTag getTagAtPath(@NotNull String path, @NotNull NBTItem from, @NotNull SupportedNBTTagValues expect) {
        if (!from.hasTag(path)) {
            return null;
        }
        switch (expect) {
            case INTEGER: {
                return new ItemTag(path, from.getInteger(path));
            }
            case STRING: {
                return new ItemTag(path, from.getString(path));
            }
            case DOUBLE: {
                return new ItemTag(path, from.getDouble(path));
            }
        }
        return new ItemTag(path, from.getBoolean(path));
    }

    @NotNull
    public static ItemTag fromStringList(@NotNull String path, @NotNull List<String> list) {
        JsonArray array = new JsonArray();
        list.forEach(array::add);
        return ItemTag.toItemTag(path, array);
    }

    @NotNull
    public static ArrayList<String> getStringListFromTag(@NotNull ItemTag tagThatContainsAnEncodedList) {
        JsonArray parsed = ItemTag.toJsonArray(tagThatContainsAnEncodedList);
        ArrayList<String> ret = new ArrayList<String>();
        parsed.forEach(str -> ret.add(str.getAsString()));
        return ret;
    }

    @NotNull
    public static JsonArray toJsonArray(@NotNull ItemTag someTag) {
        JsonParser pJSON = new JsonParser();
        return pJSON.parse((String)someTag.getValue()).getAsJsonArray();
    }

    @NotNull
    public static ItemTag toItemTag(@NotNull String pathToAssign, @NotNull JsonArray someJsonArray) {
        return new ItemTag(pathToAssign, someJsonArray.toString());
    }

    @NotNull
    public static JsonArray compressTags(@NotNull ArrayList<ItemTag> tags) {
        JsonArray JsonList = new JsonArray();
        for (ItemTag t : tags) {
            JsonObject tagAsJson = new JsonObject();
            if (t.getValue() instanceof Integer) {
                tagAsJson.addProperty(t.getPath() + compression_INTEGER, (Integer)t.getValue());
            } else if (t.getValue() instanceof Double) {
                tagAsJson.addProperty(t.getPath() + compression_DOUBLE, (Double)t.getValue());
            } else if (t.getValue() instanceof String) {
                tagAsJson.addProperty(t.getPath() + compression_STRING, (String)t.getValue());
            } else if (t.getValue() instanceof Boolean) {
                tagAsJson.addProperty(t.getPath() + compression_BOOLEAN, (Boolean)t.getValue());
            } else if (t.getValue() instanceof List) {
                JsonArray JSONception = new JsonArray();
                for (Object e : (List)t.getValue()) {
                    if (e instanceof Number) {
                        JSONception.add(SilentNumbers.readableRounding(((Number)t.getValue()).doubleValue(), 3));
                        continue;
                    }
                    if (e instanceof String) {
                        JSONception.add((String)t.getValue());
                        continue;
                    }
                    if (!(e instanceof Boolean)) continue;
                    JSONception.add((Boolean)t.getValue());
                }
                tagAsJson.add(t.getPath() + compression_SLIST, JSONception);
            }
            JsonList.add(tagAsJson);
        }
        return JsonList;
    }

    @NotNull
    public static ArrayList<ItemTag> decompressTags(@NotNull JsonArray compressedTags) {
        ArrayList<ItemTag> returningList = new ArrayList<ItemTag>();
        for (JsonElement compressedTag : compressedTags) {
            if (!compressedTag.isJsonObject()) continue;
            JsonObject cTag = compressedTag.getAsJsonObject();
            Set<Map.Entry<String, JsonElement>> entries = cTag.entrySet();
            for (Map.Entry<String, JsonElement> entry : entries) {
                String rawPath = entry.getKey();
                String compressed_extension = rawPath.substring(rawPath.length() - compression_SLIST.length());
                String path = rawPath.substring(0, rawPath.length() - compression_SLIST.length());
                JsonElement e = entry.getValue();
                ArrayList<String> value = null;
                if (e.isJsonPrimitive()) {
                    JsonPrimitive p = e.getAsJsonPrimitive();
                    switch (compressed_extension) {
                        case "_\u00f1bol": {
                            value = p.getAsBoolean();
                            break;
                        }
                        case "_\u00f1dbl": {
                            value = p.getAsDouble();
                            break;
                        }
                        case "_\u00f1int": {
                            value = p.getAsInt();
                            break;
                        }
                        case "_\u00f1str": {
                            value = p.getAsString();
                            break;
                        }
                        case "_\u00f1lst": {
                            value = p.getAsJsonArray();
                        }
                    }
                } else if (e.isJsonArray()) {
                    JsonArray a = e.getAsJsonArray();
                    ArrayList<String> ret = new ArrayList<String>();
                    for (JsonElement str : a) {
                        ret.add(str.getAsString());
                    }
                    value = ret;
                }
                if (value == null) continue;
                returningList.add(new ItemTag(path, value));
            }
        }
        return returningList;
    }
}

