/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.api.crafting.uifilters;

import io.lumine.mythic.lib.api.crafting.uifilters.UIFilter;
import io.lumine.mythic.lib.api.crafting.uimanager.UIFilterManager;
import io.lumine.mythic.lib.api.util.ItemFactory;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackCategory;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaUIFilter
implements UIFilter {
    static ArrayList<String> materialNames = null;
    static VanillaUIFilter global;

    @Override
    @NotNull
    public String getIdentifier() {
        return "v";
    }

    @Override
    public boolean matches(@NotNull ItemStack item, @NotNull String argument, @NotNull String data, @Nullable FriendlyFeedbackProvider ffp) {
        if (!this.isValid(argument, data, ffp)) {
            return false;
        }
        if (this.cancelMatch(item, ffp)) {
            return false;
        }
        Material mat = Material.valueOf((String)argument.toUpperCase().replace(" ", "_").replace("-", "_"));
        String materialName = mat.toString().toLowerCase().replace("_", " ");
        if (item.getType().equals((Object)mat)) {
            FriendlyFeedbackProvider.log(ffp, FriendlyFeedbackCategory.SUCCESS, "Item material matched $s{0}$b. ", materialName);
            return true;
        }
        FriendlyFeedbackProvider.log(ffp, FriendlyFeedbackCategory.FAILURE, "Item material '$u{0}$b' failed to match expected material $f{1}$b. ", item.getType().toString().toLowerCase().replace("_", " "), materialName);
        return false;
    }

    @Override
    public boolean isValid(@NotNull String argument, @NotNull String data, @Nullable FriendlyFeedbackProvider ffp) {
        try {
            Material.valueOf((String)argument.toUpperCase().replace(" ", "_").replace("-", "_"));
            FriendlyFeedbackProvider.log(ffp, FriendlyFeedbackCategory.SUCCESS, "Material found, $svalidated$b. ", new String[0]);
            return true;
        }
        catch (IllegalArgumentException ignored) {
            FriendlyFeedbackProvider.log(ffp, FriendlyFeedbackCategory.ERROR, "Expected a vanilla material instead of $u{0}$b. ", argument);
            return false;
        }
    }

    @Override
    @NotNull
    public ArrayList<String> tabCompleteArgument(@NotNull String current) {
        return SilentNumbers.smartFilter(VanillaUIFilter.getMaterialNames(), current, true);
    }

    @Override
    @NotNull
    public ArrayList<String> tabCompleteData(@NotNull String argument, @NotNull String current) {
        return SilentNumbers.toArrayList("0", "(this_is_not_checked,_write_anything)");
    }

    @Override
    public boolean fullyDefinesItem() {
        return true;
    }

    @Override
    @Nullable
    public ItemStack getItemStack(@NotNull String argument, @NotNull String data, @Nullable FriendlyFeedbackProvider ffp) {
        if (!this.isValid(argument, data, ffp)) {
            return null;
        }
        Material mat = Material.valueOf((String)argument.toUpperCase().replace(" ", "_").replace("-", "_"));
        FriendlyFeedbackProvider.log(ffp, FriendlyFeedbackCategory.SUCCESS, "Successfully generated $r{0}$b. ", mat.toString().toLowerCase().replace("_", " "));
        return new ItemStack(mat);
    }

    @Override
    @NotNull
    public ItemStack getDisplayStack(@NotNull String argument, @NotNull String data, @Nullable FriendlyFeedbackProvider ffp) {
        if (!this.isValid(argument, data, ffp)) {
            return ItemFactory.of(Material.BARRIER).name("\u00a7cInvalid Material \u00a7e" + argument).build();
        }
        Material mat = Material.valueOf((String)argument.toUpperCase().replace(" ", "_").replace("-", "_"));
        FriendlyFeedbackProvider.log(ffp, FriendlyFeedbackCategory.SUCCESS, "Successfully generated $r{0}$b. ", mat.toString().toLowerCase().replace("_", " "));
        return new ItemStack(mat);
    }

    @Override
    @NotNull
    public ArrayList<String> getDescription(@NotNull String argument, @NotNull String data) {
        if (!this.isValid(argument, data, null)) {
            return SilentNumbers.toArrayList("This material is $finvalid$b.");
        }
        Material mat = Material.valueOf((String)argument.toUpperCase().replace(" ", "_").replace("-", "_"));
        return SilentNumbers.toArrayList("This item must be a $r" + mat.toString().toLowerCase().replace("_", " ") + "$b.");
    }

    @Override
    public boolean determinateGeneration() {
        return true;
    }

    static ArrayList<String> getMaterialNames() {
        if (materialNames != null) {
            return materialNames;
        }
        materialNames = new ArrayList();
        for (Material m : Material.values()) {
            materialNames.add(m.toString());
        }
        return materialNames;
    }

    @Override
    @NotNull
    public String getSourcePlugin() {
        return "MythicLib";
    }

    @Override
    @NotNull
    public String getFilterName() {
        return "Vanilla";
    }

    @Override
    @NotNull
    public String exampleArgument() {
        return "carrot";
    }

    @Override
    @NotNull
    public String exampleData() {
        return "0";
    }

    public static void register() {
        global = new VanillaUIFilter();
        UIFilterManager.registerUIFilter(global);
    }

    @NotNull
    public static VanillaUIFilter get() {
        return global;
    }
}

