/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.api.crafting.uifilters;

import io.lumine.mythic.lib.api.crafting.ingredients.MythicIngredient;
import io.lumine.mythic.lib.api.crafting.uifilters.UIFilter;
import io.lumine.mythic.lib.api.crafting.uimanager.ProvidedUIFilter;
import io.lumine.mythic.lib.api.crafting.uimanager.UIFilterManager;
import io.lumine.mythic.lib.api.util.ItemFactory;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackCategory;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IngredientUIFilter
implements UIFilter {
    static IngredientUIFilter global;

    @Override
    @NotNull
    public String getIdentifier() {
        return "i";
    }

    @Override
    public boolean matches(@NotNull ItemStack item, @NotNull String argument, @NotNull String data, @Nullable FriendlyFeedbackProvider ffp) {
        if (!this.isValid(argument, data, ffp)) {
            return false;
        }
        if (this.cancelMatch(item, ffp)) {
            return false;
        }
        MythicIngredient ingredient = MythicIngredient.get(argument);
        return ingredient.matches(item, ffp);
    }

    @Override
    public boolean isValid(@NotNull String argument, @NotNull String data, @Nullable FriendlyFeedbackProvider ffp) {
        if (MythicIngredient.get(argument) != null) {
            FriendlyFeedbackProvider.log(ffp, FriendlyFeedbackCategory.SUCCESS, "Mythic Ingredient found, $svalidated$b. ", new String[0]);
            return true;
        }
        FriendlyFeedbackProvider.log(ffp, FriendlyFeedbackCategory.ERROR, "Mythic Ingredient '$u{0}$b' not found, $frejected$b. ", argument);
        return false;
    }

    @Override
    @NotNull
    public ArrayList<String> tabCompleteArgument(@NotNull String current) {
        return SilentNumbers.smartFilter(MythicIngredient.getEnabledIngredients(), current, true);
    }

    @Override
    @NotNull
    public ArrayList<String> tabCompleteData(@NotNull String argument, @NotNull String current) {
        return SilentNumbers.toArrayList("0", "(this_is_not_checked,_write_anything)");
    }

    @Override
    public boolean fullyDefinesItem() {
        return true;
    }

    @Override
    @Nullable
    public ItemStack getItemStack(@NotNull String argument, @NotNull String data, @Nullable FriendlyFeedbackProvider ffp) {
        if (!this.isValid(argument, data, ffp)) {
            return null;
        }
        MythicIngredient ingredient = MythicIngredient.get(argument);
        return ingredient.getRandomSubstituteItem(null);
    }

    @Override
    @NotNull
    public ItemStack getDisplayStack(@NotNull String argument, @NotNull String data, @Nullable FriendlyFeedbackProvider ffp) {
        if (!this.isValid(argument, data, ffp)) {
            return ItemFactory.of(Material.BARRIER).name("\u00a7cInvalid MythicIngredient").build();
        }
        MythicIngredient ingredient = MythicIngredient.get(argument);
        return ingredient.getRandomDisplayItem(null);
    }

    @Override
    @NotNull
    public ArrayList<String> getDescription(@NotNull String argument, @NotNull String data) {
        if (!this.isValid(argument, data, null)) {
            return SilentNumbers.toArrayList("Ingredient '$u" + argument + "$b' is $finvalid$b.");
        }
        MythicIngredient ingredient = MythicIngredient.get(argument);
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("$sAny of the following:");
        for (ProvidedUIFilter puff : ingredient.getSubstitutes()) {
            String prefix = " $r\u25ba $b";
            if (puff.hasAmount()) {
                prefix = " " + puff.getAmountRange().toStringColored() + "x $b";
            }
            StringBuilder tab = new StringBuilder();
            for (int s = 0; s < prefix.length(); ++s) {
                tab.append(" ");
            }
            boolean first = true;
            String tabulation = tab.toString();
            for (String str : puff.getDescription()) {
                if (first) {
                    ret.add(prefix + str);
                    first = false;
                    continue;
                }
                ret.add(tabulation + str);
            }
        }
        return ret;
    }

    @Override
    public boolean determinateGeneration() {
        return false;
    }

    @Override
    public boolean partialDeterminateGeneration(@NotNull String argument, @NotNull String data) {
        if (!this.isValid(argument, data, null)) {
            return false;
        }
        MythicIngredient ingredient = MythicIngredient.get(argument);
        return ingredient.getSubstitutes().size() <= 1;
    }

    @Override
    @NotNull
    public String getSourcePlugin() {
        return "MythicLib";
    }

    @Override
    @NotNull
    public String getFilterName() {
        return "MythicIngredient";
    }

    @Override
    @NotNull
    public String exampleArgument() {
        return "wood_planks";
    }

    @Override
    @NotNull
    public String exampleData() {
        return "0";
    }

    public static void register() {
        ArrayList<ProvidedUIFilter> planks = new ArrayList<ProvidedUIFilter>();
        planks.add(UIFilterManager.getUIFilter("v", Material.OAK_PLANKS.toString(), "0", null, null));
        planks.add(UIFilterManager.getUIFilter("v", Material.SPRUCE_PLANKS.toString(), "0", null, null));
        planks.add(UIFilterManager.getUIFilter("v", Material.BIRCH_PLANKS.toString(), "0", null, null));
        planks.add(UIFilterManager.getUIFilter("v", Material.JUNGLE_PLANKS.toString(), "0", null, null));
        planks.add(UIFilterManager.getUIFilter("v", Material.ACACIA_PLANKS.toString(), "0", null, null));
        planks.add(UIFilterManager.getUIFilter("v", Material.DARK_OAK_PLANKS.toString(), "0", null, null));
        MythicIngredient plank = new MythicIngredient("wood_planks", planks);
        MythicIngredient.enable(plank);
        global = new IngredientUIFilter();
        UIFilterManager.registerUIFilter(global);
    }

    @NotNull
    public static IngredientUIFilter get() {
        return global;
    }
}

