/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.api.crafting.ingredients;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.crafting.uifilters.IngredientUIFilter;
import io.lumine.mythic.lib.api.crafting.uimanager.ProvidedUIFilter;
import io.lumine.mythic.lib.api.util.ItemFactory;
import io.lumine.mythic.lib.api.util.Ref;
import io.lumine.mythic.lib.api.util.ui.FFPMythicLib;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackCategory;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MythicIngredient
implements Cloneable {
    @NotNull
    final String name;
    @NotNull
    final ArrayList<ProvidedUIFilter> substitutes;
    boolean acceptsAir;
    static final HashMap<String, MythicIngredient> enabledIngredients = new HashMap();
    boolean definesItem = false;

    @NotNull
    public String getName() {
        return this.name;
    }

    public MythicIngredient(@NotNull String name, @NotNull ArrayList<ProvidedUIFilter> ingredient) {
        this.substitutes = ingredient;
        this.name = name;
        this.quantifySubstitutes();
    }

    public MythicIngredient(@NotNull String name, ProvidedUIFilter ... ingredient) {
        this.substitutes = new ArrayList();
        for (ProvidedUIFilter puff : ingredient) {
            if (puff == null) continue;
            this.substitutes.add(puff);
            if (!puff.isAir()) continue;
            this.acceptsAir = true;
        }
        this.name = name;
        this.quantifySubstitutes();
    }

    public void addSubstitute(@NotNull ProvidedUIFilter substitute) {
        if (!substitute.hasAmount()) {
            substitute.setAmount(1);
        }
        if (substitute.getParent().useInventoryMatch()) {
            return;
        }
        if (substitute.getParent() instanceof IngredientUIFilter) {
            return;
        }
        if (substitute.getParent().fullyDefinesItem()) {
            this.definesItem = true;
        }
        this.substitutes.add(substitute);
        if (substitute.isAir()) {
            this.acceptsAir = true;
        }
    }

    @NotNull
    public ArrayList<ProvidedUIFilter> getSubstitutes() {
        return new ArrayList<ProvidedUIFilter>(this.substitutes);
    }

    public void clearSubstitutes() {
        this.substitutes.clear();
        this.definesItem = false;
        this.acceptsAir = false;
    }

    void quantifySubstitutes() {
        this.definesItem = false;
        FriendlyFeedbackProvider ffp = new FriendlyFeedbackProvider(FFPMythicLib.get());
        ffp.activatePrefix(true, "Mythic Ingredient $f" + this.getName());
        for (int n = 0; n < this.substitutes.size(); ++n) {
            ProvidedUIFilter nbt = this.substitutes.get(n);
            if (nbt == null) {
                this.substitutes.remove(n);
                --n;
                ffp.log(FriendlyFeedbackCategory.ERROR, "$fNull ingredient at {0}. ", this.getName());
                continue;
            }
            if (nbt.getParent().fullyDefinesItem()) {
                this.definesItem = true;
            }
            if (!nbt.hasAmount()) {
                nbt.setAmount(1);
            }
            if (nbt.getParent().useInventoryMatch()) {
                this.substitutes.remove(nbt);
                --n;
                ffp.log(FriendlyFeedbackCategory.ERROR, "You may not use the $u{0}$b ($r{1}$b) UIFilter key to define ingredients: $fInventory-match filters are not supported for ingredients. ", nbt.getParent().getIdentifier(), nbt.getParent().getFilterName(), this.getName());
                continue;
            }
            if (!(nbt.getParent() instanceof IngredientUIFilter)) continue;
            this.substitutes.remove(nbt);
            --n;
            ffp.log(FriendlyFeedbackCategory.ERROR, "You may not use the $u{0}$b ($r{1}$b) UIFilter key to define ingredients: $fIngredient filter cannot be used to define ingredients. ", nbt.getParent().getIdentifier(), nbt.getParent().getFilterName(), this.getName());
        }
        this.acceptsAir = false;
        for (ProvidedUIFilter substitute : this.substitutes) {
            if (!substitute.isAir()) continue;
            this.acceptsAir = true;
        }
        ffp.sendTo(FriendlyFeedbackCategory.ERROR, MythicLib.plugin.getServer().getConsoleSender());
    }

    public boolean acceptsAir() {
        return this.acceptsAir;
    }

    public boolean matches(@NotNull ItemStack what, @Nullable FriendlyFeedbackProvider ffp) {
        for (ProvidedUIFilter fil : this.substitutes) {
            if (!fil.matches(what, false, ffp)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(@NotNull ItemStack what, boolean ignoreAmount, @Nullable Ref<ArrayList<ProvidedUIFilter>> matchers, boolean deepMatch, @Nullable FriendlyFeedbackProvider ffp) {
        ArrayList<ProvidedUIFilter> ref = new ArrayList<ProvidedUIFilter>();
        boolean oneMatch = false;
        for (ProvidedUIFilter fil : this.substitutes) {
            if (!fil.matches(what, ignoreAmount, ffp)) continue;
            ref.add(fil);
            if (!deepMatch) {
                Ref.setValue(matchers, ref);
                return true;
            }
            oneMatch = true;
        }
        Ref.setValue(matchers, ref);
        return oneMatch;
    }

    public static void enable(@NotNull MythicIngredient ing) {
        if (MythicIngredient.get(ing.getName()) == null) {
            enabledIngredients.put(ing.getName(), ing);
        }
    }

    @Nullable
    public static MythicIngredient get(@NotNull String name) {
        return enabledIngredients.get(name);
    }

    @NotNull
    public static ArrayList<String> getEnabledIngredients() {
        return new ArrayList<String>(enabledIngredients.keySet());
    }

    public static void deserializeFrom(@NotNull ArrayList<ConfigurationSection> configurationSections, @Nullable FriendlyFeedbackProvider ffp) {
        for (ConfigurationSection csConfig : configurationSections) {
            if (csConfig == null) {
                FriendlyFeedbackProvider.log(ffp, FriendlyFeedbackCategory.ERROR, "Found a null config in the provided list. ", new String[0]);
                continue;
            }
            for (Map.Entry val : csConfig.getValues(false).entrySet()) {
                String tName = (String)val.getKey();
                if (MythicIngredient.get(tName) != null) {
                    FriendlyFeedbackProvider.log(ffp, FriendlyFeedbackCategory.ERROR, "There is already an ingredient of name '$u{0}$b' defined. $fIgnored. ", tName);
                    continue;
                }
                ArrayList<String> cont = new ArrayList<String>();
                if (csConfig.contains(tName + ".Items")) {
                    cont = new ArrayList(csConfig.getStringList(tName + ".Items"));
                }
                if (cont.size() > 0) {
                    MythicIngredient deserializedIngredient = MythicIngredient.deserialize(tName, cont, ffp);
                    if (deserializedIngredient.getSubstitutes().size() > 0) {
                        MythicIngredient.enable(deserializedIngredient);
                        continue;
                    }
                    FriendlyFeedbackProvider.log(ffp, FriendlyFeedbackCategory.ERROR, "Ingredient of name '$u{0}$b' has no items to match. $fIgnored. ", tName);
                    continue;
                }
                FriendlyFeedbackProvider.log(ffp, FriendlyFeedbackCategory.ERROR, "Ingredient of name '$u{0}$b' has no items to match. $fIgnored. ", tName);
            }
        }
    }

    @NotNull
    public static MythicIngredient deserialize(@NotNull String ingredientName, @NotNull ArrayList<String> serializedContents, @Nullable FriendlyFeedbackProvider ffp) {
        ArrayList<ProvidedUIFilter> ret = new ArrayList<ProvidedUIFilter>();
        for (String ing : serializedContents) {
            if (ing == null || ing.isEmpty()) {
                FriendlyFeedbackProvider.log(ffp, FriendlyFeedbackCategory.ERROR, "Expected a UIFilter in the format $ekey argument data amount$b (where amount is optional) instead of a $fnull/empty$b entry.", new String[0]);
                continue;
            }
            ProvidedUIFilter puff = ProvidedUIFilter.getFromString(ing, ffp);
            if (puff == null) continue;
            ret.add(puff);
        }
        return new MythicIngredient(ingredientName, ret);
    }

    public MythicIngredient clone() {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return new MythicIngredient(this.getName(), this.getSubstitutes());
    }

    public boolean isDefinesItem() {
        return this.definesItem;
    }

    @Nullable
    public ItemStack getRandomSubstituteItem(@Nullable FriendlyFeedbackProvider ffp) {
        if (!this.isDefinesItem()) {
            return null;
        }
        Object result = null;
        ProvidedUIFilter chosen = this.getRandomSubstitute(true);
        if (chosen == null) {
            return null;
        }
        return chosen.getItemStack(ffp);
    }

    @NotNull
    public ItemStack getRandomDisplayItem(@Nullable FriendlyFeedbackProvider ffp) {
        Object result = null;
        ProvidedUIFilter chosen = this.getRandomSubstitute(false);
        if (chosen == null) {
            return ItemFactory.of(Material.STRUCTURE_VOID).name("\u00a74Internal Error:\u00a73 No Substitute").lore("\u00a76MythicLib \u00a7eio.lumine.mythic.lib.api.crafting.ingredients.MythicIngredient.getRandomDisplayItem()").build();
        }
        return chosen.getDisplayStack(ffp);
    }

    @Nullable
    public ProvidedUIFilter getRandomSubstitute(boolean requireItemFullyDefined) {
        ProvidedUIFilter ret = null;
        ArrayList<ProvidedUIFilter> poof = this.getSubstitutes();
        while (ret == null && poof.size() > 0) {
            int chosenIndex = SilentNumbers.floor(SilentNumbers.randomRange(0.0, (double)poof.size() - 0.25));
            ProvidedUIFilter puff = poof.get(chosenIndex);
            if (!requireItemFullyDefined || puff.getParent().fullyDefinesItem()) {
                ret = puff;
            }
            poof.remove(puff);
        }
        return ret;
    }
}

