/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.processors;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class Processor<T> {
    private final BlockingQueue<T> queue = new LinkedBlockingQueue<T>();
    private final Thread thread = new Thread(() -> {
        while (!Thread.interrupted()) {
            try {
                T process = this.queue.take();
                this.process(process);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    });

    public void add(T process) {
        try {
            this.queue.put(process);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    abstract void process(T var1);

    public void start() {
        this.thread.start();
    }

    public void stop() {
        this.thread.interrupt();
    }
}

