/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.processors;

import java.util.Objects;
import me.badbones69.crazyenchantments.api.CrazyEnchantments;
import me.badbones69.crazyenchantments.api.enums.CEnchantments;
import me.badbones69.crazyenchantments.api.events.AngelUseEvent;
import me.badbones69.crazyenchantments.api.events.EnchantmentUseEvent;
import me.badbones69.crazyenchantments.api.events.HellForgedUseEvent;
import me.badbones69.crazyenchantments.multisupport.Support;
import me.badbones69.crazyenchantments.multisupport.Version;
import me.badbones69.crazyenchantments.processors.Processor;
import me.badbones69.crazyenchantments.processors.RunnableSyncProcessor;
import me.badbones69.premiumhooks.anticheat.SpartanSupport;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class ArmorMoveProcessor
extends Processor<PlayerMoveEvent> {
    private final Processor<Runnable> syncProcessor;
    private final CrazyEnchantments ce = CrazyEnchantments.getInstance();
    private final Support support = Support.getInstance();

    public ArmorMoveProcessor() {
        this.syncProcessor = new RunnableSyncProcessor(this.ce.getPlugin());
    }

    @Override
    public void stop() {
        this.syncProcessor.stop();
        super.stop();
    }

    @Override
    public void start() {
        this.syncProcessor.start();
        super.start();
    }

    @Override
    public void process(PlayerMoveEvent process) {
        Player player = process.getPlayer();
        for (ItemStack armor : Objects.requireNonNull(player.getEquipment()).getArmorContents()) {
            if (!this.ce.hasEnchantments(armor)) continue;
            if (CEnchantments.NURSERY.isActivated() && this.ce.hasEnchantment(armor, CEnchantments.NURSERY)) {
                int heal = 1;
                if (CEnchantments.NURSERY.chanceSuccessful(armor)) {
                    double maxHealth;
                    double d = maxHealth = this.ce.useHealthAttributes() ? Objects.requireNonNull(player.getAttribute(Attribute.GENERIC_MAX_HEALTH)).getValue() : player.getMaxHealth();
                    if (maxHealth > player.getHealth() && player.getHealth() > 0.0) {
                        this.syncProcessor.add(() -> {
                            EnchantmentUseEvent event = new EnchantmentUseEvent(player, CEnchantments.NURSERY.getEnchantment(), armor);
                            Bukkit.getPluginManager().callEvent((Event)event);
                            if (!event.isCancelled() && player.getHealth() > 0.0) {
                                if (player.getHealth() + (double)heal <= maxHealth) {
                                    player.setHealth(player.getHealth() + (double)heal);
                                }
                                if (player.getHealth() + (double)heal >= maxHealth) {
                                    player.setHealth(maxHealth);
                                }
                            }
                        });
                    }
                }
            }
            if (CEnchantments.IMPLANTS.isActivated() && this.ce.hasEnchantment(armor, CEnchantments.IMPLANTS) && CEnchantments.IMPLANTS.chanceSuccessful(armor) && player.getFoodLevel() < 20) {
                this.syncProcessor.add(() -> {
                    EnchantmentUseEvent event = new EnchantmentUseEvent(player, CEnchantments.IMPLANTS.getEnchantment(), armor);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (!event.isCancelled()) {
                        int foodIncress = 1;
                        if (Support.SupportedPlugins.SPARTAN.isPluginLoaded()) {
                            SpartanSupport.cancelFastEat(player);
                        }
                        if (player.getFoodLevel() + foodIncress <= 20) {
                            player.setFoodLevel(player.getFoodLevel() + foodIncress);
                        }
                        if (player.getFoodLevel() + foodIncress >= 20) {
                            player.setFoodLevel(20);
                        }
                    }
                });
            }
            if (CEnchantments.ANGEL.isActivated() && this.ce.hasEnchantment(armor, CEnchantments.ANGEL) && Support.SupportedPlugins.FACTIONS_MASSIVE_CRAFT.isPluginLoaded() || Support.SupportedPlugins.FACTIONS_UUID.isPluginLoaded()) {
                int radius = 4 + this.ce.getLevel(armor, CEnchantments.ANGEL);
                this.syncProcessor.add(() -> {
                    for (Entity entity : player.getNearbyEntities((double)radius, (double)radius, (double)radius)) {
                        Player other;
                        if (!(entity instanceof Player) || !this.support.isFriendly((Entity)player, (Entity)(other = (Player)entity))) continue;
                        AngelUseEvent event = new AngelUseEvent(player, armor);
                        Bukkit.getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) continue;
                        other.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 60, 0));
                    }
                });
            }
            this.useHellForge(player, armor);
        }
        for (ItemStack item : player.getInventory().getContents()) {
            this.useHellForge(player, item);
        }
    }

    private void useHellForge(final Player player, final ItemStack item) {
        if (this.ce.hasEnchantment(item, CEnchantments.HELLFORGED)) {
            int armorDurability;
            int n = armorDurability = Version.isNewer(Version.v1_12_R1) ? ((Damageable)item.getItemMeta()).getDamage() : item.getDurability();
            if (armorDurability > 0 && CEnchantments.HELLFORGED.chanceSuccessful(item)) {
                new BukkitRunnable(){

                    public void run() {
                        int finalArmorDirability = armorDurability;
                        HellForgedUseEvent event = new HellForgedUseEvent(player, item);
                        Bukkit.getPluginManager().callEvent((Event)event);
                        if (!event.isCancelled()) {
                            finalArmorDirability -= ArmorMoveProcessor.this.ce.getLevel(item, CEnchantments.HELLFORGED);
                            if (Version.isNewer(Version.v1_12_R1)) {
                                Damageable damageable = (Damageable)item.getItemMeta();
                                if (damageable != null) {
                                    damageable.setDamage(Math.max(finalArmorDirability, 0));
                                    item.setItemMeta((ItemMeta)damageable);
                                }
                            } else {
                                item.setDurability((short)Math.max(finalArmorDirability, 0));
                            }
                        }
                    }
                }.runTask(this.ce.getPlugin());
            }
        }
    }
}

