/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.multisupport;

import org.bukkit.Bukkit;

public enum Version {
    TOO_OLD(-1),
    v1_7_R1(171),
    v1_7_R2(172),
    v1_7_R3(173),
    v1_7_R4(174),
    v1_8_R1(181),
    v1_8_R2(182),
    v1_8_R3(183),
    v1_9_R1(191),
    v1_9_R2(192),
    v1_10_R1(1101),
    v1_11_R1(1111),
    v1_12_R1(1121),
    v1_13_R2(1132),
    v1_14_R1(1141),
    v1_15_R1(1151),
    v1_16_R1(1161),
    v1_16_R2(1162),
    v1_16_R3(1163),
    TOO_NEW(-2);

    private static Version currentVersion;
    private static Version latest;
    private int versionInteger;

    private Version(int versionInteger) {
        this.versionInteger = versionInteger;
    }

    public static Version getCurrentVersion() {
        if (currentVersion == null) {
            String ver = Bukkit.getServer().getClass().getPackage().getName();
            int v = Integer.parseInt(ver.substring(ver.lastIndexOf(46) + 1).replace("_", "").replace("R", "").replace("v", ""));
            for (Version version : Version.values()) {
                if (version.getVersionInteger() != v) continue;
                currentVersion = version;
                break;
            }
            if (v > Version.getLatestVersion().getVersionInteger()) {
                currentVersion = Version.getLatestVersion();
            }
            if (currentVersion == null) {
                currentVersion = TOO_NEW;
            }
        }
        return currentVersion;
    }

    public static Version getLatestVersion() {
        if (latest == null) {
            Version v = TOO_OLD;
            for (Version version : Version.values()) {
                if (version.comparedTo(v) != 1) continue;
                v = version;
            }
            return v;
        }
        return latest;
    }

    public int getVersionInteger() {
        return this.versionInteger;
    }

    public int comparedTo(Version version) {
        int check;
        int result = -1;
        int current = this.getVersionInteger();
        if (current > (check = version.getVersionInteger()) || check == -2) {
            result = 1;
        } else if (current == check) {
            result = 0;
        } else if (check == -1) {
            result = -1;
        }
        return result;
    }

    public static boolean isNewer(Version version) {
        if (currentVersion == null) {
            Version.getCurrentVersion();
        }
        return Version.currentVersion.versionInteger > version.versionInteger || Version.currentVersion.versionInteger == -2;
    }

    public static boolean isSame(Version version) {
        if (currentVersion == null) {
            Version.getCurrentVersion();
        }
        return Version.currentVersion.versionInteger == version.versionInteger;
    }

    public static boolean isOlder(Version version) {
        if (currentVersion == null) {
            Version.getCurrentVersion();
        }
        return Version.currentVersion.versionInteger < version.versionInteger || Version.currentVersion.versionInteger == -1;
    }
}

