/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.enchantments;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import me.badbones69.crazyenchantments.Methods;
import me.badbones69.crazyenchantments.api.CrazyEnchantments;
import me.badbones69.crazyenchantments.api.enums.CEnchantments;
import me.badbones69.crazyenchantments.api.events.EnchantmentUseEvent;
import me.badbones69.crazyenchantments.api.objects.BlockProcessInfo;
import me.badbones69.crazyenchantments.api.objects.CEnchantment;
import me.badbones69.crazyenchantments.api.objects.ItemBuilder;
import me.badbones69.crazyenchantments.api.objects.TelepathyDrop;
import me.badbones69.crazyenchantments.enchantments.Hoes;
import me.badbones69.crazyenchantments.multisupport.Support;
import me.badbones69.crazyenchantments.multisupport.Version;
import me.badbones69.premiumhooks.spawners.EpicSpawnersSupport;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class Tools
implements Listener {
    private static Random random = new Random();
    private int potionTime = 100;
    private static CrazyEnchantments ce = CrazyEnchantments.getInstance();
    private static List<String> ignoreBlockTypes = Arrays.asList("air", "shulker_box", "chest", "head", "skull");

    @EventHandler
    public void onPlayerClick(final PlayerInteractEvent e) {
        new BukkitRunnable(){

            public void run() {
                Tools.this.updateEffects(e.getPlayer());
            }
        }.runTaskAsynchronously(ce.getPlugin());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockBreakEvent e) {
        List<CEnchantment> enchantments;
        Block block = e.getBlock();
        final Player player = e.getPlayer();
        if (e.isCancelled() || ce.isIgnoredEvent((Event)e) || Tools.ignoreBlockTypes(block)) {
            return;
        }
        ItemStack item = Methods.getItemInHand(player);
        new BukkitRunnable(){

            public void run() {
                Tools.this.updateEffects(player);
            }
        }.runTaskAsynchronously(ce.getPlugin());
        if (player.getGameMode() != GameMode.CREATIVE && (enchantments = ce.getEnchantmentsOnItem(item)).contains(CEnchantments.TELEPATHY.getEnchantment()) && !enchantments.contains(CEnchantments.BLAST.getEnchantment())) {
            if (Hoes.getHarvesterCrops().contains(block.getType()) && enchantments.contains(CEnchantments.HARVESTER.getEnchantment()) || !Support.SupportedPlugins.EPIC_SPAWNERS.isPluginLoaded() && block.getType() == ce.getMaterial("SPAWNER", "MOB_SPAWNER")) {
                return;
            }
            EnchantmentUseEvent event = new EnchantmentUseEvent(player, CEnchantments.TELEPATHY, item);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                e.setExpToDrop(0);
                if (Version.isNewer(Version.v1_11_R1)) {
                    e.setDropItems(false);
                }
                TelepathyDrop drop = Tools.getTelepathyDrops(new BlockProcessInfo(item, block));
                if (Methods.isInventoryFull(player)) {
                    player.getWorld().dropItem(player.getLocation(), drop.getItem());
                } else {
                    player.getInventory().addItem(new ItemStack[]{drop.getItem()});
                }
                if (drop.getSugarCaneBlocks().isEmpty()) {
                    block.setType(Material.AIR);
                } else {
                    drop.getSugarCaneBlocks().forEach(cane -> cane.setType(Material.AIR));
                }
                if (drop.hasXp()) {
                    ExperienceOrb orb = (ExperienceOrb)block.getWorld().spawn(block.getLocation().add(0.5, 0.5, 0.5), ExperienceOrb.class);
                    orb.setExperience(drop.getXp());
                }
                Methods.removeDurability(item, player);
            }
        }
    }

    public static TelepathyDrop getTelepathyDrops(BlockProcessInfo processInfo) {
        ItemStack item = processInfo.getItem();
        Block block = processInfo.getBlock();
        List<CEnchantment> enchantments = ce.getEnchantmentsOnItem(item);
        List<Object> sugarCaneBlocks = new ArrayList();
        boolean isOre = Tools.isOre(block);
        boolean hasSilkTouch = item.getItemMeta().hasEnchant(Enchantment.SILK_TOUCH);
        boolean hasFurnace = enchantments.contains(CEnchantments.FURNACE.getEnchantment());
        boolean hasAutoSmelt = enchantments.contains(CEnchantments.AUTOSMELT.getEnchantment());
        boolean hasExperience = enchantments.contains(CEnchantments.EXPERIENCE.getEnchantment());
        ItemBuilder itemDrop = null;
        int xp = 0;
        if (processInfo.isSpawner() && Support.SupportedPlugins.EPIC_SPAWNERS.isPluginLoaded()) {
            itemDrop = ItemBuilder.convertItemStack(EpicSpawnersSupport.getSpawner(block));
        } else {
            for (ItemStack drop : processInfo.getDrops()) {
                if (itemDrop == null) {
                    itemDrop = new ItemBuilder().setMaterial(drop.getType()).setAmount(0);
                }
                if (!hasSilkTouch) {
                    if (hasFurnace && isOre) {
                        itemDrop = ItemBuilder.convertItemStack(Tools.getOreDrop(block)).setAmount(0);
                    } else if (hasAutoSmelt && isOre && CEnchantments.AUTOSMELT.chanceSuccessful(item)) {
                        itemDrop = ItemBuilder.convertItemStack(Tools.getOreDrop(block)).setAmount(ce.getLevel(item, CEnchantments.AUTOSMELT));
                    }
                    if (Tools.hasOreXP(block)) {
                        xp = Methods.percentPick(7, 3);
                        if (hasExperience && CEnchantments.EXPERIENCE.chanceSuccessful(item)) {
                            xp += Methods.percentPick(7, 3) * ce.getLevel(item, CEnchantments.EXPERIENCE);
                        }
                    }
                }
                if (block.getType() == ce.getMaterial("SUGAR_CANE", "SUGAR_CANE_BLOCK")) {
                    sugarCaneBlocks = Tools.getSugarCaneBlocks(block);
                    drop.setAmount(sugarCaneBlocks.size());
                }
                itemDrop.addAmount(drop.getAmount());
            }
        }
        if (itemDrop == null) {
            itemDrop = new ItemBuilder().setMaterial(block.getType());
        }
        if (hasSilkTouch && Version.isOlder(Version.v1_14_R1)) {
            if (block.getType() == Material.ANVIL) {
                int data = block.getData();
                if (data == 4) {
                    data = 1;
                } else if (data == 8) {
                    data = 2;
                }
                itemDrop.setMaterial(block.getType()).setDamage(data);
            } else {
                itemDrop.setMaterial(block.getType()).setDamage(block.getData()).setAmount(1);
            }
        }
        if (block.getType() == Material.COCOA) {
            itemDrop.setMaterial("COCOA_BEANS", "INK_SACK:3").setAmount(ce.getNMSSupport().isFullyGrown(block) ? random.nextInt(2) + 2 : 1);
        }
        if (Version.isOlder(Version.v1_13_R2) && itemDrop.getMaterial() == Material.matchMaterial((String)"INK_SACK") && itemDrop.getDamage() != 3) {
            itemDrop.setDamage(4);
        }
        if (itemDrop.getMaterial() == Material.WHEAT || itemDrop.getMaterial() == Material.matchMaterial((String)"BEETROOT_SEEDS")) {
            itemDrop.setAmount(random.nextInt(3));
        } else if (itemDrop.getMaterial() == ce.getMaterial("POTATO", "POTATO_ITEM") || itemDrop.getMaterial() == ce.getMaterial("CARROT", "CARROT_ITEM")) {
            itemDrop.setAmount(random.nextInt(4) + 1);
        }
        return new TelepathyDrop(itemDrop.build(), xp, sugarCaneBlocks);
    }

    private static List<Block> getSugarCaneBlocks(Block block) {
        ArrayList<Block> sugarCaneBlocks = new ArrayList<Block>();
        Block cane = block;
        while (cane.getType() == ce.getMaterial("SUGAR_CANE", "SUGAR_CANE_BLOCK")) {
            sugarCaneBlocks.add(cane);
            cane = cane.getLocation().add(0.0, 1.0, 0.0).getBlock();
        }
        Collections.reverse(sugarCaneBlocks);
        return sugarCaneBlocks;
    }

    private void updateEffects(final Player player) {
        final ItemStack item = Methods.getItemInHand(player);
        if (ce.hasEnchantments(item)) {
            List<CEnchantment> enchantments = ce.getEnchantmentsOnItem(item);
            if (enchantments.contains(CEnchantments.HASTE.getEnchantment())) {
                new BukkitRunnable(){

                    public void run() {
                        EnchantmentUseEvent event = new EnchantmentUseEvent(player, CEnchantments.HASTE, item);
                        Bukkit.getPluginManager().callEvent((Event)event);
                        if (!event.isCancelled()) {
                            int power = ce.getLevel(item, CEnchantments.HASTE);
                            player.removePotionEffect(PotionEffectType.FAST_DIGGING);
                            player.addPotionEffect(new PotionEffect(PotionEffectType.FAST_DIGGING, Tools.this.potionTime, power - 1));
                        }
                    }
                }.runTask(ce.getPlugin());
            }
            if (enchantments.contains(CEnchantments.OXYGENATE.getEnchantment())) {
                new BukkitRunnable(){

                    public void run() {
                        EnchantmentUseEvent event = new EnchantmentUseEvent(player, CEnchantments.OXYGENATE, item);
                        Bukkit.getPluginManager().callEvent((Event)event);
                        if (!event.isCancelled()) {
                            player.removePotionEffect(PotionEffectType.WATER_BREATHING);
                            player.addPotionEffect(new PotionEffect(PotionEffectType.WATER_BREATHING, Tools.this.potionTime, 5));
                        }
                    }
                }.runTask(ce.getPlugin());
            }
        }
    }

    private static boolean ignoreBlockTypes(Block block) {
        for (String name : ignoreBlockTypes) {
            if (!block.getType().name().toLowerCase().contains(name)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasOreXP(Block block) {
        switch (block.getType()) {
            case COAL_ORE: 
            case DIAMOND_ORE: 
            case EMERALD_ORE: 
            case LAPIS_ORE: 
            case REDSTONE_ORE: {
                return true;
            }
        }
        return false;
    }

    private static boolean isOre(Block block) {
        if (block.getType() == ce.getMaterial("NETHER_QUARTZ_ORE", "QUARTZ_ORE")) {
            return true;
        }
        switch (block.getType()) {
            case COAL_ORE: 
            case DIAMOND_ORE: 
            case EMERALD_ORE: 
            case LAPIS_ORE: 
            case REDSTONE_ORE: 
            case IRON_ORE: 
            case GOLD_ORE: {
                return true;
            }
        }
        return false;
    }

    private static ItemStack getOreDrop(Block block) {
        ItemBuilder dropItem = new ItemBuilder();
        if (block.getType() == ce.getMaterial("NETHER_QUARTZ_ORE", "QUARTZ_ORE")) {
            dropItem.setMaterial(Material.QUARTZ);
        } else {
            switch (block.getType()) {
                case COAL_ORE: {
                    dropItem.setMaterial(Material.COAL);
                    break;
                }
                case IRON_ORE: {
                    dropItem.setMaterial(Material.IRON_INGOT);
                    break;
                }
                case GOLD_ORE: {
                    dropItem.setMaterial(Material.GOLD_INGOT);
                    break;
                }
                case DIAMOND_ORE: {
                    dropItem.setMaterial(Material.DIAMOND);
                    break;
                }
                case EMERALD_ORE: {
                    dropItem.setMaterial(Material.EMERALD);
                    break;
                }
                case LAPIS_ORE: {
                    dropItem.setMaterial("LAPIS_LAZULI", "INK_SACK:4");
                    break;
                }
                case REDSTONE_ORE: {
                    dropItem.setMaterial(Material.REDSTONE);
                    break;
                }
                default: {
                    dropItem.setMaterial(Material.AIR);
                }
            }
        }
        return dropItem.build();
    }
}

