/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.enchantments;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import me.badbones69.crazyenchantments.Methods;
import me.badbones69.crazyenchantments.api.CrazyEnchantments;
import me.badbones69.crazyenchantments.api.FileManager;
import me.badbones69.crazyenchantments.api.enums.CEnchantments;
import me.badbones69.crazyenchantments.api.events.BlastUseEvent;
import me.badbones69.crazyenchantments.api.events.EnchantmentUseEvent;
import me.badbones69.crazyenchantments.api.objects.BlockProcessInfo;
import me.badbones69.crazyenchantments.api.objects.CEnchantment;
import me.badbones69.crazyenchantments.api.objects.ItemBuilder;
import me.badbones69.crazyenchantments.api.objects.TelepathyDrop;
import me.badbones69.crazyenchantments.enchantments.Tools;
import me.badbones69.crazyenchantments.multisupport.Support;
import me.badbones69.crazyenchantments.multisupport.Version;
import me.badbones69.crazyenchantments.multisupport.anticheats.AACSupport;
import me.badbones69.crazyenchantments.multisupport.anticheats.NoCheatPlusSupport;
import me.badbones69.premiumhooks.anticheat.SpartanSupport;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;

public class PickAxes
implements Listener {
    private Random random = new Random();
    private CrazyEnchantments ce = CrazyEnchantments.getInstance();
    private HashMap<Player, HashMap<Block, BlockFace>> blocks = new HashMap();

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockClick(PlayerInteractEvent e) {
        Player player = e.getPlayer();
        if (e.getAction() == Action.LEFT_CLICK_BLOCK && CEnchantments.BLAST.isActivated()) {
            ItemStack item = Methods.getItemInHand(player);
            Block block = e.getClickedBlock();
            if (this.ce.hasEnchantment(item, CEnchantments.BLAST)) {
                HashMap<Block, BlockFace> blockFace = new HashMap<Block, BlockFace>();
                blockFace.put(block, e.getBlockFace());
                this.blocks.put(player, blockFace);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlastBreak(BlockBreakEvent e) {
        if (e.isCancelled() || this.ce.isIgnoredEvent((Event)e) || !CEnchantments.BLAST.isActivated()) {
            return;
        }
        final Player player = e.getPlayer();
        final Block block = e.getBlock();
        final ItemStack item = Methods.getItemInHand(player);
        if (this.blocks.containsKey(player)) {
            final List<CEnchantment> enchantments = this.ce.getEnchantmentsOnItem(item);
            if (this.blocks.get(player).containsKey(block) && enchantments.contains(CEnchantments.BLAST.getEnchantment())) {
                e.setCancelled(true);
                BlockFace face = this.blocks.get(player).get(block);
                this.blocks.remove(player);
                List<Block> blockList = this.getBlocks(block.getLocation(), face, this.ce.getLevel(item, CEnchantments.BLAST) - 1);
                BlastUseEvent blastUseEvent = new BlastUseEvent(player, blockList);
                Bukkit.getPluginManager().callEvent((Event)blastUseEvent);
                if (!blastUseEvent.isCancelled()) {
                    final Location originalBlockLocation = block.getLocation();
                    final ArrayList<BlockProcessInfo> finalBlockList = new ArrayList<BlockProcessInfo>();
                    for (Block b : blockList) {
                        if (b.getType() == Material.AIR || !this.ce.getBlockList().contains(b.getType()) && !b.getLocation().equals((Object)originalBlockLocation)) continue;
                        BlockBreakEvent event = new BlockBreakEvent(b, player);
                        this.ce.addIgnoredEvent((Event)event);
                        Bukkit.getPluginManager().callEvent((Event)event);
                        if (!event.isCancelled()) {
                            finalBlockList.add(new BlockProcessInfo(item, b));
                        }
                        this.ce.removeIgnoredEvent((Event)event);
                    }
                    new BukkitRunnable(){

                        public void run() {
                            HashMap<ItemStack, Integer> drops = new HashMap<ItemStack, Integer>();
                            if (Support.SupportedPlugins.NO_CHEAT_PLUS.isPluginLoaded()) {
                                NoCheatPlusSupport.exemptPlayer(player);
                            }
                            if (Support.SupportedPlugins.SPARTAN.isPluginLoaded()) {
                                SpartanSupport.cancelFastBreak(player);
                                SpartanSupport.cancelNoSwing(player);
                                SpartanSupport.cancelBlockReach(player);
                            }
                            if (Support.SupportedPlugins.AAC.isPluginLoaded()) {
                                AACSupport.exemptPlayer(player);
                            }
                            int xp = 0;
                            boolean damage = FileManager.Files.CONFIG.getFile().getBoolean("Settings.EnchantmentOptions.Blast-Full-Durability");
                            boolean isOre = PickAxes.this.isOre(block.getType());
                            boolean hasSilkTouch = item.getItemMeta().hasEnchant(Enchantment.SILK_TOUCH);
                            boolean hasTelepathy = enchantments.contains(CEnchantments.TELEPATHY.getEnchantment());
                            boolean hasFurnace = enchantments.contains(CEnchantments.FURNACE.getEnchantment());
                            boolean hasAutoSmelt = enchantments.contains(CEnchantments.AUTOSMELT.getEnchantment());
                            boolean hasExperience = enchantments.contains(CEnchantments.EXPERIENCE.getEnchantment());
                            for (BlockProcessInfo blockProcessInfo : finalBlockList) {
                                final Block block2 = blockProcessInfo.getBlock();
                                if (player.getGameMode() == GameMode.CREATIVE) {
                                    new BukkitRunnable(){

                                        public void run() {
                                            block2.setType(Material.AIR);
                                        }
                                    }.runTask(PickAxes.this.ce.getPlugin());
                                    continue;
                                }
                                if (block2.getLocation().equals((Object)originalBlockLocation) && !PickAxes.this.ce.getBlockList().contains(block2.getType())) {
                                    new BukkitRunnable(){

                                        public void run() {
                                            block2.breakNaturally();
                                        }
                                    }.runTask(PickAxes.this.ce.getPlugin());
                                    continue;
                                }
                                if (hasTelepathy) {
                                    TelepathyDrop drop = Tools.getTelepathyDrops(blockProcessInfo);
                                    drops.put(drop.getItem(), drops.getOrDefault(drop.getItem(), 0) + drop.getItem().getAmount());
                                    xp += drop.getXp();
                                } else {
                                    if (hasFurnace && isOre) {
                                        final ItemStack finalDrop = PickAxes.this.getOreDrop(block2.getType());
                                        new BukkitRunnable(){

                                            public void run() {
                                                try {
                                                    block2.getWorld().dropItem(block2.getLocation(), finalDrop);
                                                }
                                                catch (IllegalArgumentException illegalArgumentException) {
                                                    // empty catch block
                                                }
                                            }
                                        }.runTask(PickAxes.this.ce.getPlugin());
                                    } else if (hasAutoSmelt && isOre) {
                                        for (final ItemStack drop : block2.getDrops(item)) {
                                            if (CEnchantments.AUTOSMELT.chanceSuccessful(item)) {
                                                drop = PickAxes.this.getOreDrop(block2.getType());
                                                drop.setAmount(PickAxes.this.ce.getLevel(item, CEnchantments.AUTOSMELT));
                                            }
                                            final ItemStack finalDrop = drop;
                                            new BukkitRunnable(){

                                                public void run() {
                                                    try {
                                                        block2.getWorld().dropItem(block2.getLocation(), finalDrop);
                                                    }
                                                    catch (IllegalArgumentException illegalArgumentException) {
                                                        // empty catch block
                                                    }
                                                }
                                            }.runTask(PickAxes.this.ce.getPlugin());
                                        }
                                    } else {
                                        for (final ItemStack drop : block2.getDrops(item)) {
                                            if (drop.getType() != Material.AIR) {
                                                new BukkitRunnable(){

                                                    public void run() {
                                                        try {
                                                            block2.getWorld().dropItem(block2.getLocation(), drop);
                                                        }
                                                        catch (IllegalArgumentException illegalArgumentException) {
                                                            // empty catch block
                                                        }
                                                    }
                                                }.runTask(PickAxes.this.ce.getPlugin());
                                            }
                                            if (drop.getType() != Material.REDSTONE_ORE && drop.getType() != Material.LAPIS_ORE && drop.getType() != Material.GLOWSTONE) continue;
                                            break;
                                        }
                                    }
                                    if (!hasSilkTouch && isOre) {
                                        xp = Methods.percentPick(7, 3);
                                        if (hasExperience && CEnchantments.EXPERIENCE.chanceSuccessful(item)) {
                                            xp += Methods.percentPick(7, 3) * PickAxes.this.ce.getLevel(item, CEnchantments.EXPERIENCE);
                                        }
                                    }
                                }
                                new BukkitRunnable(){

                                    public void run() {
                                        block2.setType(Material.AIR);
                                    }
                                }.runTask(PickAxes.this.ce.getPlugin());
                                if (!damage) continue;
                                Methods.removeDurability(item, player);
                            }
                            if (!damage) {
                                Methods.removeDurability(item, player);
                            }
                            if (Support.SupportedPlugins.NO_CHEAT_PLUS.isPluginLoaded()) {
                                NoCheatPlusSupport.unexemptPlayer(player);
                            }
                            if (Support.SupportedPlugins.AAC.isPluginLoaded()) {
                                AACSupport.unexemptPlayer(player);
                            }
                            for (final Map.Entry entry : drops.entrySet()) {
                                ((ItemStack)entry.getKey()).setAmount(((Integer)entry.getValue()).intValue());
                                if (Methods.isInventoryFull(player)) {
                                    new BukkitRunnable(){

                                        public void run() {
                                            try {
                                                player.getWorld().dropItem(player.getLocation(), (ItemStack)entry.getKey());
                                            }
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                // empty catch block
                                            }
                                        }
                                    }.runTask(PickAxes.this.ce.getPlugin());
                                    continue;
                                }
                                player.getInventory().addItem(new ItemStack[]{(ItemStack)entry.getKey()});
                            }
                            if (player.getGameMode() != GameMode.CREATIVE && xp > 0) {
                                final int finalXp = xp;
                                new BukkitRunnable(){

                                    public void run() {
                                        ExperienceOrb orb = (ExperienceOrb)block.getWorld().spawn(block.getLocation().add(0.5, 0.5, 0.5), ExperienceOrb.class);
                                        orb.setExperience(finalXp);
                                    }
                                }.runTask(PickAxes.this.ce.getPlugin());
                            }
                        }
                    }.runTaskAsynchronously(this.ce.getPlugin());
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockBreakEvent e) {
        if (e.isCancelled() || this.ce.isIgnoredEvent((Event)e)) {
            return;
        }
        Block block = e.getBlock();
        Player player = e.getPlayer();
        ItemStack item = Methods.getItemInHand(player);
        List<CEnchantment> enchantments = this.ce.getEnchantmentsOnItem(item);
        boolean isOre = this.isOre(block.getType());
        if (player.getGameMode() != GameMode.CREATIVE) {
            ExperienceOrb orb;
            int dropAmount;
            EnchantmentUseEvent event;
            if (CEnchantments.AUTOSMELT.isActivated() && isOre && enchantments.contains(CEnchantments.AUTOSMELT.getEnchantment()) && !enchantments.contains(CEnchantments.BLAST.getEnchantment()) && !enchantments.contains(CEnchantments.FURNACE.getEnchantment()) && !enchantments.contains(CEnchantments.TELEPATHY.getEnchantment()) && CEnchantments.AUTOSMELT.chanceSuccessful(item)) {
                event = new EnchantmentUseEvent(player, CEnchantments.AUTOSMELT, item);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    dropAmount = 0;
                    dropAmount += this.ce.getLevel(item, CEnchantments.AUTOSMELT);
                    if (item.getItemMeta().hasEnchant(Enchantment.LOOT_BONUS_BLOCKS) && Methods.randomPicker(item.getEnchantmentLevel(Enchantment.LOOT_BONUS_BLOCKS), 3)) {
                        dropAmount += this.getRandomNumber(item.getEnchantmentLevel(Enchantment.LOOT_BONUS_BLOCKS));
                    }
                    try {
                        block.getWorld().dropItem(block.getLocation().add(0.5, 0.0, 0.5), this.getOreDrop(block.getType(), dropAmount));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (CEnchantments.EXPERIENCE.isActivated() && enchantments.contains(CEnchantments.EXPERIENCE.getEnchantment()) && CEnchantments.EXPERIENCE.chanceSuccessful(item)) {
                        int power = this.ce.getLevel(item, CEnchantments.EXPERIENCE);
                        if (isOre) {
                            orb = (ExperienceOrb)block.getWorld().spawn(block.getLocation(), ExperienceOrb.class);
                            orb.setExperience(Methods.percentPick(7, 3) * power);
                        }
                    }
                    if (Version.isNewer(Version.v1_11_R1)) {
                        e.setDropItems(false);
                    } else {
                        block.setType(Material.AIR);
                    }
                    Methods.removeDurability(item, player);
                }
            }
            if (CEnchantments.FURNACE.isActivated() && isOre && enchantments.contains(CEnchantments.FURNACE.getEnchantment()) && !enchantments.contains(CEnchantments.BLAST.getEnchantment()) && !enchantments.contains(CEnchantments.TELEPATHY.getEnchantment())) {
                event = new EnchantmentUseEvent(player, CEnchantments.FURNACE, item);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    dropAmount = 1;
                    if (item.getItemMeta().hasEnchant(Enchantment.LOOT_BONUS_BLOCKS) && Methods.randomPicker(item.getEnchantmentLevel(Enchantment.LOOT_BONUS_BLOCKS), 3)) {
                        dropAmount += this.getRandomNumber(item.getEnchantmentLevel(Enchantment.LOOT_BONUS_BLOCKS));
                    }
                    if (block.getType() == Material.REDSTONE_ORE || block.getType() == Material.COAL_ORE || block.getType() == Material.LAPIS_ORE) {
                        dropAmount += Methods.percentPick(4, 1).intValue();
                    }
                    try {
                        block.getWorld().dropItem(block.getLocation().add(0.5, 0.0, 0.5), this.getOreDrop(block.getType(), dropAmount));
                    }
                    catch (IllegalArgumentException power) {
                        // empty catch block
                    }
                    if (CEnchantments.EXPERIENCE.isActivated() && enchantments.contains(CEnchantments.EXPERIENCE.getEnchantment()) && CEnchantments.EXPERIENCE.chanceSuccessful(item)) {
                        int power = this.ce.getLevel(item, CEnchantments.EXPERIENCE);
                        if (isOre) {
                            orb = (ExperienceOrb)block.getWorld().spawn(block.getLocation(), ExperienceOrb.class);
                            orb.setExperience(Methods.percentPick(7, 3) * power);
                        }
                    }
                }
                if (Version.isNewer(Version.v1_11_R1)) {
                    e.setDropItems(false);
                } else {
                    block.setType(Material.AIR);
                }
                Methods.removeDurability(item, player);
            }
        }
        if (CEnchantments.EXPERIENCE.isActivated() && !this.hasSilkTouch(item) && isOre && enchantments.contains(CEnchantments.EXPERIENCE.getEnchantment()) && !enchantments.contains(CEnchantments.BLAST.getEnchantment()) && !enchantments.contains(CEnchantments.TELEPATHY.getEnchantment())) {
            int power = this.ce.getLevel(item, CEnchantments.EXPERIENCE);
            if (CEnchantments.EXPERIENCE.chanceSuccessful(item)) {
                EnchantmentUseEvent event = new EnchantmentUseEvent(player, CEnchantments.EXPERIENCE, item);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    e.setExpToDrop(e.getExpToDrop() + (power + 2));
                }
            }
        }
    }

    private boolean hasSilkTouch(ItemStack item) {
        return item.hasItemMeta() && item.getItemMeta().hasEnchant(Enchantment.SILK_TOUCH);
    }

    private List<Block> getBlocks(Location loc, BlockFace blockFace, Integer depth) {
        Location loc2 = loc.clone();
        switch (blockFace) {
            case SOUTH: {
                loc.add(-1.0, 1.0, (double)(-depth.intValue()));
                loc2.add(1.0, -1.0, 0.0);
                break;
            }
            case WEST: {
                loc.add((double)depth.intValue(), 1.0, -1.0);
                loc2.add(0.0, -1.0, 1.0);
                break;
            }
            case EAST: {
                loc.add((double)(-depth.intValue()), 1.0, 1.0);
                loc2.add(0.0, -1.0, -1.0);
                break;
            }
            case NORTH: {
                loc.add(1.0, 1.0, (double)depth.intValue());
                loc2.add(-1.0, -1.0, 0.0);
                break;
            }
            case UP: {
                loc.add(-1.0, (double)(-depth.intValue()), -1.0);
                loc2.add(1.0, 0.0, 1.0);
                break;
            }
            case DOWN: {
                loc.add(1.0, (double)depth.intValue(), 1.0);
                loc2.add(-1.0, 0.0, -1.0);
                break;
            }
        }
        ArrayList<Block> blockList = new ArrayList<Block>();
        int topBlockX = Math.max(loc.getBlockX(), loc2.getBlockX());
        int bottomBlockX = Math.min(loc.getBlockX(), loc2.getBlockX());
        int topBlockY = Math.max(loc.getBlockY(), loc2.getBlockY());
        int bottomBlockY = Math.min(loc.getBlockY(), loc2.getBlockY());
        int topBlockZ = Math.max(loc.getBlockZ(), loc2.getBlockZ());
        int bottomBlockZ = Math.min(loc.getBlockZ(), loc2.getBlockZ());
        for (int x = bottomBlockX; x <= topBlockX; ++x) {
            for (int z = bottomBlockZ; z <= topBlockZ; ++z) {
                for (int y = bottomBlockY; y <= topBlockY; ++y) {
                    blockList.add(loc.getWorld().getBlockAt(x, y, z));
                }
            }
        }
        return blockList;
    }

    private boolean isOre(Material material) {
        if (material == this.ce.getMaterial("NETHER_QUARTZ_ORE", "QUARTZ_ORE")) {
            return true;
        }
        switch (material) {
            case COAL_ORE: 
            case IRON_ORE: 
            case GOLD_ORE: 
            case DIAMOND_ORE: 
            case EMERALD_ORE: 
            case LAPIS_ORE: 
            case REDSTONE_ORE: {
                return true;
            }
        }
        return false;
    }

    private ItemStack getOreDrop(Material material) {
        return this.getOreDrop(material, 1);
    }

    private ItemStack getOreDrop(Material material, int amount) {
        ItemBuilder dropItem = new ItemBuilder().setAmount(amount);
        if (material == this.ce.getMaterial("NETHER_QUARTZ_ORE", "QUARTZ_ORE")) {
            dropItem.setMaterial(Material.QUARTZ);
        } else {
            switch (material) {
                case COAL_ORE: {
                    dropItem.setMaterial(Material.COAL);
                    break;
                }
                case IRON_ORE: {
                    dropItem.setMaterial(Material.IRON_INGOT);
                    break;
                }
                case GOLD_ORE: {
                    dropItem.setMaterial(Material.GOLD_INGOT);
                    break;
                }
                case DIAMOND_ORE: {
                    dropItem.setMaterial(Material.DIAMOND);
                    break;
                }
                case EMERALD_ORE: {
                    dropItem.setMaterial(Material.EMERALD);
                    break;
                }
                case LAPIS_ORE: {
                    dropItem.setMaterial("LAPIS_LAZULI", "INK_SACK:4");
                    break;
                }
                case REDSTONE_ORE: {
                    dropItem.setMaterial(Material.REDSTONE);
                    break;
                }
                default: {
                    dropItem.setMaterial(Material.AIR);
                }
            }
        }
        return dropItem.build();
    }

    private int getRandomNumber(int range) {
        return range > 1 ? this.random.nextInt(range > 0 ? range : 1) : 1;
    }
}

