/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.enchantments;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import me.badbones69.crazyenchantments.Methods;
import me.badbones69.crazyenchantments.api.CrazyEnchantments;
import me.badbones69.crazyenchantments.api.enums.CEnchantments;
import me.badbones69.crazyenchantments.api.objects.CEnchantment;
import me.badbones69.crazyenchantments.api.objects.ItemBuilder;
import me.badbones69.crazyenchantments.multisupport.Version;
import me.badbones69.crazyenchantments.multisupport.particles.ParticleEffect;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class Hoes
implements Listener {
    private static List<Material> harvesterCrops;
    private CrazyEnchantments ce = CrazyEnchantments.getInstance();
    private List<Material> seedlings;
    private Random random = new Random();
    private Material soilBlock = this.ce.getMaterial("FARMLAND", "SOIL");
    private Material grassBlock = this.ce.getMaterial("GRASS_BLOCK", "GRASS");
    private HashMap<Material, Material> planterSeeds;
    private HashMap<UUID, HashMap<Block, BlockFace>> blocks = new HashMap();

    public static List<Material> getHarvesterCrops() {
        if (harvesterCrops == null) {
            harvesterCrops = new ArrayList<Material>();
            if (Version.isNewer(Version.v1_8_R3) && Version.isOlder(Version.v1_13_R2)) {
                harvesterCrops.add(Material.matchMaterial((String)"BEETROOT_BLOCK"));
            }
            if (Version.isNewer(Version.v1_12_R1)) {
                harvesterCrops.addAll(Arrays.asList(Material.WHEAT, Material.matchMaterial((String)"CARROTS"), Material.matchMaterial((String)"BEETROOTS"), Material.matchMaterial((String)"POTATOES"), Material.matchMaterial((String)"NETHER_WART")));
            } else {
                harvesterCrops.addAll(Arrays.asList(Material.matchMaterial((String)"CROPS"), Material.matchMaterial((String)"CARROT"), Material.matchMaterial((String)"POTATO"), Material.matchMaterial((String)"NETHER_WARTS")));
            }
            harvesterCrops.add(Material.COCOA);
        }
        return harvesterCrops;
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent e) {
        Player player = e.getPlayer();
        if (Version.isNewer(Version.v1_8_R3) && e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (e.getAction() == Action.RIGHT_CLICK_BLOCK) {
            ItemStack hoe = Methods.getItemInHand(player);
            Block block = e.getClickedBlock();
            List<CEnchantment> enchantments = this.ce.getEnchantmentsOnItem(hoe);
            if (CEnchantments.GREENTHUMB.isActivated() && enchantments.contains(CEnchantments.GREENTHUMB.getEnchantment()) && this.getSeedlings().contains(block.getType()) && !this.ce.getNMSSupport().isFullyGrown(block)) {
                this.fullyGrowPlant(hoe, block, player);
                if (player.getGameMode() != GameMode.CREATIVE) {
                    Methods.removeDurability(hoe, player);
                }
            }
            if (block.getType() == this.grassBlock || block.getType() == Material.DIRT || block.getType() == Material.SOUL_SAND || block.getType() == this.soilBlock) {
                boolean hasGreenThumb;
                boolean bl = hasGreenThumb = CEnchantments.GREENTHUMB.isActivated() && enchantments.contains(CEnchantments.GREENTHUMB.getEnchantment());
                if (enchantments.contains(CEnchantments.TILLER.getEnchantment())) {
                    for (Block soil : this.getSoil(player, block)) {
                        if (soil.getType() != this.soilBlock && soil.getType() != Material.SOUL_SAND) {
                            soil.setType(this.soilBlock);
                        }
                        if (soil.getType() != Material.SOUL_SAND) {
                            for (Block water : this.getAreaBlocks(soil, 4)) {
                                if (water.getType() != Material.WATER && water.getType() != this.ce.getMaterial("WATER", "STATIONARY_WATER")) continue;
                                this.ce.getNMSSupport().hydrateSoil(soil);
                                break;
                            }
                        }
                        if (enchantments.contains(CEnchantments.PLANTER.getEnchantment())) {
                            this.plantSeedSuccess(hoe, soil, player, hasGreenThumb);
                        }
                        if (player.getGameMode() == GameMode.CREATIVE) continue;
                        Methods.removeDurability(hoe, player);
                    }
                }
                if (player.getGameMode() != GameMode.CREATIVE && CEnchantments.PLANTER.isActivated() && enchantments.contains(CEnchantments.PLANTER.getEnchantment()) && !enchantments.contains(CEnchantments.TILLER.getEnchantment()) && this.plantSeedSuccess(hoe, block, player, hasGreenThumb)) {
                    Methods.removeDurability(hoe, player);
                }
            }
        } else if (e.getAction() == Action.LEFT_CLICK_BLOCK && CEnchantments.HARVESTER.isActivated() && this.ce.hasEnchantment(Methods.getItemInHand(player), CEnchantments.HARVESTER)) {
            HashMap<Block, BlockFace> blockFace = new HashMap<Block, BlockFace>();
            blockFace.put(e.getClickedBlock(), e.getBlockFace());
            this.blocks.put(player.getUniqueId(), blockFace);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent e) {
        if (!e.isCancelled() && !this.ce.isIgnoredEvent((Event)e)) {
            Player player = e.getPlayer();
            Block plant = e.getBlock();
            if (Hoes.getHarvesterCrops().contains(plant.getType())) {
                ItemStack hoe = Methods.getItemInHand(player);
                List<CEnchantment> enchantments = this.ce.getEnchantmentsOnItem(hoe);
                if (this.blocks.containsKey(player.getUniqueId()) && !enchantments.isEmpty() && CEnchantments.HARVESTER.isActivated() && enchantments.contains(CEnchantments.HARVESTER.getEnchantment())) {
                    BlockFace blockFace = this.blocks.get(player.getUniqueId()).get(plant);
                    this.blocks.remove(player.getUniqueId());
                    if (this.ce.getNMSSupport().isFullyGrown(plant)) {
                        boolean hasTelepathy = enchantments.contains(CEnchantments.TELEPATHY.getEnchantment());
                        for (Block crop : this.getAreaCrops(player, plant, blockFace)) {
                            if (hasTelepathy) {
                                ArrayList<ItemStack> droppedItems = new ArrayList<ItemStack>();
                                if (crop.getType() == Material.COCOA) {
                                    droppedItems.add(new ItemBuilder().setMaterial("COCOA_BEANS", "INK_SACK:3").setAmount(this.random.nextInt(2) + 2).build());
                                } else if (crop.getType() == this.ce.getMaterial("WHEAT", "CROPS")) {
                                    droppedItems.add(new ItemBuilder().setMaterial(Material.WHEAT).build());
                                    droppedItems.add(new ItemBuilder().setMaterial("WHEAT_SEEDS", "SEEDS").setAmount(this.random.nextInt(3)).build());
                                } else if (crop.getType() == this.ce.getMaterial("BEETROOTS", "BEETROOT_BLOCK")) {
                                    droppedItems.add(new ItemBuilder().setMaterial("BEETROOT").build());
                                    droppedItems.add(new ItemBuilder().setMaterial("BEETROOT_SEEDS").setAmount(this.random.nextInt(3)).build());
                                } else if (crop.getType() == this.ce.getMaterial("POTATOES", "POTATO")) {
                                    droppedItems.add(new ItemBuilder().setMaterial("POTATO", "POTATO_ITEM").setAmount(this.random.nextInt(4) + 1).build());
                                } else if (crop.getType() == this.ce.getMaterial("CARROTS", "CARROT")) {
                                    droppedItems.add(new ItemBuilder().setMaterial("CARROT", "CARROT_ITEM").setAmount(this.random.nextInt(4) + 1).build());
                                } else if (crop.getType() == this.ce.getMaterial("NETHER_WART", "NETHER_WARTS")) {
                                    droppedItems.add(new ItemBuilder().setMaterial("NETHER_WART", "NETHER_STALK").setAmount(this.random.nextInt(3) + 2).build());
                                }
                                if (!droppedItems.isEmpty()) {
                                    for (ItemStack droppedItem : droppedItems) {
                                        if (droppedItem.getAmount() <= 0) continue;
                                        if (Methods.isInventoryFull(player)) {
                                            player.getWorld().dropItem(player.getLocation(), droppedItem);
                                            continue;
                                        }
                                        player.getInventory().addItem(new ItemStack[]{droppedItem});
                                    }
                                    if (Version.isNewer(Version.v1_11_R1)) {
                                        e.setDropItems(false);
                                    }
                                    crop.setType(Material.AIR);
                                    continue;
                                }
                            }
                            crop.breakNaturally();
                        }
                    }
                }
            }
        }
    }

    private void fullyGrowPlant(ItemStack hoe, Block block, Player player) {
        if (CEnchantments.GREENTHUMB.chanceSuccessful(hoe) || player.getGameMode() == GameMode.CREATIVE) {
            this.ce.getNMSSupport().fullyGrowPlant(block);
            if (Version.isNewer(Version.v1_8_R3)) {
                block.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, block.getLocation().add(0.5, 0.5, 0.5), 20, 0.25, 0.25, 0.25);
            } else {
                ParticleEffect.VILLAGER_HAPPY.display(0.25f, 0.25f, 0.25f, 0.0f, 20, block.getLocation().add(0.5, 0.5, 0.5), 20.0);
            }
        }
    }

    private boolean plantSeedSuccess(ItemStack hoe, Block soil, Player player, boolean hasGreenThumb) {
        boolean isSoulSand = soil.getType() == Material.SOUL_SAND;
        Material seedType = null;
        ItemStack playerSeedItem = null;
        Block plant = soil.getLocation().add(0.0, 1.0, 0.0).getBlock();
        if (plant.getType() == Material.AIR) {
            if (Version.isNewer(Version.v1_8_R3)) {
                seedType = this.getPlanterSeed(player.getEquipment().getItemInOffHand());
                playerSeedItem = player.getEquipment().getItemInOffHand();
                if (isSoulSand) {
                    if (playerSeedItem != null && playerSeedItem.getType() != this.ce.getMaterial("NETHER_WART", "NETHER_STALK")) {
                        seedType = null;
                    }
                } else if (playerSeedItem != null && playerSeedItem.getType() == this.ce.getMaterial("NETHER_WART", "NETHER_STALK")) {
                    seedType = null;
                }
            }
            if (seedType == null) {
                for (int slot = 0; slot < 9; ++slot) {
                    seedType = this.getPlanterSeed(player.getInventory().getItem(slot));
                    playerSeedItem = player.getInventory().getItem(slot);
                    if (isSoulSand) {
                        if (playerSeedItem != null && playerSeedItem.getType() != this.ce.getMaterial("NETHER_WART", "NETHER_STALK")) {
                            seedType = null;
                        }
                    } else if (playerSeedItem != null && playerSeedItem.getType() == this.ce.getMaterial("NETHER_WART", "NETHER_STALK")) {
                        seedType = null;
                    }
                    if (seedType != null) break;
                }
            }
            if (seedType != null) {
                if (soil.getType() != this.soilBlock && !isSoulSand) {
                    soil.setType(this.soilBlock);
                }
                if (player.getGameMode() != GameMode.CREATIVE) {
                    Methods.removeItem(playerSeedItem, player);
                }
                plant.setType(seedType);
                if (hasGreenThumb) {
                    this.fullyGrowPlant(hoe, plant, player);
                }
                return true;
            }
        }
        return false;
    }

    private List<Material> getSeedlings() {
        if (this.seedlings == null) {
            this.seedlings = new ArrayList<Material>();
            if (Version.isNewer(Version.v1_8_R3) && Version.isOlder(Version.v1_13_R2)) {
                this.seedlings.add(Material.matchMaterial((String)"BEETROOT_BLOCK"));
            }
            if (Version.isNewer(Version.v1_12_R1)) {
                this.seedlings.addAll(Arrays.asList(Material.WHEAT, Material.matchMaterial((String)"CARROTS"), Material.MELON_STEM, Material.PUMPKIN_STEM, Material.COCOA, Material.matchMaterial((String)"BEETROOTS"), Material.matchMaterial((String)"POTATOES"), Material.matchMaterial((String)"NETHER_WART")));
            } else {
                this.seedlings.addAll(Arrays.asList(Material.matchMaterial((String)"CROPS"), Material.matchMaterial((String)"CARROT"), Material.MELON_STEM, Material.PUMPKIN_STEM, Material.COCOA, Material.matchMaterial((String)"POTATO"), Material.matchMaterial((String)"NETHER_WARTS")));
            }
        }
        return this.seedlings;
    }

    private Material getPlanterSeed(ItemStack item) {
        return item != null ? this.getPlanterSeed(item.getType()) : null;
    }

    private Material getPlanterSeed(Material material) {
        if (this.planterSeeds == null) {
            this.planterSeeds = new HashMap();
            if (Version.isNewer(Version.v1_8_R3) && Version.isOlder(Version.v1_13_R2)) {
                this.planterSeeds.put(Material.matchMaterial((String)"BEETROOT_SEEDS"), Material.matchMaterial((String)"BEETROOT_BLOCK"));
            }
            if (Version.isNewer(Version.v1_12_R1)) {
                this.planterSeeds.put(Material.matchMaterial((String)"WHEAT_SEEDS"), Material.matchMaterial((String)"WHEAT"));
                this.planterSeeds.put(Material.matchMaterial((String)"BEETROOT_SEEDS"), Material.matchMaterial((String)"BEETROOTS"));
                this.planterSeeds.put(Material.matchMaterial((String)"POTATO"), Material.matchMaterial((String)"POTATOES"));
                this.planterSeeds.put(Material.matchMaterial((String)"CARROT"), Material.matchMaterial((String)"CARROTS"));
                this.planterSeeds.put(Material.matchMaterial((String)"NETHER_WART"), Material.matchMaterial((String)"NETHER_WART"));
            } else {
                this.planterSeeds.put(Material.matchMaterial((String)"SEEDS"), Material.matchMaterial((String)"CROPS"));
                this.planterSeeds.put(Material.matchMaterial((String)"POTATO_ITEM"), Material.matchMaterial((String)"POTATO"));
                this.planterSeeds.put(Material.matchMaterial((String)"CARROT_ITEM"), Material.matchMaterial((String)"CARROT"));
                this.planterSeeds.put(Material.matchMaterial((String)"NETHER_STALK"), Material.matchMaterial((String)"NETHER_WARTS"));
            }
            this.planterSeeds.put(Material.MELON_SEEDS, Material.MELON_STEM);
            this.planterSeeds.put(Material.PUMPKIN_SEEDS, Material.PUMPKIN_STEM);
        }
        return material != null ? this.planterSeeds.get(material) : null;
    }

    private List<Block> getAreaCrops(Player player, Block block, BlockFace blockFace) {
        ArrayList<Block> blockList = new ArrayList<Block>();
        for (Block crop : this.getAreaBlocks(block, blockFace, 0, 1)) {
            if (!Hoes.getHarvesterCrops().contains(crop.getType()) || !this.ce.getNMSSupport().isFullyGrown(crop)) continue;
            BlockBreakEvent event = new BlockBreakEvent(crop, player);
            this.ce.addIgnoredEvent((Event)event);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            blockList.add(crop);
            this.ce.removeIgnoredEvent((Event)event);
        }
        return blockList;
    }

    private List<Block> getSoil(Player player, Block block) {
        ArrayList<Block> soilBlocks = new ArrayList<Block>();
        for (Block soil : this.getAreaBlocks(block)) {
            if (soil.getType() != this.grassBlock && soil.getType() != Material.DIRT && soil.getType() != Material.SOUL_SAND && soil.getType() != this.soilBlock) continue;
            BlockBreakEvent event = new BlockBreakEvent(soil, player);
            this.ce.addIgnoredEvent((Event)event);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            soilBlocks.add(soil);
            this.ce.removeIgnoredEvent((Event)event);
        }
        return soilBlocks;
    }

    private List<Block> getAreaBlocks(Block block) {
        return this.getAreaBlocks(block, BlockFace.UP, 0, 1);
    }

    private List<Block> getAreaBlocks(Block block, int radius) {
        return this.getAreaBlocks(block, BlockFace.UP, 0, radius);
    }

    private List<Block> getAreaBlocks(Block block, BlockFace blockFace, int depth, int radius) {
        Location loc = block.getLocation();
        Location loc2 = block.getLocation();
        switch (blockFace) {
            case SOUTH: {
                loc.add((double)(-radius), (double)radius, (double)(-depth));
                loc2.add((double)radius, (double)(-radius), 0.0);
                break;
            }
            case WEST: {
                loc.add((double)depth, (double)radius, (double)(-radius));
                loc2.add(0.0, (double)(-radius), (double)radius);
                break;
            }
            case EAST: {
                loc.add((double)(-depth), (double)radius, (double)radius);
                loc2.add(0.0, (double)(-radius), (double)(-radius));
                break;
            }
            case NORTH: {
                loc.add((double)radius, (double)radius, (double)depth);
                loc2.add((double)(-radius), (double)(-radius), 0.0);
                break;
            }
            case UP: {
                loc.add((double)(-radius), (double)(-depth), (double)(-radius));
                loc2.add((double)radius, 0.0, (double)radius);
                break;
            }
            case DOWN: {
                loc.add((double)radius, (double)depth, (double)radius);
                loc2.add((double)(-radius), 0.0, (double)(-radius));
                break;
            }
        }
        ArrayList<Block> blockList = new ArrayList<Block>();
        int topBlockX = Math.max(loc.getBlockX(), loc2.getBlockX());
        int bottomBlockX = Math.min(loc.getBlockX(), loc2.getBlockX());
        int topBlockY = Math.max(loc.getBlockY(), loc2.getBlockY());
        int bottomBlockY = Math.min(loc.getBlockY(), loc2.getBlockY());
        int topBlockZ = Math.max(loc.getBlockZ(), loc2.getBlockZ());
        int bottomBlockZ = Math.min(loc.getBlockZ(), loc2.getBlockZ());
        for (int x = bottomBlockX; x <= topBlockX; ++x) {
            for (int z = bottomBlockZ; z <= topBlockZ; ++z) {
                for (int y = bottomBlockY; y <= topBlockY; ++y) {
                    blockList.add(loc.getWorld().getBlockAt(x, y, z));
                }
            }
        }
        return blockList;
    }
}

