/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.enchantments;

import java.util.ArrayList;
import java.util.List;
import me.badbones69.crazyenchantments.api.CrazyEnchantments;
import me.badbones69.crazyenchantments.api.enums.CEnchantments;
import me.badbones69.crazyenchantments.api.events.ArmorEquipEvent;
import me.badbones69.crazyenchantments.api.managers.WingsManager;
import me.badbones69.crazyenchantments.multisupport.Support;
import me.badbones69.crazyenchantments.multisupport.Version;
import me.badbones69.crazyenchantments.multisupport.particles.ParticleEffect;
import me.badbones69.premiumhooks.anticheat.SpartanSupport;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.scheduler.BukkitRunnable;

public class Boots
implements Listener {
    private static CrazyEnchantments ce = CrazyEnchantments.getInstance();
    private Support support = Support.getInstance();
    private static WingsManager manager = ce.getWingsManager();

    public static void startWings() {
        if (manager.isCloudsEnabled() && manager.isWingsEnabled()) {
            manager.setWingsTask(new BukkitRunnable(){

                public void run() {
                    for (Player player : manager.getFlyingPlayers()) {
                        if (!player.isFlying()) continue;
                        Location location = player.getLocation().subtract(0.0, 0.25, 0.0);
                        if (Version.isNewer(Version.v1_8_R3)) {
                            player.getWorld().spawnParticle(Particle.CLOUD, location, 100, 0.25, 0.0, 0.25, 0.0);
                            continue;
                        }
                        ParticleEffect.CLOUD.display(0.25f, 0.0f, 0.25f, 0.0f, 100, location, 100.0);
                    }
                }
            }.runTaskTimerAsynchronously(ce.getPlugin(), 1L, 1L));
        } else {
            manager.endWingsTask();
        }
    }

    @EventHandler
    public void onEquip(ArmorEquipEvent e) {
        Player player = e.getPlayer();
        if (manager.isWingsEnabled()) {
            if (ce.hasEnchantment(e.getNewArmorPiece(), CEnchantments.WINGS) && this.regionCheck(player) && this.gamemodeCheck(player)) {
                player.setAllowFlight(true);
            }
            if (ce.hasEnchantment(e.getOldArmorPiece(), CEnchantments.WINGS) && this.gamemodeCheck(player)) {
                player.setAllowFlight(false);
            }
        }
    }

    @EventHandler
    public void onFly(PlayerToggleFlightEvent e) {
        Player player = e.getPlayer();
        if (manager.isWingsEnabled() && ce.hasEnchantment(player.getEquipment().getBoots(), CEnchantments.WINGS) && this.regionCheck(player) && !this.areEnemiesNearby(player)) {
            if (Support.SupportedPlugins.SPARTAN.isPluginLoaded()) {
                SpartanSupport.cancelFly(player);
            }
            if (e.isFlying()) {
                if (player.getAllowFlight()) {
                    e.setCancelled(true);
                    player.setFlying(true);
                    manager.addFlyingPlayer(player);
                }
            } else {
                manager.removeFlyingPlayer(player);
            }
        }
    }

    @EventHandler
    public void onMove(PlayerMoveEvent e) {
        if (e.getFrom().getBlockX() != e.getTo().getBlockX() || e.getFrom().getBlockY() != e.getTo().getBlockY() || e.getFrom().getBlockZ() != e.getTo().getBlockZ()) {
            Player player = e.getPlayer();
            boolean isFlying = player.isFlying();
            if (manager.isWingsEnabled() && ce.hasEnchantment(player.getEquipment().getBoots(), CEnchantments.WINGS)) {
                if (this.regionCheck(player)) {
                    if (!this.areEnemiesNearby(player)) {
                        player.setAllowFlight(true);
                    } else if (isFlying && this.gamemodeCheck(player)) {
                        player.setFlying(false);
                        player.setAllowFlight(false);
                        manager.removeFlyingPlayer(player);
                    }
                } else if (isFlying && this.gamemodeCheck(player)) {
                    player.setFlying(false);
                    player.setAllowFlight(false);
                    manager.removeFlyingPlayer(player);
                }
                if (isFlying) {
                    manager.addFlyingPlayer(player);
                }
            }
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        if (manager.isWingsEnabled() && ce.hasEnchantment(player.getEquipment().getBoots(), CEnchantments.WINGS) && this.regionCheck(player) && !this.areEnemiesNearby(player)) {
            if (Support.SupportedPlugins.SPARTAN.isPluginLoaded()) {
                SpartanSupport.cancelFly(player);
            }
            player.setAllowFlight(true);
            manager.addFlyingPlayer(player);
        }
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent e) {
        Player player = e.getPlayer();
        if (manager.isWingsEnabled() && manager.isFlyingPlayer(player)) {
            player.setFlying(false);
            player.setAllowFlight(false);
            manager.removeFlyingPlayer(player);
        }
    }

    private boolean gamemodeCheck(Player player) {
        return player.getGameMode() != GameMode.CREATIVE && player.getGameMode() != GameMode.ADVENTURE;
    }

    private boolean regionCheck(Player player) {
        return manager.inLimitlessFlightWorld(player) || !manager.inBlacklistedWorld(player) && (this.support.inTerritory(player) || this.support.inWingsRegion(player) || manager.inWhitelistedWorld(player));
    }

    private boolean areEnemiesNearby(Player player) {
        if (manager.isEnemeyCheckEnabled() && !manager.inLimitlessFlightWorld(player)) {
            for (Player otherPlayer : this.getNearByPlayers(player, manager.getEnemyRadius())) {
                if (player.hasPermission("crazyenchantments.bypass.wings") && this.support.isFriendly((Entity)player, (Entity)otherPlayer)) continue;
                return true;
            }
        }
        return false;
    }

    private List<Player> getNearByPlayers(Player player, int radius) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (Entity entity : player.getNearbyEntities((double)radius, (double)radius, (double)radius)) {
            if (!(entity instanceof Player)) continue;
            players.add((Player)entity);
        }
        return players;
    }
}

