/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.enchantments;

import java.util.ArrayList;
import java.util.List;
import me.badbones69.crazyenchantments.Methods;
import me.badbones69.crazyenchantments.api.CrazyEnchantments;
import me.badbones69.crazyenchantments.api.enums.CEnchantments;
import me.badbones69.crazyenchantments.api.events.EnchantmentUseEvent;
import me.badbones69.crazyenchantments.api.objects.CEnchantment;
import me.badbones69.crazyenchantments.api.objects.ItemBuilder;
import me.badbones69.crazyenchantments.multisupport.Support;
import me.badbones69.premiumhooks.anticheat.SpartanSupport;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Axes
implements Listener {
    private CrazyEnchantments ce = CrazyEnchantments.getInstance();
    private Support support = Support.getInstance();

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDamage(EntityDamageByEntityEvent e) {
        if (e.isCancelled() || this.ce.isIgnoredEvent((Event)e)) {
            return;
        }
        if (this.support.isFriendly(e.getDamager(), e.getEntity())) {
            return;
        }
        if (e.getEntity() instanceof LivingEntity) {
            LivingEntity en = (LivingEntity)e.getEntity();
            if (e.getDamager() instanceof Player) {
                Player damager = (Player)e.getDamager();
                ItemStack item = Methods.getItemInHand(damager);
                if (!e.getEntity().isDead()) {
                    EnchantmentUseEvent event;
                    List<CEnchantment> enchantments = this.ce.getEnchantmentsOnItem(item);
                    if (CEnchantments.BERSERK.isActivated() && enchantments.contains(CEnchantments.BERSERK.getEnchantment()) && CEnchantments.BERSERK.chanceSuccessful(item)) {
                        event = new EnchantmentUseEvent(damager, CEnchantments.BERSERK.getEnchantment(), item);
                        Bukkit.getPluginManager().callEvent((Event)event);
                        if (!event.isCancelled()) {
                            damager.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_DIGGING, (this.ce.getLevel(item, CEnchantments.BERSERK) + 5) * 20, 1));
                            damager.addPotionEffect(new PotionEffect(PotionEffectType.INCREASE_DAMAGE, (this.ce.getLevel(item, CEnchantments.BERSERK) + 5) * 20, 0));
                        }
                    }
                    if (CEnchantments.BLESSED.isActivated() && enchantments.contains(CEnchantments.BLESSED.getEnchantment()) && CEnchantments.BLESSED.chanceSuccessful(item)) {
                        event = new EnchantmentUseEvent(damager, CEnchantments.BLESSED.getEnchantment(), item);
                        Bukkit.getPluginManager().callEvent((Event)event);
                        if (!event.isCancelled()) {
                            this.removeBadPotions(damager);
                        }
                    }
                    if (CEnchantments.FEEDME.isActivated() && enchantments.contains(CEnchantments.FEEDME.getEnchantment()) && CEnchantments.FEEDME.chanceSuccessful(item) && damager.getFoodLevel() < 20) {
                        event = new EnchantmentUseEvent(damager, CEnchantments.FEEDME.getEnchantment(), item);
                        Bukkit.getPluginManager().callEvent((Event)event);
                        if (!event.isCancelled()) {
                            int food = 2 * this.ce.getLevel(item, CEnchantments.FEEDME);
                            if (Support.SupportedPlugins.SPARTAN.isPluginLoaded()) {
                                SpartanSupport.cancelFastEat(damager);
                            }
                            if (damager.getFoodLevel() + food < 20) {
                                damager.setFoodLevel((int)(damager.getSaturation() + (float)food));
                            }
                            if (damager.getFoodLevel() + food > 20) {
                                damager.setFoodLevel(20);
                            }
                        }
                    }
                    if (CEnchantments.REKT.isActivated() && enchantments.contains(CEnchantments.REKT.getEnchantment())) {
                        double damage = e.getDamage() * 2.0;
                        if (CEnchantments.REKT.chanceSuccessful(item)) {
                            EnchantmentUseEvent event2 = new EnchantmentUseEvent(damager, CEnchantments.REKT.getEnchantment(), item);
                            Bukkit.getPluginManager().callEvent((Event)event2);
                            if (!event2.isCancelled()) {
                                e.setDamage(damage);
                            }
                        }
                    }
                    if (CEnchantments.CURSED.isActivated() && enchantments.contains(CEnchantments.CURSED.getEnchantment()) && CEnchantments.CURSED.chanceSuccessful(item)) {
                        EnchantmentUseEvent event3 = new EnchantmentUseEvent(damager, CEnchantments.CURSED.getEnchantment(), item);
                        Bukkit.getPluginManager().callEvent((Event)event3);
                        if (!event3.isCancelled()) {
                            en.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_DIGGING, (this.ce.getLevel(item, CEnchantments.CURSED) + 9) * 20, 1));
                        }
                    }
                    if (CEnchantments.DIZZY.isActivated() && enchantments.contains(CEnchantments.DIZZY.getEnchantment()) && CEnchantments.DIZZY.chanceSuccessful(item)) {
                        EnchantmentUseEvent event4 = new EnchantmentUseEvent(damager, CEnchantments.DIZZY.getEnchantment(), item);
                        Bukkit.getPluginManager().callEvent((Event)event4);
                        if (!event4.isCancelled()) {
                            en.addPotionEffect(new PotionEffect(PotionEffectType.CONFUSION, (this.ce.getLevel(item, CEnchantments.DIZZY) + 9) * 20, 0));
                        }
                    }
                    if (CEnchantments.BATTLECRY.isActivated() && enchantments.contains(CEnchantments.BATTLECRY.getEnchantment()) && CEnchantments.BATTLECRY.chanceSuccessful(item)) {
                        EnchantmentUseEvent event5 = new EnchantmentUseEvent(damager, CEnchantments.BATTLECRY.getEnchantment(), item);
                        Bukkit.getPluginManager().callEvent((Event)event5);
                        if (!event5.isCancelled()) {
                            for (Entity entity : damager.getNearbyEntities(3.0, 3.0, 3.0)) {
                                if (this.support.isFriendly((Entity)damager, entity)) continue;
                                entity.setVelocity(entity.getLocation().toVector().subtract(damager.getLocation().toVector()).normalize().setY(0.5));
                            }
                        }
                    }
                }
            }
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent e) {
        Player damager;
        ItemStack item;
        Player player = e.getEntity();
        if (this.support.allowsPVP(player.getLocation()) && e.getEntity().getKiller() instanceof Player && this.ce.hasEnchantment(item = Methods.getItemInHand(damager = e.getEntity().getKiller()), CEnchantments.DECAPITATION) && CEnchantments.DECAPITATION.chanceSuccessful(item)) {
            EnchantmentUseEvent event = new EnchantmentUseEvent(damager, CEnchantments.DECAPITATION.getEnchantment(), item);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                e.getDrops().add(new ItemBuilder().setMaterial("PLAYER_HEAD", "397:3").setPlayer(player.getName()).build());
            }
        }
    }

    private void removeBadPotions(Player player) {
        ArrayList<PotionEffectType> bad = new ArrayList<PotionEffectType>();
        bad.add(PotionEffectType.BLINDNESS);
        bad.add(PotionEffectType.CONFUSION);
        bad.add(PotionEffectType.HUNGER);
        bad.add(PotionEffectType.POISON);
        bad.add(PotionEffectType.SLOW);
        bad.add(PotionEffectType.SLOW_DIGGING);
        bad.add(PotionEffectType.WEAKNESS);
        bad.add(PotionEffectType.WITHER);
        for (PotionEffectType p : bad) {
            if (!player.hasPotionEffect(p)) continue;
            player.removePotionEffect(p);
        }
    }
}

