/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.enchantments;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.badbones69.crazyenchantments.Methods;
import me.badbones69.crazyenchantments.api.CrazyEnchantments;
import me.badbones69.crazyenchantments.api.FileManager;
import me.badbones69.crazyenchantments.api.enums.CEnchantments;
import me.badbones69.crazyenchantments.api.events.ArmorEquipEvent;
import me.badbones69.crazyenchantments.api.events.AuraActiveEvent;
import me.badbones69.crazyenchantments.api.events.EnchantmentUseEvent;
import me.badbones69.crazyenchantments.api.objects.ArmorEnchantment;
import me.badbones69.crazyenchantments.api.objects.PotionEffects;
import me.badbones69.crazyenchantments.controllers.ProtectionCrystal;
import me.badbones69.crazyenchantments.multisupport.Support;
import me.badbones69.crazyenchantments.multisupport.Version;
import me.badbones69.crazyenchantments.multisupport.anticheats.AACSupport;
import me.badbones69.crazyenchantments.multisupport.anticheats.NoCheatPlusSupport;
import me.badbones69.crazyenchantments.multisupport.particles.ParticleEffect;
import me.badbones69.crazyenchantments.processors.ArmorMoveProcessor;
import me.badbones69.crazyenchantments.processors.Processor;
import me.badbones69.premiumhooks.anticheat.SpartanSupport;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class Armor
implements Listener {
    private List<Player> fall = new ArrayList<Player>();
    private HashMap<Player, HashMap<CEnchantments, Calendar>> timer = new HashMap();
    private CrazyEnchantments ce = CrazyEnchantments.getInstance();
    private Support support = Support.getInstance();
    private final Processor<PlayerMoveEvent> armorMoveProcessor = new ArmorMoveProcessor();

    public Armor() {
        this.armorMoveProcessor.start();
    }

    public void stop() {
        this.armorMoveProcessor.stop();
    }

    @EventHandler
    public void onEquip(ArmorEquipEvent e) {
        final Player player = e.getPlayer();
        final ItemStack newItem = e.getNewArmorPiece();
        final ItemStack oldItem = e.getOldArmorPiece();
        new BukkitRunnable(){

            public void run() {
                Map<PotionEffectType, Integer> effects;
                if (Armor.this.ce.hasEnchantments(oldItem)) {
                    for (final CEnchantments enchantment : Armor.this.ce.getEnchantmentPotions().keySet()) {
                        if (!enchantment.isActivated() || !Armor.this.ce.hasEnchantment(oldItem, enchantment.getEnchantment())) continue;
                        effects = Armor.this.ce.getUpdatedEffects(player, new ItemStack(Material.AIR), oldItem, enchantment);
                        new BukkitRunnable(){

                            public void run() {
                                for (Map.Entry type : effects.entrySet()) {
                                    if ((Integer)type.getValue() < 0) {
                                        player.removePotionEffect((PotionEffectType)type.getKey());
                                        continue;
                                    }
                                    player.removePotionEffect((PotionEffectType)type.getKey());
                                    player.addPotionEffect(new PotionEffect((PotionEffectType)type.getKey(), Integer.MAX_VALUE, ((Integer)type.getValue()).intValue()));
                                }
                            }
                        }.runTask(Armor.this.ce.getPlugin());
                    }
                }
                if (Armor.this.ce.hasEnchantments(newItem)) {
                    for (final CEnchantments enchantment : Armor.this.ce.getEnchantmentPotions().keySet()) {
                        if (!enchantment.isActivated() || !Armor.this.ce.hasEnchantment(newItem, enchantment.getEnchantment())) continue;
                        effects = Armor.this.ce.getUpdatedEffects(player, newItem, oldItem, enchantment);
                        new BukkitRunnable(){

                            public void run() {
                                EnchantmentUseEvent event = new EnchantmentUseEvent(player, enchantment.getEnchantment(), newItem);
                                Bukkit.getPluginManager().callEvent((Event)event);
                                if (!event.isCancelled()) {
                                    for (Map.Entry type : effects.entrySet()) {
                                        if ((Integer)type.getValue() < 0) {
                                            player.removePotionEffect((PotionEffectType)type.getKey());
                                            continue;
                                        }
                                        player.removePotionEffect((PotionEffectType)type.getKey());
                                        player.addPotionEffect(new PotionEffect((PotionEffectType)type.getKey(), Integer.MAX_VALUE, ((Integer)type.getValue()).intValue()));
                                    }
                                }
                            }
                        }.runTask(Armor.this.ce.getPlugin());
                    }
                }
            }
        }.runTaskAsynchronously(this.ce.getPlugin());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerDamage(final EntityDamageByEntityEvent e) {
        if (e.isCancelled() || this.ce.isIgnoredEvent((Event)e) || this.ce.isIgnoredUUID(e.getDamager().getUniqueId())) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                if (Armor.this.support.isFriendly(e.getDamager(), e.getEntity())) {
                    return;
                }
                if (e.getDamager() instanceof LivingEntity && e.getEntity() instanceof Player) {
                    final Player player = (Player)e.getEntity();
                    final LivingEntity damager = (LivingEntity)e.getDamager();
                    for (final ItemStack armor : player.getEquipment().getArmorContents()) {
                        if (!Armor.this.ce.hasEnchantments(armor)) continue;
                        for (final ArmorEnchantment armorEnchantment : Armor.this.ce.getArmorManager().getArmorEnchantments()) {
                            final CEnchantments enchantment = armorEnchantment.getEnchantment();
                            if (!Armor.this.ce.hasEnchantment(armor, enchantment) || !enchantment.chanceSuccessful(armor)) continue;
                            new BukkitRunnable(){

                                public void run() {
                                    EnchantmentUseEvent event = new EnchantmentUseEvent(player, enchantment, armor);
                                    Bukkit.getPluginManager().callEvent((Event)event);
                                    if (!event.isCancelled()) {
                                        if (armorEnchantment.isPotionEnchantment()) {
                                            for (PotionEffects effect : armorEnchantment.getPotionEffects()) {
                                                damager.addPotionEffect(new PotionEffect(effect.getPotionEffect(), effect.getDuration(), (armorEnchantment.isLevelAddedToAmplifier() ? Armor.this.ce.getLevel(armor, enchantment) : 0) + effect.getAmplifier()));
                                            }
                                        } else {
                                            e.setDamage(e.getDamage() * ((double)(armorEnchantment.isLevelAddedToAmplifier() ? Armor.this.ce.getLevel(armor, enchantment) : 0) + armorEnchantment.getDamageAmplifier()));
                                        }
                                    }
                                }
                            }.runTask(Armor.this.ce.getPlugin());
                        }
                        if (player.getHealth() <= 8.0 && Armor.this.ce.hasEnchantment(armor, CEnchantments.ROCKET.getEnchantment()) && CEnchantments.ROCKET.chanceSuccessful(armor)) {
                            new BukkitRunnable(){

                                public void run() {
                                    EnchantmentUseEvent event = new EnchantmentUseEvent(player, CEnchantments.ROCKET.getEnchantment(), armor);
                                    Bukkit.getPluginManager().callEvent((Event)event);
                                    if (Support.SupportedPlugins.AAC.isPluginLoaded()) {
                                        AACSupport.exemptPlayerTime(player);
                                    }
                                    if (!event.isCancelled()) {
                                        new BukkitRunnable(){

                                            public void run() {
                                                player.setVelocity(player.getLocation().toVector().subtract(damager.getLocation().toVector()).normalize().setY(1));
                                            }
                                        }.runTaskLater(Armor.this.ce.getPlugin(), 1L);
                                        Armor.this.fall.add(player);
                                        if (Version.isNewer(Version.v1_8_R3)) {
                                            player.getWorld().spawnParticle(Particle.EXPLOSION_HUGE, player.getLocation(), 1);
                                        } else {
                                            ParticleEffect.EXPLOSION_HUGE.display(0.0f, 0.0f, 0.0f, 1.0f, 1, player.getLocation(), 100.0);
                                        }
                                        new BukkitRunnable(){

                                            public void run() {
                                                Armor.this.fall.remove(player);
                                            }
                                        }.runTaskLater(Armor.this.ce.getPlugin(), 160L);
                                    }
                                }
                            }.runTask(Armor.this.ce.getPlugin());
                        }
                        if (Armor.this.ce.hasEnchantment(armor, CEnchantments.ENLIGHTENED) && CEnchantments.ENLIGHTENED.chanceSuccessful(armor) && player.getHealth() > 0.0) {
                            new BukkitRunnable(){

                                public void run() {
                                    EnchantmentUseEvent event = new EnchantmentUseEvent(player, CEnchantments.ENLIGHTENED.getEnchantment(), armor);
                                    Bukkit.getPluginManager().callEvent((Event)event);
                                    if (!event.isCancelled()) {
                                        double maxHealth;
                                        double heal = Armor.this.ce.getLevel(armor, CEnchantments.ENLIGHTENED);
                                        double d = maxHealth = Armor.this.ce.useHealthAttributes() ? player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() : player.getMaxHealth();
                                        if (player.getHealth() + heal < maxHealth) {
                                            player.setHealth(player.getHealth() + heal);
                                        }
                                        if (player.getHealth() + heal >= maxHealth) {
                                            player.setHealth(maxHealth);
                                        }
                                    }
                                }
                            }.runTask(Armor.this.ce.getPlugin());
                        }
                        if (Armor.this.ce.hasEnchantment(armor, CEnchantments.MOLTEN) && CEnchantments.MOLTEN.chanceSuccessful(armor)) {
                            new BukkitRunnable(){

                                public void run() {
                                    EnchantmentUseEvent event = new EnchantmentUseEvent(player, CEnchantments.MOLTEN.getEnchantment(), armor);
                                    Bukkit.getPluginManager().callEvent((Event)event);
                                    if (!event.isCancelled()) {
                                        damager.setFireTicks(Armor.this.ce.getLevel(armor, CEnchantments.MOLTEN) * 2 * 20);
                                    }
                                }
                            }.runTask(Armor.this.ce.getPlugin());
                        }
                        if (Armor.this.ce.hasEnchantment(armor, CEnchantments.SAVIOR) && CEnchantments.SAVIOR.chanceSuccessful(armor)) {
                            new BukkitRunnable(){

                                public void run() {
                                    EnchantmentUseEvent event = new EnchantmentUseEvent(player, CEnchantments.SAVIOR.getEnchantment(), armor);
                                    Bukkit.getPluginManager().callEvent((Event)event);
                                    if (!event.isCancelled()) {
                                        e.setDamage(e.getDamage() / 2.0);
                                    }
                                }
                            }.runTask(Armor.this.ce.getPlugin());
                        }
                        if (Armor.this.ce.hasEnchantment(armor, CEnchantments.CACTUS) && CEnchantments.CACTUS.chanceSuccessful(armor)) {
                            new BukkitRunnable(){

                                public void run() {
                                    EnchantmentUseEvent event = new EnchantmentUseEvent(player, CEnchantments.CACTUS.getEnchantment(), armor);
                                    Bukkit.getPluginManager().callEvent((Event)event);
                                    if (!event.isCancelled()) {
                                        damager.damage((double)Armor.this.ce.getLevel(armor, CEnchantments.CACTUS));
                                    }
                                }
                            }.runTask(Armor.this.ce.getPlugin());
                        }
                        if (!Armor.this.ce.hasEnchantment(armor, CEnchantments.STORMCALLER) || !CEnchantments.STORMCALLER.chanceSuccessful(armor)) continue;
                        new BukkitRunnable(){

                            public void run() {
                                EnchantmentUseEvent event = new EnchantmentUseEvent(player, CEnchantments.STORMCALLER.getEnchantment(), armor);
                                Bukkit.getPluginManager().callEvent((Event)event);
                                if (!event.isCancelled()) {
                                    Location loc = damager.getLocation();
                                    loc.getWorld().spigot().strikeLightningEffect(loc, true);
                                    int lightningSoundRange = FileManager.Files.CONFIG.getFile().getInt("Settings.EnchantmentOptions.Lightning-Sound-Range", 160);
                                    try {
                                        loc.getWorld().playSound(loc, Armor.this.ce.getSound("ENTITY_LIGHTNING_BOLT_IMPACT", "ENTITY_LIGHTNING_IMPACT"), (float)lightningSoundRange / 16.0f, 1.0f);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    if (Support.SupportedPlugins.NO_CHEAT_PLUS.isPluginLoaded()) {
                                        NoCheatPlusSupport.exemptPlayer(player);
                                    }
                                    if (Support.SupportedPlugins.SPARTAN.isPluginLoaded()) {
                                        SpartanSupport.cancelNoSwing(player);
                                    }
                                    if (Support.SupportedPlugins.AAC.isPluginLoaded()) {
                                        AACSupport.exemptPlayer(player);
                                    }
                                    for (LivingEntity en : Methods.getNearbyLivingEntities(loc, 2.0, (Entity)player)) {
                                        EntityDamageByEntityEvent damageByEntityEvent = new EntityDamageByEntityEvent((Entity)player, (Entity)en, EntityDamageEvent.DamageCause.CUSTOM, 5.0);
                                        Armor.this.ce.addIgnoredEvent((Event)damageByEntityEvent);
                                        Armor.this.ce.addIgnoredUUID(player.getUniqueId());
                                        Bukkit.getPluginManager().callEvent((Event)damageByEntityEvent);
                                        if (!damageByEntityEvent.isCancelled() && Armor.this.support.allowsPVP(en.getLocation()) && !Armor.this.support.isFriendly((Entity)player, (Entity)en)) {
                                            en.damage(5.0);
                                        }
                                        Armor.this.ce.removeIgnoredEvent((Event)damageByEntityEvent);
                                        Armor.this.ce.removeIgnoredUUID(player.getUniqueId());
                                    }
                                    damager.damage(5.0);
                                    if (Support.SupportedPlugins.NO_CHEAT_PLUS.isPluginLoaded()) {
                                        NoCheatPlusSupport.unexemptPlayer(player);
                                    }
                                    if (Support.SupportedPlugins.AAC.isPluginLoaded()) {
                                        AACSupport.unexemptPlayer(player);
                                    }
                                }
                            }
                        }.runTask(Armor.this.ce.getPlugin());
                    }
                    if (damager instanceof Player) {
                        for (final ItemStack armor : Objects.requireNonNull(damager.getEquipment()).getArmorContents()) {
                            if (!Armor.this.ce.hasEnchantment(armor, CEnchantments.LEADERSHIP) || !CEnchantments.LEADERSHIP.chanceSuccessful(armor) || !Support.SupportedPlugins.FACTIONS_MASSIVE_CRAFT.isPluginLoaded() && !Support.SupportedPlugins.FACTIONS_UUID.isPluginLoaded()) continue;
                            final int radius = 4 + Armor.this.ce.getLevel(armor, CEnchantments.LEADERSHIP);
                            new BukkitRunnable(){

                                public void run() {
                                    int players = 0;
                                    for (Entity entity : damager.getNearbyEntities((double)radius, (double)radius, (double)radius)) {
                                        if (!(entity instanceof Player)) continue;
                                        Player other = (Player)entity;
                                        if (!Armor.this.support.isFriendly((Entity)damager, (Entity)other)) continue;
                                        ++players;
                                    }
                                    if (players > 0) {
                                        EnchantmentUseEvent event = new EnchantmentUseEvent((Player)damager, CEnchantments.LEADERSHIP.getEnchantment(), armor);
                                        Bukkit.getPluginManager().callEvent((Event)event);
                                        if (!event.isCancelled()) {
                                            e.setDamage(e.getDamage() + (double)(players / 2));
                                        }
                                    }
                                }
                            }.runTask(Armor.this.ce.getPlugin());
                        }
                    }
                }
            }
        }.runTaskAsynchronously(this.ce.getPlugin());
    }

    @EventHandler
    public void onAura(final AuraActiveEvent e) {
        final Player player = e.getPlayer();
        final Player other = e.getOther();
        new BukkitRunnable(){

            public void run() {
                if (!player.canSee(other) || !other.canSee(player)) {
                    return;
                }
                if (Armor.this.support.isVanished((Entity)player) || Armor.this.support.isVanished((Entity)other)) {
                    return;
                }
                final CEnchantments enchant = e.getEnchantment();
                final int level = e.getLevel();
                if (Armor.this.support.allowsPVP(other.getLocation()) && !Armor.this.support.isFriendly((Entity)player, (Entity)other) && !Methods.hasPermission(other, "bypass.aura", false)) {
                    final Calendar cal = Calendar.getInstance();
                    HashMap effect = new HashMap();
                    if (Armor.this.timer.containsKey(other)) {
                        effect = (HashMap)Armor.this.timer.get(other);
                    }
                    final HashMap finalEffect = effect;
                    new BukkitRunnable(){

                        public void run() {
                            switch (enchant) {
                                case BLIZZARD: {
                                    if (!CEnchantments.BLIZZARD.isActivated()) break;
                                    other.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 100, level - 1));
                                    break;
                                }
                                case INTIMIDATE: {
                                    if (!CEnchantments.INTIMIDATE.isActivated()) break;
                                    other.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, 60, level - 1));
                                    break;
                                }
                                case ACIDRAIN: {
                                    if (!CEnchantments.ACIDRAIN.isActivated() || Armor.this.timer.containsKey(other) && (!Armor.this.timer.containsKey(other) || ((HashMap)Armor.this.timer.get(other)).containsKey((Object)enchant)) && (!Armor.this.timer.containsKey(other) || !((HashMap)Armor.this.timer.get(other)).containsKey((Object)enchant) || !cal.after(((HashMap)Armor.this.timer.get(other)).get((Object)enchant)) || !CEnchantments.ACIDRAIN.chanceSuccessful())) break;
                                    other.addPotionEffect(new PotionEffect(PotionEffectType.POISON, 80, 1));
                                    int time = 35 - level * 5;
                                    cal.add(13, time > 0 ? time : 5);
                                    finalEffect.put(enchant, cal);
                                    break;
                                }
                                case SANDSTORM: {
                                    if (!CEnchantments.SANDSTORM.isActivated() || Armor.this.timer.containsKey(other) && (!Armor.this.timer.containsKey(other) || ((HashMap)Armor.this.timer.get(other)).containsKey((Object)enchant)) && (!Armor.this.timer.containsKey(other) || !((HashMap)Armor.this.timer.get(other)).containsKey((Object)enchant) || !cal.after(((HashMap)Armor.this.timer.get(other)).get((Object)enchant)) || !CEnchantments.SANDSTORM.chanceSuccessful())) break;
                                    other.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 200, 0));
                                    int time = 35 - level * 5;
                                    cal.add(13, time > 0 ? time : 5);
                                    finalEffect.put(enchant, cal);
                                    break;
                                }
                                case RADIANT: {
                                    if (!CEnchantments.RADIANT.isActivated() || Armor.this.timer.containsKey(other) && (!Armor.this.timer.containsKey(other) || ((HashMap)Armor.this.timer.get(other)).containsKey((Object)enchant)) && (!Armor.this.timer.containsKey(other) || !((HashMap)Armor.this.timer.get(other)).containsKey((Object)enchant) || !cal.after(((HashMap)Armor.this.timer.get(other)).get((Object)enchant)) || !CEnchantments.RADIANT.chanceSuccessful())) break;
                                    other.setFireTicks(100);
                                    int time = 20 - level * 5;
                                    cal.add(13, Math.max(time, 0));
                                    finalEffect.put(enchant, cal);
                                    break;
                                }
                            }
                        }
                    }.runTask(Armor.this.ce.getPlugin());
                    Armor.this.timer.put(other, effect);
                }
            }
        }.runTaskAsynchronously(this.ce.getPlugin());
    }

    @EventHandler
    public void onMovement(PlayerMoveEvent e) {
        Location from = e.getFrom();
        Location to = e.getTo();
        if (Objects.requireNonNull(to).getBlockX() == from.getBlockX() && to.getBlockY() == from.getBlockY() && to.getBlockZ() == from.getBlockZ()) {
            return;
        }
        this.armorMoveProcessor.add(e);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDeath(final PlayerDeathEvent e) {
        final Player player = e.getEntity();
        new BukkitRunnable(){

            public void run() {
                if (!(player.getKiller() instanceof Player)) {
                    return;
                }
                final Player killer = player.getKiller();
                if (!Armor.this.support.allowsPVP(player.getLocation())) {
                    return;
                }
                if (CEnchantments.SELFDESTRUCT.isActivated()) {
                    for (final ItemStack item : Objects.requireNonNull(player.getEquipment()).getArmorContents()) {
                        if (!Armor.this.ce.hasEnchantments(item) || !Armor.this.ce.hasEnchantment(item, CEnchantments.SELFDESTRUCT.getEnchantment())) continue;
                        new BukkitRunnable(){

                            public void run() {
                                EnchantmentUseEvent event = new EnchantmentUseEvent(player, CEnchantments.SELFDESTRUCT.getEnchantment(), item);
                                Bukkit.getPluginManager().callEvent((Event)event);
                                if (!event.isCancelled()) {
                                    Methods.explode((Entity)player);
                                    ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                                    for (ItemStack drop : e.getDrops()) {
                                        if (drop == null || !ProtectionCrystal.isProtected(drop) || !ProtectionCrystal.isProtectionSuccessful(player)) continue;
                                        items.add(drop);
                                    }
                                    e.getDrops().clear();
                                    e.getDrops().addAll(items);
                                }
                            }
                        }.runTask(Armor.this.ce.getPlugin());
                    }
                }
                if (CEnchantments.RECOVER.isActivated()) {
                    for (final ItemStack item : Objects.requireNonNull(killer.getEquipment()).getArmorContents()) {
                        if (!Armor.this.ce.hasEnchantments(item) || !Armor.this.ce.hasEnchantment(item, CEnchantments.RECOVER)) continue;
                        new BukkitRunnable(){

                            public void run() {
                                EnchantmentUseEvent event = new EnchantmentUseEvent(player, CEnchantments.RECOVER.getEnchantment(), item);
                                Bukkit.getPluginManager().callEvent((Event)event);
                                if (!event.isCancelled()) {
                                    killer.addPotionEffect(new PotionEffect(PotionEffectType.ABSORPTION, 160, 2));
                                    killer.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 100, 1));
                                }
                            }
                        }.runTask(Armor.this.ce.getPlugin());
                    }
                }
            }
        }.runTaskAsynchronously(this.ce.getPlugin());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerFallDamage(EntityDamageEvent e) {
        if (this.fall.contains(e.getEntity()) && e.getCause() == EntityDamageEvent.DamageCause.FALL) {
            e.setCancelled(true);
        }
    }
}

