/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.enchantments;

import java.util.Calendar;
import java.util.HashMap;
import java.util.UUID;
import me.badbones69.crazyenchantments.api.CrazyEnchantments;
import me.badbones69.crazyenchantments.api.enums.CEnchantments;
import me.badbones69.crazyenchantments.api.managers.AllyManager;
import me.badbones69.crazyenchantments.api.objects.AllyMob;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.inventory.ItemStack;

public class AllyEnchantments
implements Listener {
    private static AllyManager allyManager = AllyManager.getInstance();
    private CrazyEnchantments ce = CrazyEnchantments.getInstance();
    private HashMap<UUID, Calendar> allyCooldown = new HashMap();

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onAllySpawn(EntityDamageByEntityEvent e) {
        if (!e.isCancelled() && !this.ce.isIgnoredEvent((Event)e)) {
            int power;
            LivingEntity enemy;
            Player player;
            Calendar rightNow = Calendar.getInstance();
            if (e.getEntity() instanceof Player && e.getDamager() instanceof LivingEntity) {
                player = (Player)e.getEntity();
                enemy = (LivingEntity)e.getDamager();
                if (!this.inCooldown(player)) {
                    for (ItemStack item : player.getEquipment().getArmorContents()) {
                        if (!this.ce.hasEnchantments(item)) continue;
                        if (this.ce.hasEnchantment(item, CEnchantments.TAMER)) {
                            power = this.ce.getLevel(item, CEnchantments.TAMER);
                            this.spawnAllies(player, enemy, AllyMob.AllyType.WOLF, power);
                        }
                        if (this.ce.hasEnchantment(item, CEnchantments.GUARDS)) {
                            power = this.ce.getLevel(item, CEnchantments.GUARDS);
                            this.spawnAllies(player, enemy, AllyMob.AllyType.IRON_GOLEM, power);
                        }
                        if (this.ce.hasEnchantment(item, CEnchantments.BEEKEEPER)) {
                            power = this.ce.getLevel(item, CEnchantments.BEEKEEPER);
                            this.spawnAllies(player, enemy, AllyMob.AllyType.BEE, power);
                        }
                        if (!(enemy instanceof Player)) continue;
                        if (this.ce.hasEnchantment(item, CEnchantments.NECROMANCER)) {
                            power = this.ce.getLevel(item, CEnchantments.NECROMANCER);
                            this.spawnAllies(player, enemy, AllyMob.AllyType.ZOMBIE, power * 2);
                        }
                        if (!this.ce.hasEnchantment(item, CEnchantments.INFESTATION)) continue;
                        power = this.ce.getLevel(item, CEnchantments.INFESTATION);
                        this.spawnAllies(player, enemy, AllyMob.AllyType.ENDERMITE, power * 3);
                        this.spawnAllies(player, enemy, AllyMob.AllyType.SILVERFISH, power * 3);
                    }
                } else {
                    allyManager.setEnemy(player, enemy);
                }
            }
            if (e.getEntity() instanceof LivingEntity && e.getDamager() instanceof Player) {
                player = (Player)e.getDamager();
                if (allyManager.isAlly(player, enemy = (LivingEntity)e.getEntity())) {
                    e.setCancelled(true);
                    return;
                }
                if (!this.inCooldown(player)) {
                    for (ItemStack item : player.getEquipment().getArmorContents()) {
                        if (!this.ce.hasEnchantments(item)) continue;
                        if (this.ce.hasEnchantment(item, CEnchantments.TAMER)) {
                            power = this.ce.getLevel(item, CEnchantments.TAMER);
                            this.spawnAllies(player, enemy, AllyMob.AllyType.WOLF, power);
                        }
                        if (this.ce.hasEnchantment(item, CEnchantments.GUARDS)) {
                            power = this.ce.getLevel(item, CEnchantments.GUARDS);
                            this.spawnAllies(player, enemy, AllyMob.AllyType.IRON_GOLEM, power);
                        }
                        if (!(enemy instanceof Player)) continue;
                        if (this.ce.hasEnchantment(item, CEnchantments.NECROMANCER)) {
                            power = this.ce.getLevel(item, CEnchantments.NECROMANCER);
                            this.spawnAllies(player, enemy, AllyMob.AllyType.ZOMBIE, power * 2);
                        }
                        if (!this.ce.hasEnchantment(item, CEnchantments.INFESTATION)) continue;
                        power = this.ce.getLevel(item, CEnchantments.INFESTATION);
                        this.spawnAllies(player, enemy, AllyMob.AllyType.ENDERMITE, power * 3);
                        this.spawnAllies(player, enemy, AllyMob.AllyType.SILVERFISH, power * 3);
                    }
                } else {
                    allyManager.setEnemy(player, enemy);
                }
            }
        }
    }

    @EventHandler
    public void onAllyTarget(EntityTargetEvent e) {
        if (e.getTarget() instanceof Player && e.getEntity() instanceof LivingEntity && allyManager.isAlly((Player)e.getTarget(), (LivingEntity)e.getEntity())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onAllyDeath(EntityDeathEvent e) {
        if (allyManager.isAllyMob(e.getEntity())) {
            e.setDroppedExp(0);
            e.getDrops().clear();
        }
    }

    @EventHandler
    public void onAllyDespawn(ChunkUnloadEvent e) {
        if (e.getChunk().getEntities().length > 0) {
            for (Entity entity : e.getChunk().getEntities()) {
                LivingEntity livingEntity;
                if (!(entity instanceof LivingEntity) || !allyManager.isAllyMob(livingEntity = (LivingEntity)entity)) continue;
                allyManager.getAllyMob(livingEntity).forceRemoveAlly();
            }
        }
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent e) {
        allyManager.forceRemoveAllies(e.getPlayer());
    }

    private void spawnAllies(Player player, LivingEntity enemy, AllyMob.AllyType allyType, int amount) {
        Calendar cooldown = Calendar.getInstance();
        cooldown.add(12, 2);
        this.allyCooldown.put(player.getUniqueId(), cooldown);
        for (int i = 0; i < amount; ++i) {
            AllyMob ally = new AllyMob(player, allyType);
            ally.spawnAlly(60L);
            ally.attackEnemy(enemy);
        }
    }

    private boolean inCooldown(Player player) {
        if (this.allyCooldown.containsKey(player.getUniqueId())) {
            if (Calendar.getInstance().before(this.allyCooldown.get(player.getUniqueId()))) {
                return true;
            }
            this.allyCooldown.remove(player.getUniqueId());
        }
        return false;
    }
}

