/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.controllers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.badbones69.crazyenchantments.Methods;
import me.badbones69.crazyenchantments.api.CrazyEnchantments;
import me.badbones69.crazyenchantments.api.FileManager;
import me.badbones69.crazyenchantments.api.enums.Messages;
import me.badbones69.crazyenchantments.api.objects.CEBook;
import me.badbones69.crazyenchantments.api.objects.CEnchantment;
import me.badbones69.crazyenchantments.api.objects.ItemBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class Scrambler
implements Listener {
    public static HashMap<Player, BukkitTask> roll = new HashMap();
    private static CrazyEnchantments ce = CrazyEnchantments.getInstance();
    private static ItemBuilder scramblerItem;
    private static ItemBuilder pointer;
    private static boolean animationToggle;
    private static String guiName;

    public static void loadScrambler() {
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        scramblerItem = new ItemBuilder().setMaterial(config.getString("Settings.Scrambler.Item")).setName(config.getString("Settings.Scrambler.Name")).setLore(config.getStringList("Settings.Scrambler.Lore")).setGlowing(config.getBoolean("Settings.Scrambler.Glowing"));
        pointer = new ItemBuilder().setMaterial(config.getString("Settings.Scrambler.GUI.Pointer.Item")).setName(config.getString("Settings.Scrambler.GUI.Pointer.Name")).setLore(config.getStringList("Settings.Scrambler.GUI.Pointer.Lore"));
        animationToggle = FileManager.Files.CONFIG.getFile().getBoolean("Settings.Scrambler.GUI.Toggle");
        guiName = Methods.color(FileManager.Files.CONFIG.getFile().getString("Settings.Scrambler.GUI.Name"));
    }

    public static ItemStack getNewScrambledBook(ItemStack book) {
        if (ce.isEnchantmentBook(book)) {
            CEnchantment enchantment = ce.getEnchantmentBookEnchantment(book);
            return new CEBook(enchantment, ce.getBookLevel(book, enchantment), ce.getHighestEnchantmentCategory(enchantment)).buildBook();
        }
        return new ItemStack(Material.AIR);
    }

    public static ItemStack getScramblers() {
        return Scrambler.getScramblers(1);
    }

    public static ItemStack getScramblers(int amount) {
        return scramblerItem.clone().setAmount(amount).build();
    }

    private static void setGlass(Inventory inv) {
        for (int slot = 0; slot < 9; ++slot) {
            if (slot != 4) {
                inv.setItem(slot, Methods.getRandomPaneColor().setName(" ").build());
                inv.setItem(slot + 18, Methods.getRandomPaneColor().setName(" ").build());
                continue;
            }
            inv.setItem(slot, pointer.build());
            inv.setItem(slot + 18, pointer.build());
        }
    }

    public static void openScrambler(Player player, ItemStack book) {
        Inventory inventory = Bukkit.createInventory(null, (int)27, (String)guiName);
        Scrambler.setGlass(inventory);
        for (int slot = 9; slot > 8 && slot < 18; ++slot) {
            inventory.setItem(slot, Scrambler.getNewScrambledBook(book));
        }
        player.openInventory(inventory);
        Scrambler.startScrambler(player, inventory, book);
    }

    private static void startScrambler(final Player player, final Inventory inventory, final ItemStack book) {
        roll.put(player, new BukkitRunnable(){
            int time = 1;
            int full = 0;
            int open = 0;

            public void run() {
                if (this.full <= 50) {
                    Scrambler.moveItems(inventory, player, book);
                    Scrambler.setGlass(inventory);
                    player.playSound(player.getLocation(), ce.getSound("UI_BUTTON_CLICK", "CLICK"), 1.0f, 1.0f);
                }
                ++this.open;
                if (this.open >= 5) {
                    player.openInventory(inventory);
                    this.open = 0;
                }
                ++this.full;
                if (this.full > 51) {
                    if (Scrambler.slowSpin().contains(this.time)) {
                        Scrambler.moveItems(inventory, player, book);
                        Scrambler.setGlass(inventory);
                        player.playSound(player.getLocation(), ce.getSound("UI_BUTTON_CLICK", "CLICK"), 1.0f, 1.0f);
                    }
                    ++this.time;
                    if (this.time == 60) {
                        player.playSound(player.getLocation(), ce.getSound("ENTITY_PLAYER_LEVELUP", "LEVEL_UP"), 1.0f, 1.0f);
                        this.cancel();
                        roll.remove(player);
                        ItemStack item = inventory.getItem(13).clone();
                        item.setType(ce.getEnchantmentBookItem().getType());
                        item.setDurability(ce.getEnchantmentBookItem().getDurability());
                        if (Methods.isInventoryFull(player)) {
                            player.getWorld().dropItem(player.getLocation(), item);
                        } else {
                            player.getInventory().addItem(new ItemStack[]{item});
                        }
                    } else if (this.time > 60) {
                        this.cancel();
                    }
                }
            }
        }.runTaskTimer(ce.getPlugin(), 1L, 1L));
    }

    private static List<Integer> slowSpin() {
        ArrayList<Integer> slow = new ArrayList<Integer>();
        int full = 120;
        int cut = 15;
        int i = 120;
        while (cut > 0) {
            if (full <= i - cut || full >= i - cut) {
                slow.add(i);
                i -= cut;
                --cut;
            }
            --full;
        }
        return slow;
    }

    private static void moveItems(Inventory inv, Player player, ItemStack book) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int slot = 9; slot > 8 && slot < 17; ++slot) {
            items.add(inv.getItem(slot));
        }
        ItemStack newBook = Scrambler.getNewScrambledBook(book);
        newBook.setType(Methods.getRandomPaneColor().getMaterial());
        inv.setItem(9, newBook);
        for (int i = 0; i < 8; ++i) {
            inv.setItem(i + 10, (ItemStack)items.get(i));
        }
    }

    @EventHandler
    public void onReRoll(InventoryClickEvent e) {
        Player player = (Player)e.getWhoClicked();
        if (e.getClickedInventory() != null) {
            ItemStack scrambler;
            ItemStack book = e.getCurrentItem() != null ? e.getCurrentItem() : new ItemStack(Material.AIR);
            ItemStack itemStack = scrambler = e.getCursor() != null ? e.getCursor() : new ItemStack(Material.AIR);
            if (book.getType() != Material.AIR && scrambler.getType() != Material.AIR && book.getAmount() == 1 && scrambler.getAmount() == 1 && Scrambler.getScramblers().isSimilar(scrambler) && ce.isEnchantmentBook(book)) {
                if (e.getClickedInventory().getType() == InventoryType.PLAYER) {
                    e.setCancelled(true);
                    player.setItemOnCursor(new ItemStack(Material.AIR));
                    if (animationToggle) {
                        e.setCurrentItem(new ItemStack(Material.AIR));
                        Scrambler.openScrambler(player, book);
                    } else {
                        e.setCurrentItem(Scrambler.getNewScrambledBook(book));
                    }
                } else {
                    player.sendMessage(Messages.NEED_TO_USE_PLAYER_INVENTORY.getMessage());
                }
            }
        }
    }

    @EventHandler
    public void onInvClick(InventoryClickEvent e) {
        if (e.getInventory() != null && e.getView().getTitle().equals(guiName)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onScramblerClick(PlayerInteractEvent e) {
        ItemStack item = Methods.getItemInHand(e.getPlayer());
        if (item != null && Scrambler.getScramblers().isSimilar(item)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent e) {
        Player player = e.getPlayer();
        try {
            roll.get(player).cancel();
            roll.remove(player);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

