/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.controllers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.badbones69.crazyenchantments.Methods;
import me.badbones69.crazyenchantments.api.CrazyEnchantments;
import me.badbones69.crazyenchantments.api.FileManager;
import me.badbones69.crazyenchantments.api.enums.Messages;
import me.badbones69.crazyenchantments.api.objects.ItemBuilder;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ProtectionCrystal
implements Listener {
    private HashMap<UUID, List<ItemStack>> playersItems = new HashMap();
    private CrazyEnchantments ce = CrazyEnchantments.getInstance();
    private static ItemBuilder crystal;
    private static String protectionString;

    public static void loadProtectionCrystal() {
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        crystal = new ItemBuilder().setMaterial(config.getString("Settings.ProtectionCrystal.Item")).setName(config.getString("Settings.ProtectionCrystal.Name")).setLore(config.getStringList("Settings.ProtectionCrystal.Lore")).setGlowing(config.getBoolean("Settings.ProtectionCrystal.Glowing"));
        protectionString = Methods.color(FileManager.Files.CONFIG.getFile().getString("Settings.ProtectionCrystal.Protected"));
    }

    public static ItemStack getCrystals() {
        return ProtectionCrystal.getCrystals(1);
    }

    public static ItemStack getCrystals(int amount) {
        return crystal.clone().setAmount(amount).build();
    }

    public static boolean isProtected(ItemStack item) {
        if (item.hasItemMeta() && item.getItemMeta().hasLore()) {
            for (String lore : item.getItemMeta().getLore()) {
                if (!lore.contains(protectionString)) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static boolean isSuccessfull(Player player) {
        return ProtectionCrystal.isProtectionSuccessful(player);
    }

    public static boolean isProtectionSuccessful(Player player) {
        if (player.hasPermission("crazyenchantments.bypass.protectioncrystal")) {
            return true;
        }
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        if (config.getBoolean("Settings.ProtectionCrystal.Chance.Toggle")) {
            return Methods.randomPicker(config.getInt("Settings.ProtectionCrystal.Chance.Success-Chance", 100), 100);
        }
        return true;
    }

    public static ItemStack removeProtection(ItemStack item) {
        ItemMeta itemMeta = item.getItemMeta();
        ArrayList lore = new ArrayList(itemMeta.getLore());
        lore.remove(protectionString);
        itemMeta.setLore(lore);
        item.setItemMeta(itemMeta);
        return item;
    }

    @EventHandler
    public void onInvClick(InventoryClickEvent e) {
        Player player = (Player)e.getWhoClicked();
        if (e.getInventory() != null) {
            ItemStack item;
            ItemStack crystalItem = e.getCursor() != null ? e.getCursor() : new ItemStack(Material.AIR);
            ItemStack itemStack = item = e.getCurrentItem() != null ? e.getCurrentItem() : new ItemStack(Material.AIR);
            if (item.getType() != Material.AIR && crystalItem.getType() != Material.AIR && item.getAmount() == 1 && !ProtectionCrystal.getCrystals().isSimilar(item) && crystalItem.isSimilar(ProtectionCrystal.getCrystals()) && !ProtectionCrystal.isProtected(item)) {
                if (crystalItem.getAmount() > 1) {
                    player.sendMessage(Messages.NEED_TO_UNSTACK_ITEM.getMessage());
                    return;
                }
                e.setCancelled(true);
                player.setItemOnCursor(Methods.removeItem(crystalItem));
                e.setCurrentItem(Methods.addLore(item, protectionString));
                player.updateInventory();
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerDeath(PlayerDeathEvent e) {
        if (e.getKeepInventory()) {
            return;
        }
        Player player = e.getEntity();
        ArrayList<ItemStack> savedItems = new ArrayList<ItemStack>();
        ArrayList<ItemStack> droppedItems = new ArrayList<ItemStack>();
        for (ItemStack item : e.getDrops()) {
            if (item == null) continue;
            if (ProtectionCrystal.isProtected(item) && ProtectionCrystal.isProtectionSuccessful(player)) {
                savedItems.add(item);
                continue;
            }
            droppedItems.add(item);
        }
        e.getDrops().clear();
        e.getDrops().addAll(droppedItems);
        this.playersItems.put(player.getUniqueId(), savedItems);
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent e) {
        Player player = e.getPlayer();
        if (this.playersItems.containsKey(player.getUniqueId())) {
            if (FileManager.Files.CONFIG.getFile().getBoolean("Settings.ProtectionCrystal.Lose-Protection-On-Death", true)) {
                for (ItemStack item : this.playersItems.get(player.getUniqueId())) {
                    player.getInventory().addItem(new ItemStack[]{ProtectionCrystal.removeProtection(item)});
                }
            } else {
                for (ItemStack item : this.playersItems.get(player.getUniqueId())) {
                    player.getInventory().addItem(new ItemStack[]{item});
                }
            }
            this.playersItems.remove(player.getUniqueId());
        }
    }

    @EventHandler
    public void onCrystalClick(PlayerInteractEvent e) {
        ItemStack item = Methods.getItemInHand(e.getPlayer());
        if (item != null && item.isSimilar(ProtectionCrystal.getCrystals())) {
            e.setCancelled(true);
        }
    }
}

