/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.controllers;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import me.badbones69.crazyenchantments.Methods;
import me.badbones69.crazyenchantments.api.CrazyEnchantments;
import me.badbones69.crazyenchantments.api.currencyapi.Currency;
import me.badbones69.crazyenchantments.api.currencyapi.CurrencyAPI;
import me.badbones69.crazyenchantments.api.enums.Messages;
import me.badbones69.crazyenchantments.api.managers.BlackSmithManager;
import me.badbones69.crazyenchantments.api.objects.BlackSmithResult;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;

public class BlackSmith
implements Listener {
    private static BlackSmithManager blackSmithManager = BlackSmithManager.getInstance();
    private CrazyEnchantments ce = CrazyEnchantments.getInstance();
    private int mainSlot = 10;
    private int subSlot = 13;
    private static int resultSlot = 16;
    private static List<Integer> resultBoarder = Arrays.asList(7, 8, 9, 16, 18, 25, 26, 27);
    private static List<Integer> otherBoarder = Arrays.asList(1, 2, 3, 4, 5, 6, 10, 12, 13, 15, 19, 20, 21, 22, 23, 24);
    private Sound click = this.ce.getSound("UI_BUTTON_CLICK", "CLICK");
    private Sound levelUp = this.ce.getSound("ENTITY_PLAYER_LEVELUP", "LEVEL_UP");
    private Sound villagerNo = this.ce.getSound("ENTITY_VILLAGER_NO", "VILLAGER_NO");

    public static void openBlackSmith(Player player) {
        Inventory inventory = Bukkit.createInventory(null, (int)27, (String)blackSmithManager.getMenuName());
        otherBoarder.forEach(slot -> inventory.setItem(slot - 1, blackSmithManager.getGrayGlass()));
        resultBoarder.forEach(slot -> inventory.setItem(slot - 1, blackSmithManager.getRedGlass()));
        inventory.setItem(resultSlot, blackSmithManager.getDenyBarrier());
        player.openInventory(inventory);
    }

    @EventHandler
    public void onInvClick(InventoryClickEvent e) {
        Player player = (Player)e.getWhoClicked();
        Inventory inventory = e.getInventory();
        if (inventory != null && e.getView().getTitle().equals(blackSmithManager.getMenuName())) {
            e.setCancelled(true);
            ItemStack item = e.getCurrentItem();
            if (item != null) {
                if (e.getRawSlot() > 26) {
                    if (item.getAmount() != 1) {
                        return;
                    }
                    if (this.ce.hasEnchantments(item) || this.ce.isEnchantmentBook(item)) {
                        if (inventory.getItem(this.mainSlot) == null) {
                            e.setCurrentItem(new ItemStack(Material.AIR));
                            inventory.setItem(this.mainSlot, item);
                            this.playSound(player, this.click);
                            if (inventory.getItem(this.subSlot) != null) {
                                BlackSmithResult resultItem = new BlackSmithResult(player, inventory.getItem(this.mainSlot), inventory.getItem(this.subSlot));
                                this.setResultBoarder(resultItem, inventory);
                            }
                        } else {
                            e.setCurrentItem(new ItemStack(Material.AIR));
                            if (inventory.getItem(this.subSlot) != null) {
                                e.setCurrentItem(inventory.getItem(this.subSlot));
                            }
                            inventory.setItem(this.subSlot, item);
                            this.playSound(player, this.click);
                            BlackSmithResult resultItem = new BlackSmithResult(player, inventory.getItem(this.mainSlot), inventory.getItem(this.subSlot));
                            this.setResultBoarder(resultItem, inventory);
                        }
                    }
                } else {
                    if (e.getRawSlot() == this.mainSlot || e.getRawSlot() == this.subSlot) {
                        e.setCurrentItem(new ItemStack(Material.AIR));
                        this.givePlayerItem(player, item);
                        inventory.setItem(resultSlot, blackSmithManager.getDenyBarrier());
                        resultBoarder.forEach(slot -> inventory.setItem(slot - 1, blackSmithManager.getRedGlass()));
                        this.playSound(player, this.click);
                    }
                    if (e.getRawSlot() == resultSlot) {
                        if (inventory.getItem(this.mainSlot) != null && inventory.getItem(this.subSlot) != null) {
                            BlackSmithResult resultItem = new BlackSmithResult(player, inventory.getItem(this.mainSlot), inventory.getItem(this.subSlot));
                            if (resultItem.getCost() > 0) {
                                if (blackSmithManager.getCurrency() != null && player.getGameMode() != GameMode.CREATIVE) {
                                    Currency currency = blackSmithManager.getCurrency();
                                    if (CurrencyAPI.canBuy(player, currency, resultItem.getCost())) {
                                        CurrencyAPI.takeCurrency(player, currency, resultItem.getCost());
                                    } else {
                                        String needed = resultItem.getCost() - CurrencyAPI.getCurrency(player, currency) + "";
                                        if (currency != null) {
                                            HashMap<String, String> placeholders = new HashMap<String, String>();
                                            placeholders.put("%Money_Needed%", needed);
                                            placeholders.put("%XP%", needed);
                                            switch (currency) {
                                                case VAULT: {
                                                    player.sendMessage(Messages.NEED_MORE_MONEY.getMessage(placeholders));
                                                    break;
                                                }
                                                case XP_LEVEL: {
                                                    player.sendMessage(Messages.NEED_MORE_XP_LEVELS.getMessage(placeholders));
                                                    break;
                                                }
                                                case XP_TOTAL: {
                                                    player.sendMessage(Messages.NEED_MORE_TOTAL_XP.getMessage(placeholders));
                                                }
                                            }
                                        }
                                        return;
                                    }
                                }
                                this.givePlayerItem(player, resultItem.getResultItem());
                                inventory.setItem(this.mainSlot, new ItemStack(Material.AIR));
                                inventory.setItem(this.subSlot, new ItemStack(Material.AIR));
                                this.playSound(player, this.levelUp);
                                inventory.setItem(resultSlot, blackSmithManager.getDenyBarrier());
                                resultBoarder.forEach(slot -> inventory.setItem(slot - 1, blackSmithManager.getRedGlass()));
                            } else {
                                this.playSound(player, this.villagerNo);
                            }
                        } else {
                            this.playSound(player, this.villagerNo);
                        }
                    }
                }
            }
        }
    }

    @EventHandler
    public void onInvClose(final InventoryCloseEvent e) {
        new BukkitRunnable(){

            public void run() {
                Inventory inventory = e.getInventory();
                if (inventory != null && e.getView().getTitle().equals(blackSmithManager.getMenuName())) {
                    Player player = (Player)e.getPlayer();
                    for (int slot : Arrays.asList(BlackSmith.this.mainSlot, BlackSmith.this.subSlot)) {
                        if (inventory.getItem(slot) == null || inventory.getItem(slot).getType() == Material.AIR) continue;
                        BlackSmith.this.givePlayerItem(player, inventory.getItem(slot));
                    }
                    inventory.clear();
                }
            }
        }.runTaskLater(this.ce.getPlugin(), 0L);
    }

    private void setResultBoarder(BlackSmithResult resultItem, Inventory inventory) {
        if (resultItem.getCost() > 0) {
            inventory.setItem(resultSlot, Methods.addLore(resultItem.getResultItem(), this.getFoundString(resultItem)));
            resultBoarder.forEach(slot -> inventory.setItem(slot - 1, blackSmithManager.getBlueGlass()));
        } else {
            inventory.setItem(resultSlot, blackSmithManager.getDenyBarrier());
            resultBoarder.forEach(slot -> inventory.setItem(slot - 1, blackSmithManager.getRedGlass()));
        }
    }

    private void givePlayerItem(Player player, ItemStack item) {
        if (Methods.isInventoryFull(player) || player.isDead()) {
            player.getWorld().dropItem(player.getLocation(), item);
        } else {
            player.getInventory().addItem(new ItemStack[]{item});
        }
    }

    private String getFoundString(BlackSmithResult resultItem) {
        return Messages.replacePlaceholders("%Cost%", resultItem.getCost() + "", blackSmithManager.getFoundString());
    }

    private void playSound(Player player, Sound sound) {
        player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
    }
}

