/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.controllers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import me.badbones69.crazyenchantments.api.CrazyEnchantments;
import me.badbones69.crazyenchantments.api.enums.CEnchantments;
import me.badbones69.crazyenchantments.api.events.AuraActiveEvent;
import me.badbones69.crazyenchantments.api.objects.CEnchantment;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;

public class AuraListener
implements Listener {
    private static final CEnchantments[] AURA_ENCHANTMENTS = new CEnchantments[]{CEnchantments.BLIZZARD, CEnchantments.ACIDRAIN, CEnchantments.SANDSTORM, CEnchantments.RADIANT, CEnchantments.INTIMIDATE};
    private final CrazyEnchantments ce = CrazyEnchantments.getInstance();

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerMoveEvent(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        Location from = event.getFrom();
        Location to = event.getTo();
        if (to == null || from.getBlockX() == to.getBlockX() && from.getBlockY() == to.getBlockY() && from.getBlockZ() == to.getBlockZ()) {
            return;
        }
        List<Player> players = AuraListener.getNearbyPlayers(player, 3);
        if (player.isEmpty()) {
            return;
        }
        EntityEquipment playerEquipment = player.getEquipment();
        if (playerEquipment == null) {
            return;
        }
        for (ItemStack item : playerEquipment.getArmorContents()) {
            Map<CEnchantment, Integer> itemEnchantments = this.ce.getEnchantments(item);
            itemEnchantments.forEach((enchantment, level) -> {
                CEnchantments enchantmentEnum = AuraListener.getAuraEnchantmentEnum(enchantment);
                if (enchantmentEnum == null) {
                    return;
                }
                for (Player other : players) {
                    AuraActiveEvent auraEvent = new AuraActiveEvent(player, other, enchantmentEnum, (int)level);
                    Bukkit.getPluginManager().callEvent((Event)auraEvent);
                }
            });
        }
        for (Player other : players) {
            EntityEquipment otherEquipment = player.getEquipment();
            if (otherEquipment == null) continue;
            for (ItemStack item : otherEquipment.getArmorContents()) {
                Map<CEnchantment, Integer> itemEnchantments = this.ce.getEnchantments(item);
                itemEnchantments.forEach((enchantment, level) -> {
                    CEnchantments enchantmentEnum = AuraListener.getAuraEnchantmentEnum(enchantment);
                    if (enchantmentEnum == null) {
                        return;
                    }
                    AuraActiveEvent auraEvent = new AuraActiveEvent(other, player, enchantmentEnum, (int)level);
                    Bukkit.getPluginManager().callEvent((Event)auraEvent);
                });
            }
        }
    }

    private static CEnchantments getAuraEnchantmentEnum(CEnchantment enchantment) {
        return Arrays.stream(AURA_ENCHANTMENTS).filter(enchantmentEnum -> enchantmentEnum.getName().equals(enchantment.getName())).findFirst().orElse(null);
    }

    private static List<Player> getNearbyPlayers(Player player, int radius) {
        ArrayList<Player> players = null;
        for (Entity entity : player.getNearbyEntities((double)radius, (double)radius, (double)radius)) {
            if (!(entity instanceof Player) || entity == player) continue;
            if (players == null) {
                players = new ArrayList<Player>();
            }
            players.add((Player)entity);
        }
        return players;
    }
}

