/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.controllers;

import java.util.ArrayList;
import java.util.List;
import me.badbones69.crazyenchantments.api.enums.ArmorType;
import me.badbones69.crazyenchantments.api.events.ArmorEquipEvent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Dispenser;
import org.bukkit.plugin.Plugin;

public class ArmorListener
implements Listener {
    private final List<String> blockedMaterials;
    private Plugin plugin = Bukkit.getServer().getPluginManager().getPlugin("CrazyEnchantments");

    public ArmorListener() {
        this.blockedMaterials = this.getBlocks();
    }

    @EventHandler
    public final void onInventoryClick(InventoryClickEvent e) {
        boolean shift = false;
        boolean numberkey = false;
        Player player = (Player)e.getWhoClicked();
        if (e.isCancelled()) {
            return;
        }
        if (e.getClick().equals((Object)ClickType.SHIFT_LEFT) || e.getClick().equals((Object)ClickType.SHIFT_RIGHT)) {
            shift = true;
        }
        if (e.getClick().equals((Object)ClickType.NUMBER_KEY)) {
            numberkey = true;
        }
        if (!(e.getSlotType() == InventoryType.SlotType.ARMOR && e.getSlotType() == InventoryType.SlotType.QUICKBAR || e.getInventory().getType().equals((Object)InventoryType.CRAFTING) || e.getInventory().getType().equals((Object)InventoryType.PLAYER))) {
            return;
        }
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        if (e.getCurrentItem() == null) {
            return;
        }
        ArmorType newArmorType = ArmorType.matchType(shift ? e.getCurrentItem() : e.getCursor());
        if (!shift && newArmorType != null && e.getRawSlot() != newArmorType.getSlot()) {
            return;
        }
        if (e.getInventory().getType() == InventoryType.CRAFTING && e.getRawSlot() >= 0 && e.getRawSlot() <= 4) {
            return;
        }
        if (shift) {
            newArmorType = ArmorType.matchType(e.getCurrentItem());
            if (newArmorType != null) {
                boolean equipping = true;
                if (e.getRawSlot() == newArmorType.getSlot()) {
                    equipping = false;
                }
                if (newArmorType.equals((Object)ArmorType.HELMET) && equipping == (e.getWhoClicked().getInventory().getHelmet() == null) || newArmorType.equals((Object)ArmorType.CHESTPLATE) && equipping == (e.getWhoClicked().getInventory().getChestplate() == null) || newArmorType.equals((Object)ArmorType.LEGGINGS) && equipping == (e.getWhoClicked().getInventory().getLeggings() == null) || newArmorType.equals((Object)ArmorType.BOOTS) && equipping == (e.getWhoClicked().getInventory().getBoots() == null)) {
                    ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent(player, ArmorEquipEvent.EquipMethod.SHIFT_CLICK, newArmorType, equipping ? null : e.getCurrentItem(), equipping ? e.getCurrentItem() : null);
                    Bukkit.getServer().getPluginManager().callEvent((Event)armorEquipEvent);
                    if (armorEquipEvent.isCancelled()) {
                        e.setCancelled(true);
                    }
                }
            }
        } else {
            ArmorEquipEvent.EquipMethod method;
            ItemStack oldArmorPiece;
            ItemStack newArmorPiece = e.getCursor();
            if (newArmorPiece == null) {
                newArmorPiece = new ItemStack(Material.AIR);
            }
            if ((oldArmorPiece = e.getCurrentItem()) == null) {
                oldArmorPiece = new ItemStack(Material.AIR);
            }
            if (numberkey) {
                if (e.getInventory().getType().equals((Object)InventoryType.PLAYER)) {
                    ItemStack hotbarItem = e.getInventory().getItem(e.getHotbarButton());
                    if (hotbarItem != null) {
                        newArmorType = ArmorType.matchType(hotbarItem);
                        newArmorPiece = hotbarItem;
                        oldArmorPiece = e.getInventory().getItem(e.getSlot());
                    } else {
                        newArmorType = ArmorType.matchType(e.getCurrentItem() != null && e.getCurrentItem().getType() != Material.AIR ? e.getCurrentItem() : e.getCursor());
                    }
                }
            } else {
                newArmorType = ArmorType.matchType(e.getCurrentItem() != null && e.getCurrentItem().getType() != Material.AIR ? e.getCurrentItem() : e.getCursor());
            }
            if (newArmorType != null && e.getRawSlot() == newArmorType.getSlot()) {
                method = ArmorEquipEvent.EquipMethod.DRAG;
                if (e.getAction().equals((Object)InventoryAction.HOTBAR_SWAP) || numberkey) {
                    method = ArmorEquipEvent.EquipMethod.HOTBAR_SWAP;
                }
                ItemStack It = newArmorPiece.clone();
                ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent(player, method, newArmorType, oldArmorPiece, newArmorPiece);
                Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, () -> {
                    ItemStack I = e.getWhoClicked().getInventory().getItem(e.getSlot());
                    if (e.getInventory().getType().equals((Object)InventoryType.PLAYER)) {
                        if (e.getSlot() == ArmorType.HELMET.getSlot()) {
                            I = e.getWhoClicked().getEquipment().getHelmet();
                        }
                        if (e.getSlot() == ArmorType.CHESTPLATE.getSlot()) {
                            I = e.getWhoClicked().getEquipment().getChestplate();
                        }
                        if (e.getSlot() == ArmorType.LEGGINGS.getSlot()) {
                            I = e.getWhoClicked().getEquipment().getLeggings();
                        }
                        if (e.getSlot() == ArmorType.BOOTS.getSlot()) {
                            I = e.getWhoClicked().getEquipment().getBoots();
                        }
                    }
                    if (I == null) {
                        I = e.getInventory().getType().equals((Object)InventoryType.PLAYER) ? new ItemStack(Material.AIR, 1) : new ItemStack(Material.AIR, 0);
                    }
                    if (I.isSimilar(It) || I.getType() == Material.AIR && It.getType() == Material.AIR) {
                        Bukkit.getServer().getPluginManager().callEvent((Event)armorEquipEvent);
                        if (armorEquipEvent.isCancelled()) {
                            e.setCancelled(true);
                        }
                    }
                }, 0L);
            } else if (e.getHotbarButton() >= 0) {
                newArmorPiece = e.getWhoClicked().getInventory().getItem(e.getHotbarButton());
                if (!(oldArmorPiece == null || ArmorType.matchType(oldArmorPiece) == null && oldArmorPiece.getType() != Material.AIR || ArmorType.matchType(newArmorPiece) == null && newArmorPiece != null)) {
                    if (ArmorType.matchType(oldArmorPiece) != null && e.getRawSlot() != ArmorType.matchType(oldArmorPiece).getSlot()) {
                        return;
                    }
                    if (ArmorType.matchType(newArmorPiece) != null && e.getRawSlot() != ArmorType.matchType(newArmorPiece).getSlot()) {
                        return;
                    }
                    method = ArmorEquipEvent.EquipMethod.DRAG;
                    if (e.getAction().equals((Object)InventoryAction.HOTBAR_SWAP) || numberkey) {
                        method = ArmorEquipEvent.EquipMethod.HOTBAR_SWAP;
                    }
                    ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent(player, method, newArmorType, oldArmorPiece, newArmorPiece);
                    Bukkit.getServer().getPluginManager().callEvent((Event)armorEquipEvent);
                    if (armorEquipEvent.isCancelled()) {
                        e.setCancelled(true);
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void playerInteractEvent(PlayerInteractEvent e) {
        if (e.getAction() == Action.PHYSICAL) {
            return;
        }
        if (e.getAction() == Action.RIGHT_CLICK_AIR || e.getAction() == Action.RIGHT_CLICK_BLOCK) {
            ArmorType newArmorType;
            if (e.isCancelled()) {
                return;
            }
            Player player = e.getPlayer();
            if (e.getClickedBlock() != null && e.getAction() == Action.RIGHT_CLICK_BLOCK) {
                Material mat = e.getClickedBlock().getType();
                for (String s : this.blockedMaterials) {
                    if (!mat.name().toLowerCase().contains(s.toLowerCase())) continue;
                    return;
                }
            }
            if ((newArmorType = ArmorType.matchType(e.getItem())) != null && (newArmorType.equals((Object)ArmorType.HELMET) && e.getPlayer().getInventory().getHelmet() == null || newArmorType.equals((Object)ArmorType.CHESTPLATE) && e.getPlayer().getInventory().getChestplate() == null || newArmorType.equals((Object)ArmorType.LEGGINGS) && e.getPlayer().getInventory().getLeggings() == null || newArmorType.equals((Object)ArmorType.BOOTS) && e.getPlayer().getInventory().getBoots() == null)) {
                ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent(e.getPlayer(), ArmorEquipEvent.EquipMethod.HOTBAR, ArmorType.matchType(e.getItem()), null, e.getItem());
                Bukkit.getServer().getPluginManager().callEvent((Event)armorEquipEvent);
                if (armorEquipEvent.isCancelled()) {
                    e.setCancelled(true);
                    player.updateInventory();
                }
            }
        }
    }

    @EventHandler
    public void dispenserFireEvent(BlockDispenseEvent e) {
        ArmorType type = ArmorType.matchType(e.getItem());
        if (ArmorType.matchType(e.getItem()) != null) {
            Location loc = e.getBlock().getLocation();
            for (Player p : loc.getWorld().getPlayers()) {
                org.bukkit.block.Dispenser dispenser;
                Dispenser dis;
                BlockFace directionFacing;
                if (loc.getBlockY() - p.getLocation().getBlockY() < -1 || loc.getBlockY() - p.getLocation().getBlockY() > 1 || !(p.getInventory().getHelmet() == null && type.equals((Object)ArmorType.HELMET) || p.getInventory().getChestplate() == null && type.equals((Object)ArmorType.CHESTPLATE) || p.getInventory().getLeggings() == null && type.equals((Object)ArmorType.LEGGINGS)) && (p.getInventory().getBoots() != null || !type.equals((Object)ArmorType.BOOTS)) || !(e.getBlock().getState() instanceof org.bukkit.block.Dispenser) || !((directionFacing = (dis = (Dispenser)(dispenser = (org.bukkit.block.Dispenser)e.getBlock().getState()).getData()).getFacing()) == BlockFace.EAST && p.getLocation().getBlockX() != loc.getBlockX() && p.getLocation().getX() <= loc.getX() + 2.3 && p.getLocation().getX() >= loc.getX() || directionFacing == BlockFace.WEST && p.getLocation().getX() >= loc.getX() - 1.3 && p.getLocation().getX() <= loc.getX() || directionFacing == BlockFace.SOUTH && p.getLocation().getBlockZ() != loc.getBlockZ() && p.getLocation().getZ() <= loc.getZ() + 2.3 && p.getLocation().getZ() >= loc.getZ()) && (directionFacing != BlockFace.NORTH || !(p.getLocation().getZ() >= loc.getZ() - 1.3) || !(p.getLocation().getZ() <= loc.getZ()))) continue;
                ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent(p, ArmorEquipEvent.EquipMethod.DISPENSER, ArmorType.matchType(e.getItem()), null, e.getItem());
                Bukkit.getServer().getPluginManager().callEvent((Event)armorEquipEvent);
                if (armorEquipEvent.isCancelled()) {
                    e.setCancelled(true);
                }
                return;
            }
        }
    }

    @EventHandler
    public void itemBreakEvent(PlayerItemBreakEvent e) {
        ArmorType type = ArmorType.matchType(e.getBrokenItem());
        if (type != null) {
            Player p = e.getPlayer();
            ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent(p, ArmorEquipEvent.EquipMethod.BROKE, type, e.getBrokenItem(), null);
            Bukkit.getServer().getPluginManager().callEvent((Event)armorEquipEvent);
            if (armorEquipEvent.isCancelled()) {
                ItemStack i = e.getBrokenItem().clone();
                i.setAmount(1);
                i.setDurability((short)(i.getDurability() - 1));
                if (type.equals((Object)ArmorType.HELMET)) {
                    p.getInventory().setHelmet(i);
                } else if (type.equals((Object)ArmorType.CHESTPLATE)) {
                    p.getInventory().setChestplate(i);
                } else if (type.equals((Object)ArmorType.LEGGINGS)) {
                    p.getInventory().setLeggings(i);
                } else if (type.equals((Object)ArmorType.BOOTS)) {
                    p.getInventory().setBoots(i);
                }
            }
        }
    }

    @EventHandler
    public void playerDeathEvent(PlayerDeathEvent e) {
        Player p = e.getEntity();
        for (ItemStack i : p.getInventory().getArmorContents()) {
            if (i == null || i.getType().equals((Object)Material.AIR)) continue;
            Bukkit.getServer().getPluginManager().callEvent((Event)new ArmorEquipEvent(p, ArmorEquipEvent.EquipMethod.DEATH, ArmorType.matchType(i), i, null));
        }
    }

    public static boolean isAirOrNull(ItemStack item) {
        return item == null || item.getType().equals((Object)Material.AIR);
    }

    private List<String> getBlocks() {
        ArrayList<String> blocks = new ArrayList<String>();
        blocks.add("DAYLIGHT_DETECTOR");
        blocks.add("DAYLIGHT_DETECTOR_INVERTED");
        blocks.add("FURNACE");
        blocks.add("CHEST");
        blocks.add("TRAPPED_CHEST");
        blocks.add("BEACON");
        blocks.add("DISPENSER");
        blocks.add("DROPPER");
        blocks.add("HOPPER");
        blocks.add("WORKBENCH");
        blocks.add("ENCHANTMENT_TABLE");
        blocks.add("ENDER_CHEST");
        blocks.add("ANVIL");
        blocks.add("BED_BLOCK");
        blocks.add("FENCE_GATE");
        blocks.add("SPRUCE_FENCE_GATE");
        blocks.add("BIRCH_FENCE_GATE");
        blocks.add("ACACIA_FENCE_GATE");
        blocks.add("JUNGLE_FENCE_GATE");
        blocks.add("DARK_OAK_FENCE_GATE");
        blocks.add("IRON_DOOR_BLOCK");
        blocks.add("WOODEN_DOOR");
        blocks.add("SPRUCE_DOOR");
        blocks.add("BIRCH_DOOR");
        blocks.add("JUNGLE_DOOR");
        blocks.add("ACACIA_DOOR");
        blocks.add("DARK_OAK_DOOR");
        blocks.add("WOOD_BUTTON");
        blocks.add("STONE_BUTTON");
        blocks.add("TRAP_DOOR");
        blocks.add("IRON_TRAPDOOR");
        blocks.add("DIODE_BLOCK_OFF");
        blocks.add("DIODE_BLOCK_ON");
        blocks.add("REDSTONE_COMPARATOR_OFF");
        blocks.add("REDSTONE_COMPARATOR_ON");
        blocks.add("FENCE");
        blocks.add("SPRUCE_FENCE");
        blocks.add("BIRCH_FENCE");
        blocks.add("JUNGLE_FENCE");
        blocks.add("DARK_OAK_FENCE");
        blocks.add("ACACIA_FENCE");
        blocks.add("NETHER_FENCE");
        blocks.add("BREWING_STAND");
        blocks.add("CAULDRON");
        blocks.add("SIGN_POST");
        blocks.add("WALL_SIGN");
        blocks.add("SIGN");
        blocks.add("DRAGON_EGG");
        blocks.add("LEVER");
        blocks.add("SHULKER_BOX");
        return blocks;
    }
}

