/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.commands;

import java.util.HashMap;
import me.badbones69.crazyenchantments.Methods;
import me.badbones69.crazyenchantments.api.CrazyEnchantments;
import me.badbones69.crazyenchantments.api.enums.Messages;
import me.badbones69.crazyenchantments.api.objects.CEPlayer;
import me.badbones69.crazyenchantments.api.objects.GKitz;
import me.badbones69.crazyenchantments.controllers.GKitzController;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class GkitzCommand
implements CommandExecutor {
    private CrazyEnchantments ce = CrazyEnchantments.getInstance();

    /*
     * Enabled aggressive block sorting
     */
    public boolean onCommand(CommandSender sender, Command cmd, String commandLable, String[] args) {
        Player player;
        boolean isPlayer = sender instanceof Player;
        if (!this.ce.isGkitzEnabled()) return false;
        if (args.length == 0) {
            if (!isPlayer) {
                sender.sendMessage(Messages.PLAYERS_ONLY.getMessage());
                return true;
            }
            if (!this.hasPermission(sender, "gkitz")) return true;
            GKitzController.openGUI((Player)sender);
            return true;
        }
        if (args[0].equalsIgnoreCase("reset")) {
            Player player2;
            if (!this.hasPermission(sender, "reset")) return true;
            GKitz kit = this.ce.getGKitFromName(args[1]);
            if (args.length < 2) {
                sender.sendMessage(Methods.getPrefix() + Methods.color("&c/GKitz Reset <Kit> [Player]"));
                return true;
            }
            if (kit == null) {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("%Kit%", args[1]);
                placeholders.put("%Gkit%", args[1]);
                sender.sendMessage(Messages.NOT_A_GKIT.getMessage(placeholders));
                return true;
            }
            if (args.length >= 3) {
                if (!Methods.isPlayerOnline(args[2], sender)) {
                    return true;
                }
                player2 = Methods.getPlayer(args[2]);
            } else {
                if (!isPlayer) {
                    sender.sendMessage(Messages.PLAYERS_ONLY.getMessage());
                    return true;
                }
                player2 = (Player)sender;
            }
            this.ce.getCEPlayer(player2).removeCooldown(kit);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("%Player%", player2.getName());
            placeholders.put("%Gkit%", kit.getName());
            placeholders.put("%Kit%", kit.getName());
            sender.sendMessage(Messages.RESET_GKIT.getMessage(placeholders));
            return true;
        }
        if (!this.hasPermission(sender, "gkitz")) return true;
        boolean adminGive = false;
        GKitz kit = this.ce.getGKitFromName(args[0]);
        if (kit == null) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("%Kit%", args[0]);
            placeholders.put("%Gkit%", args[0]);
            sender.sendMessage(Messages.NOT_A_GKIT.getMessage(placeholders));
            return true;
        }
        if (args.length >= 2) {
            if (!Methods.isPlayerOnline(args[1], sender)) {
                return true;
            }
            if (!this.hasPermission(sender, "crazyenchantments.gkitz.give")) return true;
            player = Methods.getPlayer(args[1]);
            adminGive = true;
        } else {
            if (!isPlayer) {
                sender.sendMessage(Messages.PLAYERS_ONLY.getMessage());
                return true;
            }
            player = (Player)sender;
        }
        CEPlayer cePlayer = this.ce.getCEPlayer(player);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%Player%", player.getName());
        placeholders.put("%Kit%", kit.getDisplayItem().getItemMeta().getDisplayName());
        if (!cePlayer.hasGkitPermission(kit) && !adminGive) {
            sender.sendMessage(Messages.NO_GKIT_PERMISSION.getMessage(placeholders));
            return true;
        }
        if (!cePlayer.canUseGKit(kit) && !adminGive) {
            sender.sendMessage(Methods.getPrefix() + cePlayer.getCooldown(kit).getCooldownLeft(Messages.STILL_IN_COOLDOWN.getMessage(placeholders)));
            return true;
        }
        cePlayer.giveGKit(kit);
        player.sendMessage(Messages.RECEIVED_GKIT.getMessage(placeholders));
        if (adminGive) {
            sender.sendMessage(Messages.GIVEN_GKIT.getMessage(placeholders));
            return true;
        }
        cePlayer.addCooldown(kit);
        return true;
    }

    private boolean hasPermission(CommandSender sender, String permission) {
        return Methods.hasPermission(sender, permission, true);
    }
}

