/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.commands;

import java.util.ArrayList;
import java.util.HashMap;
import me.badbones69.crazyenchantments.Methods;
import me.badbones69.crazyenchantments.api.CrazyEnchantments;
import me.badbones69.crazyenchantments.api.FileManager;
import me.badbones69.crazyenchantments.api.enums.CEnchantments;
import me.badbones69.crazyenchantments.api.enums.Dust;
import me.badbones69.crazyenchantments.api.enums.Messages;
import me.badbones69.crazyenchantments.api.enums.Scrolls;
import me.badbones69.crazyenchantments.api.managers.InfoMenuManager;
import me.badbones69.crazyenchantments.api.objects.CEBook;
import me.badbones69.crazyenchantments.api.objects.CEPlayer;
import me.badbones69.crazyenchantments.api.objects.CEnchantment;
import me.badbones69.crazyenchantments.api.objects.Category;
import me.badbones69.crazyenchantments.api.objects.EnchantmentType;
import me.badbones69.crazyenchantments.controllers.ProtectionCrystal;
import me.badbones69.crazyenchantments.controllers.Scrambler;
import me.badbones69.crazyenchantments.controllers.ShopControl;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CECommand
implements CommandExecutor {
    private CrazyEnchantments ce = CrazyEnchantments.getInstance();
    private FileManager fileManager = FileManager.getInstance();

    public boolean onCommand(CommandSender sender, Command cmd, String commandLable, String[] args) {
        boolean isPlayer = sender instanceof Player;
        if (args.length == 0) {
            if (!isPlayer) {
                sender.sendMessage(Messages.PLAYERS_ONLY.getMessage());
                return true;
            }
            if (this.hasPermission(sender, "gui")) {
                ShopControl.openGUI((Player)sender);
            }
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "help": {
                if (this.hasPermission(sender, "access")) {
                    sender.sendMessage(Messages.HELP.getMessage());
                }
                return true;
            }
            case "reload": {
                if (this.hasPermission(sender, "reload")) {
                    this.ce.getCEPlayers().forEach(cePlayer -> this.ce.backupCEPlayer((CEPlayer)cePlayer));
                    this.fileManager.setup(this.ce.getPlugin());
                    this.ce.load();
                    sender.sendMessage(Messages.CONFIG_RELOAD.getMessage());
                }
                return true;
            }
            case "limit": {
                if (this.hasPermission(sender, "limit")) {
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("%bypass%", sender.hasPermission("crazyenchantments.bypass.limit") + "");
                    placeholders.put("%limit%", this.ce.getPlayerMaxEnchantments((Player)sender) + "");
                    placeholders.put("%vanilla%", this.ce.checkVanillaLimit() + "");
                    placeholders.put("%item%", this.ce.getEnchantmentAmount(Methods.getItemInHand((Player)sender)) + "");
                    sender.sendMessage(Messages.LIMIT_COMMAND.getMessage(placeholders));
                }
                return true;
            }
            case "debug": {
                if (this.hasPermission(sender, "debug")) {
                    ArrayList<String> brokenEnchantments = new ArrayList<String>();
                    ArrayList<String> brokenEnchantmentTypes = new ArrayList<String>();
                    for (CEnchantments enchantment : CEnchantments.values()) {
                        if (!FileManager.Files.ENCHANTMENTS.getFile().contains("Enchantments." + enchantment.getName())) {
                            brokenEnchantments.add(enchantment.getName());
                        }
                        if (enchantment.getType() != null) continue;
                        brokenEnchantmentTypes.add(enchantment.getName());
                    }
                    if (brokenEnchantments.isEmpty() && brokenEnchantmentTypes.isEmpty()) {
                        sender.sendMessage(Methods.getPrefix("&aAll enchantments are loaded."));
                    } else {
                        if (!brokenEnchantments.isEmpty()) {
                            int i = 1;
                            sender.sendMessage(Methods.getPrefix("&cMissing Enchantments:"));
                            sender.sendMessage(Methods.getPrefix("&7These enchantments are broken due to one of the following reasons:"));
                            for (String broke : brokenEnchantments) {
                                sender.sendMessage(Methods.color("&c#" + i + ": &6" + broke));
                                ++i;
                            }
                            sender.sendMessage(Methods.color("&7- &cMissing from the Enchantments.yml"));
                            sender.sendMessage(Methods.color("&7- &c<Enchantment Name>: option was changed"));
                            sender.sendMessage(Methods.color("&7- &cYaml format has been broken."));
                        }
                        if (!brokenEnchantmentTypes.isEmpty()) {
                            int i = 1;
                            sender.sendMessage(Methods.getPrefix("&cEnchantments with null types:"));
                            sender.sendMessage(Methods.getPrefix("&7These enchantments are broken due to the enchantment type being null."));
                            for (String broke : brokenEnchantmentTypes) {
                                sender.sendMessage(Methods.color("&c#" + i + ": &6" + broke));
                                ++i;
                            }
                        }
                    }
                    sender.sendMessage(Methods.getPrefix("&cEnchantment Types and amount of items in each:"));
                    for (EnchantmentType enchantmentType : InfoMenuManager.getInstance().getEnchantmentTypes()) {
                        sender.sendMessage(Methods.color("&c" + enchantmentType.getName() + ": &6" + enchantmentType.getEnchantableMaterials().size()));
                    }
                }
                return true;
            }
            case "fix": {
                if (this.hasPermission(sender, "fix")) {
                    ArrayList<CEnchantments> brokenEnchantments = new ArrayList<CEnchantments>();
                    FileConfiguration file = FileManager.Files.ENCHANTMENTS.getFile();
                    for (CEnchantments enchantment : CEnchantments.values()) {
                        if (file.contains("Enchantments." + enchantment.getName())) continue;
                        brokenEnchantments.add(enchantment);
                    }
                    sender.sendMessage(Methods.color("&7Fixed a total of " + brokenEnchantments.size() + " enchantments."));
                    for (CEnchantments enchantment : brokenEnchantments) {
                        String path = "Enchantments." + enchantment.getName();
                        file.set(path + ".Enabled", (Object)true);
                        file.set(path + ".Name", (Object)enchantment.getName());
                        file.set(path + ".Color", (Object)"&7");
                        file.set(path + ".BookColor", (Object)"&b&l");
                        file.set(path + ".MaxPower", (Object)1);
                        file.set(path + ".Enchantment-Type", (Object)enchantment.getType().getName());
                        file.set(path + ".Info.Name", (Object)("&e&l" + enchantment.getName() + " &7(&bI&7)"));
                        file.set(path + ".Info.Description", enchantment.getDiscription());
                        ArrayList categories = new ArrayList();
                        this.ce.getCategories().forEach(category -> categories.add(category.getName()));
                        file.set(path + ".Categories", categories);
                        FileManager.Files.ENCHANTMENTS.saveFile();
                    }
                }
                return true;
            }
            case "info": {
                if (this.hasPermission(sender, "info")) {
                    if (args.length == 1) {
                        if (!isPlayer) {
                            sender.sendMessage(Messages.PLAYERS_ONLY.getMessage());
                            return true;
                        }
                        this.ce.getInfoMenuManager().openInfoMenu((Player)sender);
                    } else {
                        EnchantmentType enchantmentType = this.ce.getInfoMenuManager().getFromName(args[1]);
                        if (enchantmentType != null) {
                            this.ce.getInfoMenuManager().openInfoMenu((Player)sender, enchantmentType);
                            return true;
                        }
                        CEnchantment enchantment = this.ce.getEnchantmentFromName(args[1]);
                        if (enchantment != null) {
                            sender.sendMessage(enchantment.getInfoName());
                            enchantment.getInfoDescription().forEach(arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
                            return true;
                        }
                        sender.sendMessage(Messages.NOT_AN_ENCHANTMENT.getMessage());
                    }
                }
                return true;
            }
            case "spawn": {
                if (this.hasPermission(sender, "spawn")) {
                    if (args.length >= 2) {
                        CEnchantment enchantment = this.ce.getEnchantmentFromName(args[1]);
                        Category category2 = this.ce.getCategory(args[1]);
                        Location location = isPlayer ? ((Player)sender).getLocation() : new Location((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0);
                        int level = 1;
                        if (enchantment == null && category2 == null) {
                            sender.sendMessage(Messages.NOT_AN_ENCHANTMENT.getMessage());
                            return true;
                        }
                        for (String optionString : args) {
                            try {
                                String option = optionString.split(":")[0];
                                String value = optionString.split(":")[1];
                                boolean isInt = Methods.isInt(value);
                                switch (option.toLowerCase()) {
                                    case "level": {
                                        if (isInt) {
                                            level = Integer.parseInt(value);
                                            break;
                                        }
                                        if (!value.contains("-")) break;
                                        level = Methods.getRandomNumber(value);
                                        break;
                                    }
                                    case "world": {
                                        World world = Bukkit.getWorld((String)value);
                                        if (world == null) break;
                                        location.setWorld(world);
                                        break;
                                    }
                                    case "x": {
                                        if (!isInt) break;
                                        location.setX((double)Integer.parseInt(value));
                                        break;
                                    }
                                    case "y": {
                                        if (!isInt) break;
                                        location.setY((double)Integer.parseInt(value));
                                        break;
                                    }
                                    case "z": {
                                        if (!isInt) break;
                                        location.setZ((double)Integer.parseInt(value));
                                    }
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        location.getWorld().dropItemNaturally(location, category2 == null ? new CEBook(enchantment, level).buildBook() : category2.getLostBook().getLostBook(category2).build());
                        HashMap<String, String> placeholders = new HashMap<String, String>();
                        placeholders.put("%World%", location.getWorld().getName());
                        placeholders.put("%X%", location.getBlockX() + "");
                        placeholders.put("%Y%", location.getBlockY() + "");
                        placeholders.put("%Z%", location.getBlockZ() + "");
                        sender.sendMessage(Messages.SPAWNED_BOOK.getMessage(placeholders));
                        return true;
                    }
                    sender.sendMessage(Methods.getPrefix() + Methods.color("&c/ce Spawn <Enchantment/Category> [(Level:#/Min-Max)/World:<World>/X:#/Y:#/Z:#]"));
                }
                return true;
            }
            case "lostbook": 
            case "lb": {
                if (this.hasPermission(sender, "lostbook")) {
                    if (args.length >= 2) {
                        Player player;
                        if (args.length <= 3 && !isPlayer) {
                            sender.sendMessage(Messages.PLAYERS_ONLY.getMessage());
                            return true;
                        }
                        int amount = 1;
                        Category category3 = this.ce.getCategory(args[1]);
                        if (args.length >= 3) {
                            if (!Methods.isInt(args[2])) {
                                sender.sendMessage(Messages.NOT_A_NUMBER.getMessage().replace("%Arg%", args[2]).replace("%arg%", args[2]));
                                return true;
                            }
                            amount = Integer.parseInt(args[2]);
                        }
                        if (args.length >= 4) {
                            if (!Methods.isPlayerOnline(args[3], sender)) {
                                return true;
                            }
                            player = Methods.getPlayer(args[3]);
                        } else {
                            player = (Player)sender;
                        }
                        if (category3 != null) {
                            if (Methods.isInventoryFull(player)) {
                                player.getWorld().dropItemNaturally(player.getLocation(), category3.getLostBook().getLostBook(category3, amount).build());
                            } else {
                                player.getInventory().addItem(new ItemStack[]{category3.getLostBook().getLostBook(category3, amount).build()});
                            }
                            return true;
                        }
                        HashMap<String, String> placeholders = new HashMap<String, String>();
                        placeholders.put("%Category%", args[1]);
                        sender.sendMessage(Messages.NOT_A_CATEGORY.getMessage(placeholders));
                        return true;
                    }
                    sender.sendMessage(Methods.getPrefix() + Methods.color("&c/ce LostBook <Category> [Amount] [Player]"));
                }
                return true;
            }
            case "scrambler": 
            case "s": {
                if (this.hasPermission(sender, "scrambler")) {
                    Player player;
                    int amount = 1;
                    if (args.length <= 2 && !isPlayer) {
                        sender.sendMessage(Messages.PLAYERS_ONLY.getMessage());
                        return true;
                    }
                    if (args.length >= 2) {
                        if (!Methods.isInt(args[1])) {
                            sender.sendMessage(Messages.NOT_A_NUMBER.getMessage().replace("%Arg%", args[1]).replace("%arg%", args[1]));
                            return true;
                        }
                        amount = Integer.parseInt(args[1]);
                    }
                    if (args.length >= 3) {
                        if (!Methods.isPlayerOnline(args[2], sender)) {
                            return true;
                        }
                        player = Methods.getPlayer(args[2]);
                    } else {
                        player = (Player)sender;
                    }
                    if (Methods.isInventoryFull(player)) {
                        sender.sendMessage(Messages.INVENTORY_FULL.getMessage());
                        return true;
                    }
                    player.getInventory().addItem(new ItemStack[]{Scrambler.getScramblers(amount)});
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("%Amount%", amount + "");
                    placeholders.put("%Player%", player.getName());
                    sender.sendMessage(Messages.GIVE_SCRAMBLER_CRYSTAL.getMessage(placeholders));
                    player.sendMessage(Messages.GET_SCRAMBLER.getMessage(placeholders));
                }
                return true;
            }
            case "crystal": 
            case "c": {
                if (this.hasPermission(sender, "crystal")) {
                    Player player;
                    int amount = 1;
                    if (args.length <= 2 && !isPlayer) {
                        sender.sendMessage(Messages.PLAYERS_ONLY.getMessage());
                        return true;
                    }
                    if (args.length >= 2) {
                        if (!Methods.isInt(args[1])) {
                            sender.sendMessage(Messages.NOT_A_NUMBER.getMessage().replace("%Arg%", args[1]).replace("%arg%", args[1]));
                            return true;
                        }
                        amount = Integer.parseInt(args[1]);
                    }
                    if (args.length >= 3) {
                        if (!Methods.isPlayerOnline(args[2], sender)) {
                            return true;
                        }
                        player = Methods.getPlayer(args[2]);
                    } else {
                        player = (Player)sender;
                    }
                    if (Methods.isInventoryFull(player)) {
                        sender.sendMessage(Messages.INVENTORY_FULL.getMessage());
                        return true;
                    }
                    player.getInventory().addItem(new ItemStack[]{ProtectionCrystal.getCrystals(amount)});
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("%Amount%", amount + "");
                    placeholders.put("%Player%", player.getName());
                    sender.sendMessage(Messages.GIVE_PROTECTION_CRYSTAL.getMessage(placeholders));
                    player.sendMessage(Messages.GET_PROTECTION_CRYSTAL.getMessage(placeholders));
                }
                return true;
            }
            case "dust": {
                if (this.hasPermission(sender, "dust")) {
                    if (args.length >= 2) {
                        Dust dust;
                        Player player;
                        int amount = 1;
                        int percent = 0;
                        if (args.length == 2 && !isPlayer) {
                            sender.sendMessage(Messages.PLAYERS_ONLY.getMessage());
                            return true;
                        }
                        if (args.length >= 3) {
                            if (!Methods.isInt(args[2])) {
                                sender.sendMessage(Messages.NOT_A_NUMBER.getMessage().replace("%Arg%", args[2]).replace("%arg%", args[2]));
                                return true;
                            }
                            amount = Integer.parseInt(args[2]);
                        }
                        if (args.length >= 4) {
                            if (!Methods.isPlayerOnline(args[3], sender)) {
                                return true;
                            }
                            player = Methods.getPlayer(args[3]);
                        } else {
                            if (!isPlayer) {
                                sender.sendMessage(Messages.PLAYERS_ONLY.getMessage());
                                return true;
                            }
                            player = (Player)sender;
                        }
                        if (args.length >= 5) {
                            if (!Methods.isInt(args[4])) {
                                sender.sendMessage(Messages.NOT_A_NUMBER.getMessage().replace("%Arg%", args[4]).replace("%arg%", args[4]));
                                return true;
                            }
                            percent = Integer.parseInt(args[4]);
                        }
                        if ((dust = Dust.getFromName(args[1])) != null) {
                            if (args.length >= 5) {
                                player.getInventory().addItem(new ItemStack[]{dust.getDust(percent, amount)});
                            } else {
                                player.getInventory().addItem(new ItemStack[]{dust.getDust(amount)});
                            }
                            HashMap<String, String> placeholders = new HashMap<String, String>();
                            placeholders.put("%Amount%", amount + "");
                            placeholders.put("%Player%", player.getName());
                            switch (dust) {
                                case SUCCESS_DUST: {
                                    player.sendMessage(Messages.GET_SUCCESS_DUST.getMessage(placeholders));
                                    sender.sendMessage(Messages.GIVE_SUCCESS_DUST.getMessage(placeholders));
                                    break;
                                }
                                case DESTROY_DUST: {
                                    player.sendMessage(Messages.GET_DESTROY_DUST.getMessage(placeholders));
                                    sender.sendMessage(Messages.GIVE_DESTROY_DUST.getMessage(placeholders));
                                    break;
                                }
                                case MYSTERY_DUST: {
                                    player.sendMessage(Messages.GET_MYSTERY_DUST.getMessage(placeholders));
                                    sender.sendMessage(Messages.GIVE_MYSTERY_DUST.getMessage(placeholders));
                                }
                            }
                            return true;
                        }
                    }
                    sender.sendMessage(Methods.getPrefix() + Methods.color("&c/ce Dust <Success/Destroy/Mystery> <Amount> [Player] [Percent]"));
                }
                return true;
            }
            case "scroll": {
                if (this.hasPermission(sender, "scroll")) {
                    if (args.length >= 2) {
                        Scrolls scroll;
                        int i = 1;
                        String name = sender.getName();
                        if (args.length >= 3) {
                            if (!Methods.isInt(args[2])) {
                                sender.sendMessage(Messages.NOT_A_NUMBER.getMessage().replace("%Arg%", args[2]).replace("%arg%", args[2]));
                                return true;
                            }
                            i = Integer.parseInt(args[2]);
                        }
                        if (args.length >= 4) {
                            name = args[3];
                            if (!Methods.isPlayerOnline(name, sender)) {
                                return true;
                            }
                        } else if (!isPlayer) {
                            sender.sendMessage(Messages.PLAYERS_ONLY.getMessage());
                            return true;
                        }
                        if ((scroll = Scrolls.getFromName(args[1])) != null) {
                            Methods.getPlayer(name).getInventory().addItem(new ItemStack[]{scroll.getScroll(i)});
                            return true;
                        }
                    }
                    sender.sendMessage(Methods.getPrefix() + Methods.color("&c/ce Scroll <White/Black/Transmog> [Amount] [Player]"));
                }
                return true;
            }
            case "add": {
                if (this.hasPermission(sender, "add")) {
                    if (!isPlayer) {
                        sender.sendMessage(Messages.PLAYERS_ONLY.getMessage());
                        return true;
                    }
                    if (args.length >= 2) {
                        boolean isVanilla;
                        Player player = (Player)sender;
                        String level = "1";
                        if (args.length >= 3) {
                            if (!Methods.isInt(args[2])) {
                                sender.sendMessage(Messages.NOT_A_NUMBER.getMessage().replace("%Arg%", args[2]).replace("%arg%", args[2]));
                                return true;
                            }
                            level = args[2];
                        }
                        Enchantment vanillaEnchantment = Methods.getEnchantment(args[1]);
                        CEnchantment ceEnchantment = this.ce.getEnchantmentFromName(args[1]);
                        boolean bl = isVanilla = vanillaEnchantment != null;
                        if (vanillaEnchantment == null && ceEnchantment == null) {
                            sender.sendMessage(Messages.NOT_AN_ENCHANTMENT.getMessage());
                            return true;
                        }
                        if (Methods.getItemInHand(player).getType() == Material.AIR) {
                            sender.sendMessage(Messages.DOESNT_HAVE_ITEM_IN_HAND.getMessage());
                            return true;
                        }
                        if (isVanilla) {
                            ItemStack item = Methods.getItemInHand(player).clone();
                            item.addUnsafeEnchantment(vanillaEnchantment, Integer.parseInt(level));
                            Methods.setItemInHand(player, item);
                        } else {
                            Methods.setItemInHand(player, this.ce.addEnchantment(Methods.getItemInHand(player), ceEnchantment, Integer.parseInt(level)));
                        }
                        return true;
                    }
                    sender.sendMessage(Methods.getPrefix("&c/ce Add <Enchantment> [LvL]"));
                }
                return true;
            }
            case "remove": {
                if (this.hasPermission(sender, "remove")) {
                    if (!isPlayer) {
                        sender.sendMessage(Messages.PLAYERS_ONLY.getMessage());
                        return true;
                    }
                    if (args.length >= 2) {
                        boolean isVanilla;
                        Player player = (Player)sender;
                        Enchantment vanillaEnchantment = Methods.getEnchantment(args[1]);
                        CEnchantment ceEnchantment = this.ce.getEnchantmentFromName(args[1]);
                        boolean bl = isVanilla = vanillaEnchantment != null;
                        if (vanillaEnchantment == null && ceEnchantment == null) {
                            sender.sendMessage(Messages.NOT_AN_ENCHANTMENT.getMessage());
                            return true;
                        }
                        if (Methods.getItemInHand(player).getType() == Material.AIR) {
                            sender.sendMessage(Messages.DOESNT_HAVE_ITEM_IN_HAND.getMessage());
                            return true;
                        }
                        ItemStack item = Methods.getItemInHand(player);
                        if (isVanilla) {
                            ItemStack clone = Methods.getItemInHand(player).clone();
                            clone.removeEnchantment(vanillaEnchantment);
                            Methods.setItemInHand(player, clone);
                            return true;
                        }
                        if (this.ce.hasEnchantment(item, ceEnchantment)) {
                            Methods.setItemInHand(player, this.ce.removeEnchantment(item, ceEnchantment));
                            HashMap<String, String> placeholders = new HashMap<String, String>();
                            placeholders.put("%Enchantment%", ceEnchantment.getCustomName());
                            player.sendMessage(Messages.REMOVED_ENCHANTMENT.getMessage(placeholders));
                            return true;
                        }
                        HashMap<String, String> placeholders = new HashMap<String, String>();
                        placeholders.put("%Enchantment%", args[1]);
                        sender.sendMessage(Messages.DOESNT_HAVE_ENCHANTMENT.getMessage(placeholders));
                    }
                    sender.sendMessage(Methods.getPrefix() + Methods.color("&c/ce Remove <Enchantment>"));
                }
                return true;
            }
            case "book": {
                if (this.hasPermission(sender, "book")) {
                    if (args.length >= 2) {
                        Player player;
                        if (args.length == 2 && !isPlayer) {
                            sender.sendMessage(Messages.PLAYERS_ONLY.getMessage());
                            return true;
                        }
                        CEnchantment enchantment = this.ce.getEnchantmentFromName(args[1]);
                        int level = 1;
                        int amount = 1;
                        if (args.length >= 3) {
                            if (Methods.isInt(args[2])) {
                                level = Integer.parseInt(args[2]);
                            } else if (args[2].contains("-")) {
                                level = Methods.getRandomNumber(args[2]);
                            } else {
                                sender.sendMessage(Messages.NOT_A_NUMBER.getMessage().replace("%Arg%", args[2]).replace("%arg%", args[2]));
                                return true;
                            }
                        }
                        if (args.length >= 4) {
                            if (!Methods.isInt(args[3])) {
                                sender.sendMessage(Messages.NOT_A_NUMBER.getMessage().replace("%Arg%", args[3]).replace("%arg%", args[3]));
                                return true;
                            }
                            amount = Integer.parseInt(args[3]);
                        }
                        if (args.length >= 5) {
                            if (!Methods.isPlayerOnline(args[4], sender)) {
                                return true;
                            }
                            player = Methods.getPlayer(args[4]);
                        } else {
                            player = (Player)sender;
                        }
                        if (enchantment == null) {
                            sender.sendMessage(Messages.NOT_AN_ENCHANTMENT.getMessage());
                            return true;
                        }
                        HashMap<String, String> placeholders = new HashMap<String, String>();
                        placeholders.put("%Player%", player.getName());
                        sender.sendMessage(Messages.SEND_ENCHANTMENT_BOOK.getMessage(placeholders));
                        player.getInventory().addItem(new ItemStack[]{new CEBook(enchantment, level, amount).buildBook()});
                        return true;
                    }
                    sender.sendMessage(Methods.getPrefix() + Methods.color("&c/ce Book <Enchantment> [Lvl] [Amount] [Player]"));
                }
                return true;
            }
        }
        sender.sendMessage(Methods.getPrefix("&cDo /ce Help for more info."));
        return false;
    }

    private boolean hasPermission(CommandSender sender, String permission) {
        return Methods.hasPermission(sender, permission, true);
    }
}

