/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.api.objects;

import java.util.HashMap;
import java.util.List;
import me.badbones69.crazyenchantments.api.FileManager;
import me.badbones69.crazyenchantments.api.currencyapi.Currency;
import me.badbones69.crazyenchantments.api.objects.Category;
import me.badbones69.crazyenchantments.api.objects.ItemBuilder;
import org.bukkit.Color;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;

public class LostBook {
    private int slot;
    private boolean inGUI;
    private ItemBuilder displayItem;
    private int cost;
    private Currency currency;
    private boolean useFirework;
    private List<Color> fireworkColors;
    private boolean useSound;
    private Sound sound;

    public LostBook(int slot, boolean inGUI, ItemBuilder displayItem, int cost, Currency currency, boolean useFirework, List<Color> fireworkColors, boolean useSound, String sound) {
        this.slot = slot - 1;
        this.inGUI = inGUI;
        this.displayItem = displayItem;
        this.cost = cost;
        this.currency = currency;
        this.useFirework = !fireworkColors.isEmpty() && useFirework;
        this.fireworkColors = fireworkColors;
        try {
            this.sound = Sound.valueOf((String)sound);
        }
        catch (Exception e) {
            System.out.println("[CrazyEnchantments] The sound " + sound + " is not a sound found in this minecraft version.");
            this.sound = null;
        }
        this.useSound = sound != null && useSound;
    }

    public int getSlot() {
        return this.slot;
    }

    public boolean isInGUI() {
        return this.inGUI;
    }

    public ItemBuilder getDisplayItem() {
        return this.displayItem;
    }

    public int getCost() {
        return this.cost;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public boolean useFirework() {
        return this.useFirework;
    }

    public List<Color> getFireworkColors() {
        return this.fireworkColors;
    }

    public boolean playSound() {
        return this.useSound;
    }

    public Sound getSound() {
        return this.sound;
    }

    public ItemBuilder getLostBook(Category category) {
        return this.getLostBook(category, 1);
    }

    public ItemBuilder getLostBook(Category category, int amount) {
        FileConfiguration file = FileManager.Files.CONFIG.getFile();
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%Category%", category.getDisplayItem().getName());
        return new ItemBuilder().setMaterial(file.getString("Settings.LostBook.Item")).setAmount(amount).setName(file.getString("Settings.LostBook.Name")).setNamePlaceholders(placeholders).setLore(file.getStringList("Settings.LostBook.Lore")).setLorePlaceholders(placeholders);
    }
}

