/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.api.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.badbones69.crazyenchantments.Methods;
import me.badbones69.crazyenchantments.api.CrazyEnchantments;
import me.badbones69.crazyenchantments.multisupport.SkullCreator;
import me.badbones69.crazyenchantments.multisupport.Version;
import me.badbones69.crazyenchantments.nbtapi.NBTItem;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.banner.PatternType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class ItemBuilder
implements Cloneable {
    private static CrazyEnchantments ce = CrazyEnchantments.getInstance();
    private static boolean useNewMaterial = ce.useNewMaterial();
    private Material material;
    private int damage = 0;
    private String name = "";
    private List<String> lore;
    private int amount = 1;
    private String player = "";
    private boolean isHash = false;
    private boolean isURL = false;
    private boolean isHead = false;
    private Map<Enchantment, Integer> enchantments;
    private boolean unbreakable = false;
    private boolean hideItemFlags = false;
    private boolean glowing = false;
    private ItemStack referenceItem;
    private boolean isMobEgg = false;
    private EntityType entityType;
    private boolean isTippedArrow = false;
    private PotionType potionType = null;
    private Color potionColor = null;
    private boolean isPotion = false;
    private Color armorColor = null;
    private boolean isLeatherArmor = false;
    private List<org.bukkit.block.banner.Pattern> patterns;
    private boolean isBanner = false;
    private boolean isShield = false;
    private int customModelData = 0;
    private boolean useCustomModelData = false;
    private Map<String, String> namePlaceholders;
    private Map<String, String> lorePlaceholders;
    private List<ItemFlag> itemFlags;
    private final Pattern HEX_PATTERN = Pattern.compile("#[a-fA-F0-9]{6}");

    public ItemBuilder() {
        this.material = Material.STONE;
        this.lore = new ArrayList<String>();
        this.enchantments = new HashMap<Enchantment, Integer>();
        this.entityType = EntityType.BAT;
        this.patterns = new ArrayList<org.bukkit.block.banner.Pattern>();
        this.namePlaceholders = new HashMap<String, String>();
        this.lorePlaceholders = new HashMap<String, String>();
        this.itemFlags = new ArrayList<ItemFlag>();
    }

    public static ItemBuilder convertItemStack(ItemStack item) {
        ItemBuilder itemBuilder = new ItemBuilder().setReferenceItem(item).setAmount(item.getAmount()).setMaterial(item.getType()).setEnchantments(new HashMap<Enchantment, Integer>(item.getEnchantments()));
        if (item.hasItemMeta()) {
            ItemMeta itemMeta = item.getItemMeta();
            itemBuilder.setName(itemMeta.getDisplayName()).setLore(itemMeta.getLore());
            NBTItem nbt = new NBTItem(item);
            if (nbt.hasKey("Unbreakable").booleanValue()) {
                itemBuilder.setUnbreakable(nbt.getBoolean("Unbreakable"));
            }
            if (useNewMaterial) {
                if (itemMeta instanceof Damageable) {
                    itemBuilder.setDamage(((Damageable)itemMeta).getDamage());
                }
            } else {
                itemBuilder.setDamage(item.getDurability());
            }
        }
        return itemBuilder;
    }

    public static ItemBuilder convertString(String itemString) {
        return ItemBuilder.convertString(itemString, null);
    }

    public static ItemBuilder convertString(String itemString, String placeHolder) {
        ItemBuilder itemBuilder = new ItemBuilder();
        try {
            block24: for (String optionString : itemString.split(", ")) {
                String option = optionString.split(":")[0];
                String value = optionString.replace(option + ":", "").replace(option, "");
                switch (option.toLowerCase()) {
                    case "item": {
                        itemBuilder.setMaterial(value);
                        continue block24;
                    }
                    case "name": {
                        itemBuilder.setName(value);
                        continue block24;
                    }
                    case "amount": {
                        try {
                            itemBuilder.setAmount(Integer.parseInt(value));
                        }
                        catch (NumberFormatException e) {
                            itemBuilder.setAmount(1);
                        }
                        continue block24;
                    }
                    case "lore": {
                        itemBuilder.setLore(Arrays.asList(value.split(",")));
                        continue block24;
                    }
                    case "player": {
                        itemBuilder.setPlayer(value);
                        continue block24;
                    }
                    case "unbreakable-item": {
                        if (!value.isEmpty() && !value.equalsIgnoreCase("true")) continue block24;
                        itemBuilder.setUnbreakable(true);
                        continue block24;
                    }
                    default: {
                        Enchantment enchantment = ItemBuilder.getEnchantment(option);
                        if (enchantment != null && enchantment.getName() != null) {
                            try {
                                itemBuilder.addEnchantments(enchantment, Integer.parseInt(value));
                            }
                            catch (NumberFormatException e) {
                                itemBuilder.addEnchantments(enchantment, 1);
                            }
                            continue block24;
                        }
                        for (ItemFlag itemFlag : ItemFlag.values()) {
                            if (!itemFlag.name().equalsIgnoreCase(option)) continue;
                            itemBuilder.addItemFlag(itemFlag);
                            break;
                        }
                        try {
                            for (ItemFlag itemFlag : PatternType.values()) {
                                if (!option.equalsIgnoreCase(itemFlag.name()) && !value.equalsIgnoreCase(itemFlag.getIdentifier())) continue;
                                DyeColor color = ItemBuilder.getDyeColor(value);
                                if (color == null) continue block24;
                                itemBuilder.addPattern(new org.bukkit.block.banner.Pattern(color, (PatternType)itemFlag));
                                continue block24;
                            }
                            continue block24;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            itemBuilder.setMaterial("RED_TERRACOTTA", "STAINED_CLAY:14").setName("&c&lERROR").setLore(Arrays.asList("&cThere is an error", "&cFor : &c" + (placeHolder != null ? placeHolder : "")));
            e.printStackTrace();
        }
        return itemBuilder;
    }

    public static List<ItemBuilder> convertStringList(List<String> itemStrings) {
        return ItemBuilder.convertStringList(itemStrings, null);
    }

    public static List<ItemBuilder> convertStringList(List<String> itemStrings, String placeholder) {
        return itemStrings.stream().map(itemString -> ItemBuilder.convertString(itemString, placeholder)).collect(Collectors.toList());
    }

    public Material getMaterial() {
        return this.material;
    }

    public ItemBuilder setMaterial(Material material) {
        this.material = material;
        this.isHead = material == (useNewMaterial ? Material.matchMaterial((String)"PLAYER_HEAD") : Material.matchMaterial((String)"SKULL_ITEM"));
        return this;
    }

    public ItemBuilder setMaterial(String materialString) {
        Material material;
        String metaDataString = "";
        if (materialString.contains(":")) {
            String modelData;
            String[] split = materialString.split(":");
            materialString = split[0];
            metaDataString = split[1];
            if (metaDataString.contains("#") && Methods.isInt(modelData = metaDataString.split("#")[1])) {
                this.useCustomModelData = true;
                this.customModelData = Integer.parseInt(modelData);
            }
            if (Methods.isInt(metaDataString = metaDataString.replace("#" + this.customModelData, ""))) {
                this.damage = Integer.parseInt(metaDataString);
            } else {
                for (String option : split) {
                    if (this.potionType == null) {
                        this.potionType = this.getPotionType(PotionEffectType.getByName((String)option));
                    }
                    if (this.potionColor == null) {
                        this.potionColor = ItemBuilder.getColor(option);
                    }
                    if (this.armorColor != null) continue;
                    this.armorColor = ItemBuilder.getColor(option);
                }
            }
        } else if (materialString.contains("#")) {
            String[] b = materialString.split("#");
            materialString = b[0];
            if (Methods.isInt(b[1])) {
                this.useCustomModelData = true;
                this.customModelData = Integer.parseInt(b[1]);
            }
        }
        if ((material = Material.matchMaterial((String)materialString)) != null) {
            this.material = material;
            if (Version.isNewer(Version.v1_8_R3) && Version.isOlder(Version.v1_13_R2) && material == Material.matchMaterial((String)"MONSTER_EGG")) {
                try {
                    this.entityType = EntityType.fromId((int)this.damage) != null ? EntityType.fromId((int)this.damage) : EntityType.valueOf((String)metaDataString);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.damage = 0;
                this.isMobEgg = true;
            }
        }
        switch (this.material.name()) {
            case "PLAYER_HEAD": 
            case "SKULL_ITEM": {
                this.isHead = true;
                break;
            }
            case "TIPPED_ARROW": {
                this.isTippedArrow = true;
                break;
            }
            case "POTION": 
            case "SPLASH_POTION": {
                this.isPotion = true;
                break;
            }
            case "LEATHER_HELMET": 
            case "LEATHER_CHESTPLATE": 
            case "LEATHER_LEGGINGS": 
            case "LEATHER_BOOTS": {
                this.isLeatherArmor = true;
                break;
            }
            case "BANNER": {
                this.isBanner = true;
                break;
            }
            case "SHIELD": {
                this.isShield = true;
            }
        }
        if (this.material.name().contains("BANNER")) {
            this.isBanner = true;
        }
        return this;
    }

    public ItemBuilder setMaterial(String newMaterial, String oldMaterial) {
        return this.setMaterial(ce.useNewMaterial() ? newMaterial : oldMaterial);
    }

    public int getDamage() {
        return this.damage;
    }

    public ItemBuilder setDamage(int damage) {
        this.damage = damage;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ItemBuilder setName(String name) {
        if (name != null) {
            this.name = this.color(name);
        }
        return this;
    }

    public ItemBuilder setNamePlaceholders(Map<String, String> placeholders) {
        this.namePlaceholders = placeholders;
        return this;
    }

    public ItemBuilder addNamePlaceholder(String placeholder, String argument) {
        this.namePlaceholders.put(placeholder, argument);
        return this;
    }

    public ItemBuilder removeNamePlaceholder(String placeholder) {
        this.namePlaceholders.remove(placeholder);
        return this;
    }

    public String getUpdatedName() {
        String newName = this.name;
        for (Map.Entry<String, String> placeholder : this.namePlaceholders.entrySet()) {
            newName = newName.replace(placeholder.getKey(), placeholder.getValue()).replace(placeholder.getKey().toLowerCase(), placeholder.getValue());
        }
        return newName;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public ItemBuilder setLore(List<String> lore) {
        if (lore != null) {
            this.lore.clear();
            for (String i : lore) {
                this.lore.add(this.color(i));
            }
        }
        return this;
    }

    public ItemBuilder addLore(String lore) {
        if (lore != null) {
            this.lore.add(this.color(lore));
        }
        return this;
    }

    public ItemBuilder setLorePlaceholders(Map<String, String> placeholders) {
        this.lorePlaceholders = placeholders;
        return this;
    }

    public ItemBuilder addLorePlaceholder(String placeholder, String argument) {
        this.lorePlaceholders.put(placeholder, argument);
        return this;
    }

    public ItemBuilder addLorePlaceholder(String placeholder, int argument) {
        this.lorePlaceholders.put(placeholder, argument + "");
        return this;
    }

    public ItemBuilder removeLorePlaceholder(String placeholder) {
        this.lorePlaceholders.remove(placeholder);
        return this;
    }

    public List<String> getUpdatedLore() {
        ArrayList<String> newLore = new ArrayList<String>();
        for (String i : this.lore) {
            for (Map.Entry<String, String> placeholder : this.lorePlaceholders.entrySet()) {
                i = i.replace(placeholder.getKey(), placeholder.getValue()).replace(placeholder.getKey().toLowerCase(), placeholder.getValue());
            }
            newLore.add(i);
        }
        return newLore;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public ItemBuilder setEntityType(EntityType entityType) {
        this.entityType = entityType;
        return this;
    }

    public boolean isTippedArrow() {
        return this.isTippedArrow;
    }

    public PotionType getPotionType() {
        return this.potionType;
    }

    public void setPotionType(PotionType potionType) {
        this.potionType = potionType;
    }

    public Color getPotionColor() {
        return this.potionColor;
    }

    public void setPotionColor(Color potionColor) {
        this.potionColor = potionColor;
    }

    public boolean isPotion() {
        return this.isPotion;
    }

    public Color getArmorColor() {
        return this.armorColor;
    }

    public void setArmorColor(Color armorColor) {
        this.armorColor = armorColor;
    }

    public boolean isLeatherArmor() {
        return this.isLeatherArmor;
    }

    public List<org.bukkit.block.banner.Pattern> getPatterns() {
        return this.patterns;
    }

    public ItemBuilder addPattern(String stringPattern) {
        try {
            String[] split = stringPattern.split(":");
            for (PatternType pattern : PatternType.values()) {
                if (!split[0].equalsIgnoreCase(pattern.name()) && !split[0].equalsIgnoreCase(pattern.getIdentifier())) continue;
                DyeColor color = ItemBuilder.getDyeColor(split[1]);
                if (color != null) {
                    this.addPattern(new org.bukkit.block.banner.Pattern(color, pattern));
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public ItemBuilder addPatterns(List<String> stringList) {
        stringList.forEach(this::addPattern);
        return this;
    }

    public ItemBuilder addPattern(org.bukkit.block.banner.Pattern pattern) {
        this.patterns.add(pattern);
        return this;
    }

    public ItemBuilder setPatterns(List<org.bukkit.block.banner.Pattern> patterns) {
        this.patterns = patterns;
        return this;
    }

    public boolean isBanner() {
        return this.isBanner;
    }

    public boolean isShield() {
        return this.isShield;
    }

    public boolean isMobEgg() {
        return this.isMobEgg;
    }

    public int getAmount() {
        return this.amount;
    }

    public ItemBuilder setAmount(int amount) {
        this.amount = amount;
        return this;
    }

    public ItemBuilder addAmount(int amount) {
        this.amount += amount;
        return this;
    }

    public String getPlayer() {
        return this.player;
    }

    public ItemBuilder setPlayer(String player) {
        this.player = player;
        if (player != null && player.length() > 16) {
            this.isHash = true;
            this.isURL = player.startsWith("http");
        }
        return this;
    }

    public boolean isHead() {
        return this.isHead;
    }

    public boolean isHash() {
        return this.isHash;
    }

    public boolean isURL() {
        return this.isURL;
    }

    public Map<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    public ItemBuilder setEnchantments(Map<Enchantment, Integer> enchantments) {
        if (enchantments != null) {
            this.enchantments = enchantments;
        }
        return this;
    }

    public ItemBuilder addEnchantments(Enchantment enchantment, int level) {
        this.enchantments.put(enchantment, level);
        return this;
    }

    public ItemBuilder removeEnchantments(Enchantment enchantment) {
        this.enchantments.remove(enchantment);
        return this;
    }

    public boolean isUnbreakable() {
        return this.unbreakable;
    }

    public ItemBuilder setUnbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
        return this;
    }

    public ItemBuilder hideItemFlags(boolean hideItemFlags) {
        this.hideItemFlags = hideItemFlags;
        return this;
    }

    public boolean areItemFlagsHidden() {
        return this.hideItemFlags;
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public ItemBuilder setGlowing(boolean glowing) {
        this.glowing = glowing;
        return this;
    }

    public List<ItemFlag> getItemFlags() {
        return this.itemFlags;
    }

    public ItemBuilder addItemFlag(String flagString) {
        try {
            this.addItemFlag(ItemFlag.valueOf((String)flagString.toUpperCase()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public ItemBuilder addItemFlags(List<String> flagStrings) {
        for (String flagString : flagStrings) {
            try {
                ItemFlag itemFlag = ItemFlag.valueOf((String)flagString.toUpperCase());
                if (itemFlag == null) continue;
                this.addItemFlag(itemFlag);
            }
            catch (Exception exception) {}
        }
        return this;
    }

    public ItemBuilder addItemFlag(ItemFlag itemFlag) {
        if (itemFlag != null) {
            this.itemFlags.add(itemFlag);
        }
        return this;
    }

    public ItemBuilder setItemFlags(List<ItemFlag> itemFlags) {
        this.itemFlags = itemFlags;
        return this;
    }

    public ItemStack build() {
        ItemStack item = this.referenceItem != null ? this.referenceItem : new ItemStack(this.material);
        item.setAmount(this.amount);
        if (item.getType() != Material.AIR) {
            if (this.isHead && this.isHash) {
                if (this.isURL) {
                    SkullCreator.itemWithUrl(item, this.player);
                } else {
                    SkullCreator.itemWithBase64(item, this.player);
                }
            }
            ItemMeta itemMeta = item.getItemMeta();
            itemMeta.setDisplayName(this.getUpdatedName());
            itemMeta.setLore(this.getUpdatedLore());
            if (Version.isSame(Version.v1_8_R3) && this.isHead && !this.isHash && this.player != null && !this.player.equals("")) {
                SkullMeta skullMeta = (SkullMeta)itemMeta;
                skullMeta.setOwner(this.player);
            }
            if (Version.isNewer(Version.v1_10_R1)) {
                itemMeta.setUnbreakable(this.unbreakable);
            }
            if (Version.isNewer(Version.v1_12_R1)) {
                if (itemMeta instanceof Damageable) {
                    ((Damageable)itemMeta).setDamage(this.damage);
                }
            } else {
                item.setDurability((short)this.damage);
            }
            if ((this.isTippedArrow || this.isPotion) && (this.potionType != null || this.potionColor != null)) {
                PotionMeta potionMeta = (PotionMeta)itemMeta;
                if (this.potionType != null) {
                    potionMeta.setBasePotionData(new PotionData(this.potionType));
                }
                if (this.potionColor != null) {
                    potionMeta.setColor(this.potionColor);
                }
            }
            if (this.isLeatherArmor && this.armorColor != null) {
                LeatherArmorMeta leatherMeta = (LeatherArmorMeta)itemMeta;
                leatherMeta.setColor(this.armorColor);
            }
            if (this.isBanner && !this.patterns.isEmpty()) {
                BannerMeta bannerMeta = (BannerMeta)itemMeta;
                bannerMeta.setPatterns(this.patterns);
            }
            if (this.isShield && !this.patterns.isEmpty()) {
                BlockStateMeta shieldMeta = (BlockStateMeta)itemMeta;
                Banner banner = (Banner)shieldMeta.getBlockState();
                banner.setPatterns(this.patterns);
                banner.update();
                shieldMeta.setBlockState((BlockState)banner);
            }
            if (this.useCustomModelData) {
                itemMeta.setCustomModelData(Integer.valueOf(this.customModelData));
            }
            this.itemFlags.forEach(xva$0 -> itemMeta.addItemFlags(new ItemFlag[]{xva$0}));
            item.setItemMeta(itemMeta);
            this.hideFlags(item);
            item.addUnsafeEnchantments(this.enchantments);
            this.addGlow(item);
            NBTItem nbt = new NBTItem(item);
            if (this.isHead && !this.isHash && this.player != null && !this.player.equals("") && Version.isNewer(Version.v1_8_R3)) {
                nbt.setString("SkullOwner", this.player);
            }
            if (this.isMobEgg && this.entityType != null) {
                nbt.addCompound("EntityTag").setString("id", "minecraft:" + this.entityType.name());
            }
            if (this.unbreakable && Version.isOlder(Version.v1_11_R1)) {
                nbt.setBoolean("Unbreakable", true);
                nbt.setInteger("HideFlags", 4);
            }
            return nbt.getItem();
        }
        return item;
    }

    public ItemBuilder clone() {
        try {
            return (ItemBuilder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return new ItemBuilder();
        }
    }

    private ItemBuilder setReferenceItem(ItemStack referenceItem) {
        this.referenceItem = referenceItem;
        return this;
    }

    public String color(String message) {
        if (Version.isNewer(Version.v1_15_R1)) {
            Matcher matcher = this.HEX_PATTERN.matcher(message);
            StringBuffer buffer = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(buffer, net.md_5.bungee.api.ChatColor.of((String)matcher.group()).toString());
            }
            return ChatColor.translateAlternateColorCodes((char)'&', (String)matcher.appendTail(buffer).toString());
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    private ItemStack hideFlags(ItemStack item) {
        if (this.hideItemFlags && item != null && item.hasItemMeta()) {
            ItemMeta itemMeta = item.getItemMeta();
            itemMeta.addItemFlags(ItemFlag.values());
            item.setItemMeta(itemMeta);
            return item;
        }
        return item;
    }

    private ItemStack addGlow(ItemStack item) {
        if (this.glowing) {
            try {
                if (item != null) {
                    if (item.hasItemMeta() && item.getItemMeta().hasEnchants()) {
                        return item;
                    }
                    item.addUnsafeEnchantment(Enchantment.LUCK, 1);
                    ItemMeta meta = item.getItemMeta();
                    meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                    item.setItemMeta(meta);
                }
                return item;
            }
            catch (NoClassDefFoundError e) {
                return item;
            }
        }
        return item;
    }

    private PotionType getPotionType(PotionEffectType type) {
        if (type != null) {
            if (type.equals((Object)PotionEffectType.FIRE_RESISTANCE)) {
                return PotionType.FIRE_RESISTANCE;
            }
            if (type.equals((Object)PotionEffectType.HARM)) {
                return PotionType.INSTANT_DAMAGE;
            }
            if (type.equals((Object)PotionEffectType.HEAL)) {
                return PotionType.INSTANT_HEAL;
            }
            if (type.equals((Object)PotionEffectType.INVISIBILITY)) {
                return PotionType.INVISIBILITY;
            }
            if (type.equals((Object)PotionEffectType.JUMP)) {
                return PotionType.JUMP;
            }
            if (type.equals((Object)PotionEffectType.getByName((String)"LUCK"))) {
                return PotionType.valueOf((String)"LUCK");
            }
            if (type.equals((Object)PotionEffectType.NIGHT_VISION)) {
                return PotionType.NIGHT_VISION;
            }
            if (type.equals((Object)PotionEffectType.POISON)) {
                return PotionType.POISON;
            }
            if (type.equals((Object)PotionEffectType.REGENERATION)) {
                return PotionType.REGEN;
            }
            if (type.equals((Object)PotionEffectType.SLOW)) {
                return PotionType.SLOWNESS;
            }
            if (type.equals((Object)PotionEffectType.SPEED)) {
                return PotionType.SPEED;
            }
            if (type.equals((Object)PotionEffectType.INCREASE_DAMAGE)) {
                return PotionType.STRENGTH;
            }
            if (type.equals((Object)PotionEffectType.WATER_BREATHING)) {
                return PotionType.WATER_BREATHING;
            }
            if (type.equals((Object)PotionEffectType.WEAKNESS)) {
                return PotionType.WEAKNESS;
            }
        }
        return null;
    }

    private static Color getColor(String color) {
        if (color != null) {
            switch (color.toUpperCase()) {
                case "AQUA": {
                    return Color.AQUA;
                }
                case "BLACK": {
                    return Color.BLACK;
                }
                case "BLUE": {
                    return Color.BLUE;
                }
                case "FUCHSIA": {
                    return Color.FUCHSIA;
                }
                case "GRAY": {
                    return Color.GRAY;
                }
                case "GREEN": {
                    return Color.GREEN;
                }
                case "LIME": {
                    return Color.LIME;
                }
                case "MAROON": {
                    return Color.MAROON;
                }
                case "NAVY": {
                    return Color.NAVY;
                }
                case "OLIVE": {
                    return Color.OLIVE;
                }
                case "ORANGE": {
                    return Color.ORANGE;
                }
                case "PURPLE": {
                    return Color.PURPLE;
                }
                case "RED": {
                    return Color.RED;
                }
                case "SILVER": {
                    return Color.SILVER;
                }
                case "TEAL": {
                    return Color.TEAL;
                }
                case "WHITE": {
                    return Color.WHITE;
                }
                case "YELLOW": {
                    return Color.YELLOW;
                }
            }
            try {
                String[] rgb = color.split(",");
                return Color.fromRGB((int)Integer.parseInt(rgb[0]), (int)Integer.parseInt(rgb[1]), (int)Integer.parseInt(rgb[2]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static DyeColor getDyeColor(String color) {
        if (color != null) {
            try {
                return DyeColor.valueOf((String)color.toUpperCase());
            }
            catch (Exception e) {
                try {
                    String[] rgb = color.split(",");
                    return DyeColor.getByColor((Color)Color.fromRGB((int)Integer.parseInt(rgb[0]), (int)Integer.parseInt(rgb[1]), (int)Integer.parseInt(rgb[2])));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private static Enchantment getEnchantment(String enchantmentName) {
        enchantmentName = ItemBuilder.stripEnchantmentName(enchantmentName);
        for (Enchantment enchantment : Enchantment.values()) {
            try {
                if (Version.isNewer(Version.v1_12_R1) && ItemBuilder.stripEnchantmentName(enchantment.getKey().getKey()).equalsIgnoreCase(enchantmentName)) {
                    return enchantment;
                }
                HashMap<String, String> enchantments = ItemBuilder.getEnchantmentList();
                if (!ItemBuilder.stripEnchantmentName(enchantment.getName()).equalsIgnoreCase(enchantmentName) && (enchantments.get(enchantment.getName()) == null || !ItemBuilder.stripEnchantmentName(enchantments.get(enchantment.getName())).equalsIgnoreCase(enchantmentName))) continue;
                return enchantment;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static String stripEnchantmentName(String enchantmentName) {
        return enchantmentName != null ? enchantmentName.replace("-", "").replace("_", "").replace(" ", "") : null;
    }

    private static HashMap<String, String> getEnchantmentList() {
        HashMap<String, String> enchantments = new HashMap<String, String>();
        enchantments.put("ARROW_DAMAGE", "Power");
        enchantments.put("ARROW_FIRE", "Flame");
        enchantments.put("ARROW_INFINITE", "Infinity");
        enchantments.put("ARROW_KNOCKBACK", "Punch");
        enchantments.put("DAMAGE_ALL", "Sharpness");
        enchantments.put("DAMAGE_ARTHROPODS", "Bane_Of_Arthropods");
        enchantments.put("DAMAGE_UNDEAD", "Smite");
        enchantments.put("DEPTH_STRIDER", "Depth_Strider");
        enchantments.put("DIG_SPEED", "Efficiency");
        enchantments.put("DURABILITY", "Unbreaking");
        enchantments.put("FIRE_ASPECT", "Fire_Aspect");
        enchantments.put("KNOCKBACK", "KnockBack");
        enchantments.put("LOOT_BONUS_BLOCKS", "Fortune");
        enchantments.put("LOOT_BONUS_MOBS", "Looting");
        enchantments.put("LUCK", "Luck_Of_The_Sea");
        enchantments.put("LURE", "Lure");
        enchantments.put("OXYGEN", "Respiration");
        enchantments.put("PROTECTION_ENVIRONMENTAL", "Protection");
        enchantments.put("PROTECTION_EXPLOSIONS", "Blast_Protection");
        enchantments.put("PROTECTION_FALL", "Feather_Falling");
        enchantments.put("PROTECTION_FIRE", "Fire_Protection");
        enchantments.put("PROTECTION_PROJECTILE", "Projectile_Protection");
        enchantments.put("SILK_TOUCH", "Silk_Touch");
        enchantments.put("THORNS", "Thorns");
        enchantments.put("WATER_WORKER", "Aqua_Affinity");
        enchantments.put("BINDING_CURSE", "Curse_Of_Binding");
        enchantments.put("MENDING", "Mending");
        enchantments.put("FROST_WALKER", "Frost_Walker");
        enchantments.put("VANISHING_CURSE", "Curse_Of_Vanishing");
        enchantments.put("SWEEPING_EDGE", "Sweeping_Edge");
        enchantments.put("RIPTIDE", "Riptide");
        enchantments.put("CHANNELING", "Channeling");
        enchantments.put("IMPALING", "Impaling");
        enchantments.put("LOYALTY", "Loyalty");
        return enchantments;
    }
}

