/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.api.objects;

import java.util.ArrayList;
import java.util.List;
import me.badbones69.crazyenchantments.api.CrazyEnchantments;
import me.badbones69.crazyenchantments.api.objects.CEnchantment;
import me.badbones69.crazyenchantments.api.objects.GKitzItem;
import me.badbones69.crazyenchantments.api.objects.ItemBuilder;
import org.bukkit.inventory.ItemStack;

public class GKitz {
    private int slot;
    private String name;
    private String cooldown;
    private boolean autoEquip;
    private ItemStack displayItem;
    private List<String> commands;
    private List<ItemStack> preview;
    private List<String> itemStrings;
    private CrazyEnchantments ce = CrazyEnchantments.getInstance();

    public GKitz(String name, int slot, String cooldown, ItemStack displayItem, List<ItemStack> preview, List<String> commands, List<String> itemStrings, boolean autoEquip) {
        this.name = name;
        this.slot = slot;
        this.preview = preview;
        this.cooldown = cooldown;
        this.commands = commands;
        this.autoEquip = autoEquip;
        this.displayItem = displayItem;
        this.itemStrings = itemStrings;
    }

    public String getName() {
        return this.name;
    }

    public int getSlot() {
        return this.slot;
    }

    public String getCooldown() {
        return this.cooldown;
    }

    public ItemStack getDisplayItem() {
        return this.displayItem;
    }

    public List<ItemStack> getPreviewItems() {
        return this.preview;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public List<String> getItemStrings() {
        return this.itemStrings;
    }

    public boolean canAutoEquipt() {
        return this.autoEquip;
    }

    public List<ItemStack> getKitItems() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (String itemString : this.itemStrings) {
            StringBuilder newItemString = new StringBuilder();
            for (String option : itemString.split(", ")) {
                if (option.toLowerCase().startsWith("enchantments:") || option.toLowerCase().startsWith("customenchantments:")) {
                    StringBuilder newOption = new StringBuilder();
                    for (String enchantment : option.toLowerCase().replace("customenchantments:", "").replace("enchantments:", "").split(",")) {
                        newOption.append(enchantment).append(", ");
                    }
                    option = newOption.substring(0, newOption.length() - 2);
                }
                newItemString.append(option).append(", ");
            }
            if (newItemString.length() > 0) {
                itemString = newItemString.substring(0, newItemString.length() - 2);
            }
            GKitzItem item = new GKitzItem(ItemBuilder.convertString(itemString));
            for (String option : itemString.split(", ")) {
                try {
                    CEnchantment enchantment = this.ce.getEnchantmentFromName(option.split(":")[0]);
                    String level = option.split(":")[1];
                    if (enchantment == null) continue;
                    if (level.contains("-")) {
                        int randomLevel = this.ce.pickLevel(Integer.parseInt(level.split("-")[0]), Integer.parseInt(level.split("-")[1]));
                        if (randomLevel <= 0) continue;
                        item.addCEEnchantment(enchantment, randomLevel);
                        continue;
                    }
                    item.addCEEnchantment(enchantment, Integer.parseInt(level));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            items.add(item.build());
        }
        return items;
    }
}

