/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.api.objects;

import java.util.ArrayList;
import java.util.List;
import me.badbones69.crazyenchantments.api.FileManager;
import me.badbones69.crazyenchantments.api.managers.InfoMenuManager;
import me.badbones69.crazyenchantments.api.objects.CEnchantment;
import me.badbones69.crazyenchantments.api.objects.ItemBuilder;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;

public class EnchantmentType {
    private String name;
    private int slot;
    private ItemStack displayItem;
    private List<CEnchantment> enchantments = new ArrayList<CEnchantment>();
    private List<Material> enchantableMaterials = new ArrayList<Material>();

    public EnchantmentType(String name) {
        FileConfiguration file = FileManager.Files.ENCHANTMENT_TYPES.getFile();
        String path = "Types." + name;
        this.name = name;
        this.slot = file.getInt(path + ".Display-Item.Slot", 1) - 1;
        this.displayItem = new ItemBuilder().setMaterial(file.getString(path + ".Display-Item.Item")).setName(file.getString(path + ".Display-Item.Name")).setLore(file.getStringList(path + ".Display-Item.Lore")).build();
        for (String type : file.getStringList(path + ".Enchantable-Items")) {
            Material material = new ItemBuilder().setMaterial(type).getMaterial();
            if (material == null) continue;
            this.enchantableMaterials.add(material);
        }
    }

    public static EnchantmentType getFromName(String name) {
        return InfoMenuManager.getInstance().getFromName(name);
    }

    public String getName() {
        return this.name;
    }

    public int getSlot() {
        return this.slot;
    }

    public ItemStack getDisplayItem() {
        return this.displayItem;
    }

    public List<Material> getEnchantableMaterials() {
        return this.enchantableMaterials;
    }

    public boolean canEnchantItem(ItemStack item) {
        return this.enchantableMaterials.contains(item.getType());
    }

    public List<CEnchantment> getEnchantments() {
        return this.enchantments;
    }

    public void addEnchantment(CEnchantment enchantment) {
        this.enchantments.add(enchantment);
    }

    public void removeEnchantment(CEnchantment enchantment) {
        this.enchantments.remove(enchantment);
    }
}

