/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.api.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import me.badbones69.crazyenchantments.Methods;
import me.badbones69.crazyenchantments.api.CrazyEnchantments;
import me.badbones69.crazyenchantments.api.events.RegisteredCEnchantmentEvent;
import me.badbones69.crazyenchantments.api.events.UnregisterCEnchantmentEvent;
import me.badbones69.crazyenchantments.api.objects.Category;
import me.badbones69.crazyenchantments.api.objects.EnchantmentType;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class CEnchantment {
    private static CrazyEnchantments ce = CrazyEnchantments.getInstance();
    private String name;
    private String customName;
    private boolean activated;
    private String color;
    private String bookColor;
    private int maxLevel;
    private String infoName;
    private int chance;
    private int chanceIncrease;
    private List<String> infoDescription;
    private List<Category> categories;
    private EnchantmentType enchantmentType;
    private CEnchantment instance = this;

    public CEnchantment(String name) {
        this.name = name;
        this.customName = name;
        this.activated = true;
        this.color = "&7";
        this.bookColor = "&b&l";
        this.maxLevel = 3;
        this.infoName = "&7" + name;
        this.chance = 0;
        this.chanceIncrease = 0;
        this.infoDescription = new ArrayList<String>();
        this.categories = new ArrayList<Category>();
        this.enchantmentType = null;
    }

    public static CEnchantment getCEnchantmentFromName(String enchantment) {
        return ce.getEnchantmentFromName(enchantment);
    }

    public String getName() {
        return this.name;
    }

    public CEnchantment setName(String name) {
        this.name = name;
        return this;
    }

    public String getCustomName() {
        return this.customName;
    }

    public CEnchantment setCustomName(String customName) {
        this.customName = customName;
        return this;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public CEnchantment setActivated(boolean activated) {
        this.activated = activated;
        return this;
    }

    public String getColor() {
        return this.color;
    }

    public CEnchantment setColor(String color) {
        this.color = Methods.color(color);
        return this;
    }

    public String getBookColor() {
        return this.bookColor;
    }

    public CEnchantment setBookColor(String bookColor) {
        if (bookColor.startsWith("&f")) {
            bookColor = bookColor.substring(2);
        }
        this.bookColor = Methods.color(bookColor);
        return this;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public CEnchantment setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
        return this;
    }

    public String getInfoName() {
        return this.infoName;
    }

    public CEnchantment setInfoName(String infoName) {
        this.infoName = Methods.color(infoName);
        return this;
    }

    public int getChance() {
        return this.chance;
    }

    public CEnchantment setChance(int chance) {
        this.chance = chance;
        return this;
    }

    public int getChanceIncrease() {
        return this.chanceIncrease;
    }

    public CEnchantment setChanceIncrease(int chanceIncrease) {
        this.chanceIncrease = chanceIncrease;
        return this;
    }

    public boolean hasChanceSystem() {
        return this.chance > 0;
    }

    public boolean chanceSuccesful(int enchantmentLevel) {
        int newChance = this.chance + this.chanceIncrease * (enchantmentLevel - 1);
        int pickedChance = new Random().nextInt(100) + 1;
        return newChance >= 100 || newChance <= 0 || pickedChance <= this.chance;
    }

    public List<String> getInfoDescription() {
        return this.infoDescription;
    }

    public CEnchantment setInfoDescription(List<String> infoDescription) {
        ArrayList<String> info = new ArrayList<String>();
        for (String i : infoDescription) {
            info.add(Methods.color(i));
        }
        this.infoDescription = info;
        return this;
    }

    public CEnchantment addCategory(Category category) {
        if (category != null) {
            this.categories.add(category);
        }
        return this;
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public CEnchantment setCategories(List<String> categories) {
        for (String categoryString : categories) {
            Category category = ce.getCategory(categoryString);
            if (category == null) continue;
            this.categories.add(category);
        }
        return this;
    }

    public EnchantmentType getEnchantmentType() {
        return this.enchantmentType;
    }

    public boolean canEnchantItem(ItemStack item) {
        return this.enchantmentType != null && this.enchantmentType.canEnchantItem(item);
    }

    public CEnchantment setEnchantmentType(EnchantmentType enchantmentType) {
        this.enchantmentType = enchantmentType;
        return this;
    }

    public void registerEnchantment() {
        RegisteredCEnchantmentEvent event = new RegisteredCEnchantmentEvent(this.instance);
        Bukkit.getPluginManager().callEvent((Event)event);
        ce.registerEnchantment(this.instance);
        if (this.enchantmentType != null) {
            this.enchantmentType.addEnchantment(this.instance);
        }
        for (Category category : this.categories) {
            category.addEnchantment(this.instance);
        }
    }

    public void unregisterEnchantment() {
        UnregisterCEnchantmentEvent event = new UnregisterCEnchantmentEvent(this.instance);
        Bukkit.getPluginManager().callEvent((Event)event);
        ce.unregisterEnchantment(this.instance);
        if (this.enchantmentType != null) {
            this.enchantmentType.removeEnchantment(this.instance);
        }
        for (Category category : this.categories) {
            category.removeEnchantment(this.instance);
        }
    }

    @Deprecated
    public int getPower(ItemStack item) {
        return this.getLevel(item);
    }

    public int getLevel(ItemStack item) {
        int level = 0;
        if (Methods.verifyItemLore(item)) {
            for (String lore : item.getItemMeta().getLore()) {
                if (!lore.contains(this.customName)) continue;
                level = ce.convertLevelInteger(lore.replace(this.color + this.customName + " ", ""));
                break;
            }
        }
        if (!ce.useUnsafeEnchantments() && level > this.maxLevel) {
            level = this.maxLevel;
        }
        return level;
    }
}

