/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.api.objects;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import me.badbones69.crazyenchantments.Methods;
import me.badbones69.crazyenchantments.api.CrazyEnchantments;
import me.badbones69.crazyenchantments.api.enums.ArmorType;
import me.badbones69.crazyenchantments.api.events.ArmorEquipEvent;
import me.badbones69.crazyenchantments.api.objects.Cooldown;
import me.badbones69.crazyenchantments.api.objects.GKitz;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitTask;

public class CEPlayer {
    private int souls;
    private Player player;
    private boolean soulsActive;
    private List<Cooldown> cooldowns;
    private Double rageMultiplier;
    private boolean hasRage;
    private int rageLevel;
    private BukkitTask rageTask;
    private CrazyEnchantments ce = CrazyEnchantments.getInstance();

    public CEPlayer(Player player, int souls, boolean soulsActive, List<Cooldown> cooldowns) {
        this.souls = souls;
        this.player = player;
        this.cooldowns = cooldowns;
        this.soulsActive = soulsActive;
        this.hasRage = false;
        this.rageLevel = 0;
        this.rageMultiplier = 0.0;
        this.rageTask = null;
    }

    public Player getPlayer() {
        return this.player;
    }

    public int getSouls() {
        return this.souls;
    }

    public void setSouls(int souls) {
        this.souls = souls;
    }

    public void addSoul() {
        ++this.souls;
    }

    public void addSouls(int souls) {
        this.souls += souls;
    }

    public void useSoul() {
        --this.souls;
    }

    public void useSouls(int souls) {
        this.souls -= souls;
        if (this.souls < 0) {
            this.souls = 0;
        }
    }

    public boolean isSoulsActive() {
        return this.soulsActive;
    }

    public void setSoulsActive(boolean soulsActive) {
        this.soulsActive = soulsActive;
    }

    public void giveGKit(GKitz kit) {
        for (ItemStack item : kit.getKitItems()) {
            if (kit.canAutoEquipt()) {
                ArmorEquipEvent event;
                if (item.getType().toString().toLowerCase().contains("helmet")) {
                    if (this.player.getEquipment().getHelmet() == null || this.player.getEquipment().getHelmet().getType() == Material.AIR) {
                        event = new ArmorEquipEvent(this.player, ArmorEquipEvent.EquipMethod.DRAG, ArmorType.HELMET, new ItemStack(Material.AIR), item);
                        Bukkit.getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) continue;
                        this.player.getEquipment().setHelmet(item);
                        continue;
                    }
                } else if (item.getType().toString().toLowerCase().contains("chestplate")) {
                    if (this.player.getEquipment().getChestplate() == null || this.player.getEquipment().getChestplate().getType() == Material.AIR) {
                        event = new ArmorEquipEvent(this.player, ArmorEquipEvent.EquipMethod.DRAG, ArmorType.CHESTPLATE, new ItemStack(Material.AIR), item);
                        Bukkit.getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) continue;
                        this.player.getEquipment().setChestplate(item);
                        continue;
                    }
                } else if (item.getType().toString().toLowerCase().contains("leggings")) {
                    if (this.player.getEquipment().getLeggings() == null || this.player.getEquipment().getLeggings().getType() == Material.AIR) {
                        event = new ArmorEquipEvent(this.player, ArmorEquipEvent.EquipMethod.DRAG, ArmorType.LEGGINGS, new ItemStack(Material.AIR), item);
                        Bukkit.getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) continue;
                        this.player.getEquipment().setLeggings(item);
                        continue;
                    }
                } else if (item.getType().toString().toLowerCase().contains("boots") && (this.player.getEquipment().getBoots() == null || this.player.getEquipment().getBoots().getType() == Material.AIR)) {
                    event = new ArmorEquipEvent(this.player, ArmorEquipEvent.EquipMethod.DRAG, ArmorType.BOOTS, new ItemStack(Material.AIR), item);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) continue;
                    this.player.getEquipment().setBoots(item);
                    continue;
                }
            }
            if (Methods.isInventoryFull(this.player)) {
                this.player.getWorld().dropItemNaturally(this.player.getLocation(), item);
                continue;
            }
            this.player.getInventory().addItem(new ItemStack[]{item});
        }
        for (String cmd : kit.getCommands()) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd.replace("%Player%", this.player.getName()).replace("%player%", this.player.getName()));
        }
    }

    public boolean hasGkitPermission(GKitz kit) {
        return this.player.hasPermission("crazyenchantments.bypass.gkitz") || this.player.hasPermission("crazyenchantments.gkitz." + kit.getName().toLowerCase());
    }

    public boolean canUseGKit(GKitz kit) {
        if (this.player.hasPermission("crazyenchantments.bypass.gkitz")) {
            return true;
        }
        if (this.player.hasPermission("crazyenchantments.gkitz." + kit.getName().toLowerCase())) {
            for (Cooldown cooldown : this.getCooldowns()) {
                if (cooldown.getGKitz() != kit) continue;
                return cooldown.isCooldownOver();
            }
        } else {
            return false;
        }
        return true;
    }

    public List<Cooldown> getCooldowns() {
        return this.cooldowns;
    }

    public Cooldown getCooldown(GKitz kit) {
        for (Cooldown cooldown : this.cooldowns) {
            if (cooldown.getGKitz() != kit) continue;
            return cooldown;
        }
        return null;
    }

    public void addCooldown(Cooldown cooldown) {
        ArrayList<Cooldown> playerCooldowns = new ArrayList<Cooldown>();
        for (Cooldown c : this.getCooldowns()) {
            if (!c.getGKitz().getName().equalsIgnoreCase(cooldown.getGKitz().getName())) continue;
            playerCooldowns.add(c);
        }
        this.cooldowns.removeAll(playerCooldowns);
        this.cooldowns.add(cooldown);
    }

    public void addCooldown(GKitz kit) {
        Calendar cooldown = Calendar.getInstance();
        for (String i : kit.getCooldown().split(" ")) {
            if (i.contains("D") || i.contains("d")) {
                cooldown.add(5, Integer.parseInt(i.replace("D", "").replace("d", "")));
            }
            if (i.contains("H") || i.contains("h")) {
                cooldown.add(10, Integer.parseInt(i.replace("H", "").replace("h", "")));
            }
            if (i.contains("M") || i.contains("m")) {
                cooldown.add(12, Integer.parseInt(i.replace("M", "").replace("m", "")));
            }
            if (!i.contains("S") && !i.contains("s")) continue;
            cooldown.add(13, Integer.parseInt(i.replace("S", "").replace("s", "")));
        }
        this.addCooldown(new Cooldown(kit, cooldown));
    }

    public void removeCooldown(Cooldown cooldown) {
        this.cooldowns.remove(cooldown);
    }

    public void removeCooldown(GKitz kit) {
        ArrayList<Cooldown> playerCooldowns = new ArrayList<Cooldown>();
        for (Cooldown cooldown : this.getCooldowns()) {
            if (!cooldown.getGKitz().getName().equalsIgnoreCase(kit.getName())) continue;
            playerCooldowns.add(cooldown);
        }
        this.cooldowns.removeAll(playerCooldowns);
    }

    public Double getRageMultiplier() {
        return this.rageMultiplier;
    }

    public void setRageMultiplier(Double rageMultiplier) {
        this.rageMultiplier = rageMultiplier;
    }

    public boolean hasRage() {
        return this.hasRage;
    }

    public void setRage(boolean hasRage) {
        this.hasRage = hasRage;
    }

    public int getRageLevel() {
        return this.rageLevel;
    }

    public void setRageLevel(int rageLevel) {
        this.rageLevel = rageLevel;
    }

    public BukkitTask getRageTask() {
        return this.rageTask;
    }

    public void setRageTask(BukkitTask rageTask) {
        this.rageTask = rageTask;
    }
}

