/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.api.objects;

import java.util.ArrayList;
import java.util.Random;
import me.badbones69.crazyenchantments.Methods;
import me.badbones69.crazyenchantments.api.CrazyEnchantments;
import me.badbones69.crazyenchantments.api.FileManager;
import me.badbones69.crazyenchantments.api.objects.CEnchantment;
import me.badbones69.crazyenchantments.api.objects.Category;
import me.badbones69.crazyenchantments.api.objects.ItemBuilder;
import org.bukkit.inventory.ItemStack;

public class CEBook {
    private CEnchantment enchantment;
    private int amount;
    private int level;
    private boolean glowing;
    private int destroyRate;
    private int successRate;
    private CrazyEnchantments ce = CrazyEnchantments.getInstance();

    public CEBook(CEnchantment enchantment) {
        this(enchantment, 1, 1);
    }

    public CEBook(CEnchantment enchantment, int level) {
        this(enchantment, level, 1);
    }

    public CEBook(CEnchantment enchantment, int level, int amount) {
        this.enchantment = enchantment;
        this.amount = amount;
        this.level = level;
        this.glowing = FileManager.Files.CONFIG.getFile().getBoolean("Settings.Enchantment-Book-Glowing");
        int successMax = FileManager.Files.CONFIG.getFile().getInt("Settings.BlackScroll.SuccessChance.Max");
        int successMin = FileManager.Files.CONFIG.getFile().getInt("Settings.BlackScroll.SuccessChance.Min");
        int destroyMax = FileManager.Files.CONFIG.getFile().getInt("Settings.BlackScroll.DestroyChance.Max");
        int destoryMin = FileManager.Files.CONFIG.getFile().getInt("Settings.BlackScroll.DestroyChance.Min");
        this.destroyRate = this.percentPick(destroyMax, destoryMin);
        this.successRate = this.percentPick(successMax, successMin);
    }

    public CEBook(CEnchantment enchantment, int level, Category category) {
        this(enchantment, level, 1, category);
    }

    public CEBook(CEnchantment enchantment, int level, int amount, Category category) {
        this.enchantment = enchantment;
        this.amount = amount;
        this.level = level;
        this.glowing = FileManager.Files.CONFIG.getFile().getBoolean("Settings.Enchantment-Book-Glowing");
        this.destroyRate = this.percentPick(category.getMaxDestroyRate(), category.getMinDestroyRate());
        this.successRate = this.percentPick(category.getMaxSuccessRate(), category.getMinSuccessRate());
    }

    public CEBook(CEnchantment enchantment, int level, int amount, int destroyRate, int successRate) {
        this.enchantment = enchantment;
        this.amount = amount;
        this.level = level;
        this.glowing = FileManager.Files.CONFIG.getFile().getBoolean("Settings.Enchantment-Book-Glowing");
        this.destroyRate = destroyRate;
        this.successRate = successRate;
    }

    public CEnchantment getEnchantment() {
        return this.enchantment;
    }

    public CEBook setEnchantment(CEnchantment enchantment) {
        this.enchantment = enchantment;
        return this;
    }

    public boolean getGlowing() {
        return this.glowing;
    }

    public CEBook setGlowing(boolean toggle) {
        this.glowing = toggle;
        return this;
    }

    public int getAmount() {
        return this.amount;
    }

    public CEBook setAmount(int amount) {
        this.amount = amount;
        return this;
    }

    public int getLevel() {
        return this.level;
    }

    public CEBook setLevel(int level) {
        this.level = level;
        return this;
    }

    public int getDestroyRate() {
        return this.destroyRate;
    }

    public CEBook setDestroyRate(int destroyRate) {
        this.destroyRate = destroyRate;
        return this;
    }

    public int getSuccessRate() {
        return this.successRate;
    }

    public CEBook setSuccessRate(int successRate) {
        this.successRate = successRate;
        return this;
    }

    public ItemBuilder getItemBuilder() {
        String name = this.enchantment.getBookColor() + this.enchantment.getCustomName() + " " + this.ce.convertLevelString(this.level);
        ArrayList<String> lore = new ArrayList<String>();
        for (String bookLine : FileManager.Files.CONFIG.getFile().getStringList("Settings.EnchantmentBookLore")) {
            if (bookLine.contains("%Description%") || bookLine.contains("%description%")) {
                for (String enchantmentLine : this.enchantment.getInfoDescription()) {
                    lore.add(Methods.color(enchantmentLine));
                }
                continue;
            }
            lore.add(Methods.color(bookLine).replace("%Destroy_Rate%", this.destroyRate + "").replace("%destroy_rate%", this.destroyRate + "").replace("%Success_Rate%", this.successRate + "").replace("%success_rate%", this.successRate + ""));
        }
        return this.ce.getEnchantmentBook().setAmount(this.amount).setName(name).setLore(lore).setGlowing(this.glowing);
    }

    public ItemStack buildBook() {
        return this.getItemBuilder().build();
    }

    private int percentPick(int max, int min) {
        return max == min ? max : min + new Random().nextInt(max - min);
    }
}

