/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.api.objects;

import java.util.Map;
import me.badbones69.crazyenchantments.api.CrazyEnchantments;
import me.badbones69.crazyenchantments.api.managers.BlackSmithManager;
import me.badbones69.crazyenchantments.api.objects.BlackSmithCompare;
import me.badbones69.crazyenchantments.api.objects.CEBook;
import me.badbones69.crazyenchantments.api.objects.CEItem;
import me.badbones69.crazyenchantments.api.objects.CEnchantment;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BlackSmithResult {
    private static CrazyEnchantments ce = CrazyEnchantments.getInstance();
    private static BlackSmithManager blackSmithManager = BlackSmithManager.getInstance();
    private int cost = 0;
    private ItemStack resultItem;

    public BlackSmithResult(Player player, ItemStack mainItem, ItemStack subItem) {
        this.resultItem = mainItem.clone();
        if (mainItem.getType() == ce.getEnchantmentBook().getMaterial() && subItem.getType() == ce.getEnchantmentBook().getMaterial()) {
            CEBook mainBook = ce.getCEBook(mainItem);
            CEBook subBook = ce.getCEBook(subItem);
            if (mainBook.getEnchantment() == subBook.getEnchantment() && mainBook.getLevel() == subBook.getLevel() && mainBook.getLevel() + 1 <= mainBook.getEnchantment().getMaxLevel()) {
                this.resultItem = mainBook.setLevel(mainBook.getLevel() + 1).buildBook();
                this.cost += blackSmithManager.getBookUpgrade();
            }
        } else if (mainItem.getType() == subItem.getType()) {
            int subLevel;
            int level;
            Object enchantment;
            CEItem mainCE = new CEItem(this.resultItem);
            CEItem subCE = new CEItem(subItem);
            BlackSmithCompare compare = new BlackSmithCompare(mainCE, subCE);
            for (Map.Entry<Enchantment, Integer> entry : mainCE.getVanillaEnchantments().entrySet()) {
                enchantment = entry.getKey();
                level = entry.getValue();
                subLevel = subCE.getVanillaEnchantmentLevel((Enchantment)enchantment);
                if (!enchantment.canEnchantItem(subItem) || !subCE.hasVanillaEnchantment((Enchantment)enchantment)) continue;
                if (level == subLevel && level < enchantment.getMaxLevel()) {
                    mainCE.setVanillaEnchantment((Enchantment)enchantment, level + 1);
                    this.cost += blackSmithManager.getLevelUp();
                    continue;
                }
                if (level >= subLevel) continue;
                mainCE.setVanillaEnchantment((Enchantment)enchantment, subLevel);
                this.cost += blackSmithManager.getLevelUp();
            }
            for (Map.Entry<Object, Integer> entry : mainCE.getCEnchantments().entrySet()) {
                enchantment = (CEnchantment)entry.getKey();
                level = entry.getValue();
                subLevel = subCE.getCEnchantmentLevel((CEnchantment)enchantment);
                if (!((CEnchantment)enchantment).canEnchantItem(subItem) || !subCE.hasCEnchantment((CEnchantment)enchantment)) continue;
                if (level == subLevel && level < ((CEnchantment)enchantment).getMaxLevel()) {
                    mainCE.setCEnchantment((CEnchantment)enchantment, level + 1);
                    this.cost += blackSmithManager.getLevelUp();
                    continue;
                }
                if (level >= subLevel) continue;
                mainCE.setCEnchantment((CEnchantment)enchantment, subLevel);
                this.cost += blackSmithManager.getLevelUp();
            }
            for (Map.Entry<Object, Integer> entry : compare.getNewVanillaEnchantments().entrySet()) {
                enchantment = (Enchantment)entry.getKey();
                if (!enchantment.canEnchantItem(subItem) || !ce.canAddEnchantment(player, mainItem)) continue;
                mainCE.setVanillaEnchantment((Enchantment)enchantment, entry.getValue());
                this.cost += blackSmithManager.getAddEnchantment();
            }
            for (Map.Entry<Object, Integer> entry : compare.getNewCEnchantments().entrySet()) {
                enchantment = (CEnchantment)entry.getKey();
                if (!((CEnchantment)enchantment).canEnchantItem(subItem) || !ce.canAddEnchantment(player, mainItem) || !ce.canAddEnchantment(player, subItem)) continue;
                mainCE.setCEnchantment((CEnchantment)enchantment, entry.getValue());
                this.cost += blackSmithManager.getAddEnchantment();
            }
            mainCE.build();
        }
    }

    public int getCost() {
        return this.cost;
    }

    public ItemStack getResultItem() {
        return this.resultItem;
    }
}

