/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.api.objects;

import java.util.HashMap;
import me.badbones69.crazyenchantments.api.CrazyEnchantments;
import me.badbones69.crazyenchantments.api.enums.Messages;
import me.badbones69.crazyenchantments.api.managers.AllyManager;
import me.badbones69.crazyenchantments.multisupport.Support;
import me.badbones69.crazyenchantments.multisupport.Version;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Endermite;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Silverfish;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class AllyMob {
    private AllyType type;
    private Player owner;
    private LivingEntity ally;
    private long spawnTime;
    private BukkitTask runnable;
    private CrazyEnchantments ce = CrazyEnchantments.getInstance();
    private Support support = Support.getInstance();
    private AllyMob instance;
    private static AllyManager allyManager = AllyManager.getInstance();

    public AllyMob(Player owner, AllyType type) {
        this.type = type;
        this.owner = owner;
        this.instance = this;
    }

    public AllyType getType() {
        return this.type;
    }

    public Player getOwner() {
        return this.owner;
    }

    public LivingEntity getAlly() {
        return this.ally;
    }

    public void spawnAlly(long spawnTime) {
        this.spawnAlly(this.owner.getLocation(), spawnTime);
    }

    public void spawnAlly(Location location, long spawnTime) {
        this.spawnTime = spawnTime;
        this.ally = (LivingEntity)location.getWorld().spawnEntity(location, this.type.entityType);
        this.support.noStack((Entity)this.ally);
        if (this.ce.useHealthAttributes()) {
            this.ally.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue((double)this.type.maxHealth);
        } else {
            this.ally.setMaxHealth((double)this.type.maxHealth);
        }
        this.ally.setHealth((double)this.type.maxHealth);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%Player%", this.owner.getName());
        placeholders.put("%Mob%", this.type.entityType.getName());
        this.ally.setCustomName(Messages.replacePlaceholders(placeholders, this.type.getName()));
        this.ally.setCustomNameVisible(true);
        this.startSpawnTimer();
        allyManager.addAllyMob(this.instance);
    }

    public void forceRemoveAlly() {
        this.runnable.cancel();
        allyManager.removeAllyMob(this.instance);
        this.ally.remove();
    }

    public void attackEnemy(LivingEntity enemy) {
        switch (this.ally.getType()) {
            case WOLF: {
                Wolf wolf = (Wolf)this.ally;
                wolf.setTarget(enemy);
                break;
            }
            case IRON_GOLEM: {
                IronGolem iron = (IronGolem)this.ally;
                iron.setTarget(enemy);
                break;
            }
            case ZOMBIE: {
                Zombie zom = (Zombie)this.ally;
                zom.setTarget(enemy);
                break;
            }
            case ENDERMITE: {
                Endermite mite = (Endermite)this.ally;
                mite.setTarget(enemy);
                break;
            }
            case SILVERFISH: {
                Silverfish sfish = (Silverfish)this.ally;
                sfish.setTarget(enemy);
                break;
            }
            case BEE: {
                Bee bee = (Bee)this.ally;
                bee.setTarget(enemy);
            }
        }
    }

    private void startSpawnTimer() {
        this.runnable = new BukkitRunnable(){

            public void run() {
                allyManager.removeAllyMob(AllyMob.this.instance);
                AllyMob.this.ally.remove();
            }
        }.runTaskLater(this.ce.getPlugin(), this.spawnTime * 20L);
    }

    public static enum AllyType {
        WOLF("Wolf", "&b%player%'s Saberwolf", EntityType.WOLF, 16),
        IRON_GOLEM("Iron-Golem", "&6%player%'s Golem", EntityType.IRON_GOLEM, 200),
        ZOMBIE("Zombie", "&2%player%'s Undead", EntityType.ZOMBIE, 45),
        ENDERMITE("Endermite", "&5%player%'s Endermite", EntityType.ENDERMITE, 10),
        SILVERFISH("Silverfish", "&7%player%'s Silverfish", EntityType.SILVERFISH, 10),
        BEE("Bee", "&e%player%'s Bee", Version.isNewer(Version.v1_14_R1) ? EntityType.valueOf((String)"BEE") : EntityType.WOLF, 10);

        private String configName;
        private String defaultName;
        private EntityType entityType;
        private int maxHealth;

        private AllyType(String configName, String defaultName, EntityType entityType, int maxHealth) {
            this.configName = configName;
            this.defaultName = defaultName;
            this.entityType = entityType;
            this.maxHealth = maxHealth;
        }

        public String getConfigName() {
            return this.configName;
        }

        public String getDefaultName() {
            return this.defaultName;
        }

        public String getName() {
            return allyManager.getAllyTypeNameCache().get((Object)this);
        }

        public EntityType getEntityType() {
            return this.entityType;
        }

        public int getMaxHealth() {
            return this.maxHealth;
        }
    }
}

