/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.api.managers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import me.badbones69.crazyenchantments.Methods;
import me.badbones69.crazyenchantments.api.CrazyEnchantments;
import me.badbones69.crazyenchantments.api.FileManager;
import me.badbones69.crazyenchantments.api.currencyapi.Currency;
import me.badbones69.crazyenchantments.api.currencyapi.CurrencyAPI;
import me.badbones69.crazyenchantments.api.enums.ShopOption;
import me.badbones69.crazyenchantments.api.objects.Category;
import me.badbones69.crazyenchantments.api.objects.ItemBuilder;
import me.badbones69.crazyenchantments.api.objects.LostBook;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class ShopManager {
    private CrazyEnchantments ce = CrazyEnchantments.getInstance();
    private static ShopManager instance = new ShopManager();
    private String inventoryName;
    private int inventorySize;
    private boolean enchantmentTableShop;
    private HashMap<ItemBuilder, Integer> customizerItems = new HashMap();
    private HashMap<ItemBuilder, Integer> shopItems = new HashMap();

    public static ShopManager getInstance() {
        return instance;
    }

    public void load() {
        this.customizerItems.clear();
        this.shopItems.clear();
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        this.inventoryName = Methods.color(config.getString("Settings.InvName"));
        this.inventorySize = config.getInt("Settings.GUISize");
        this.enchantmentTableShop = config.getBoolean("Settings.EnchantmentOptions.Right-Click-Enchantment-Table");
        for (String customItemString : config.getStringList("Settings.GUICustomization")) {
            int slot = 0;
            for (String option : customItemString.split(", ")) {
                if (!option.contains("Slot:")) continue;
                option = option.replace("Slot:", "");
                slot = Integer.parseInt(option);
                break;
            }
            if (slot > this.inventorySize || slot <= 0) continue;
            this.customizerItems.put(ItemBuilder.convertString(customItemString), --slot);
        }
        for (Category category : this.ce.getCategories()) {
            LostBook lostBook;
            if (category.isInGUI()) {
                if (category.getSlot() > this.inventorySize) continue;
                this.shopItems.put(category.getDisplayItem(), category.getSlot());
            }
            if (!(lostBook = category.getLostBook()).isInGUI() || lostBook.getSlot() > this.inventorySize) continue;
            this.shopItems.put(lostBook.getDisplayItem(), lostBook.getSlot());
        }
        for (Iterator<Object> iterator : ShopOption.values()) {
            if (!((ShopOption)((Object)iterator)).isInGUI() || ((ShopOption)((Object)iterator)).getSlot() > this.inventorySize) continue;
            this.shopItems.put(((ShopOption)((Object)iterator)).getItemBuilder(), ((ShopOption)((Object)iterator)).getSlot());
        }
    }

    public Inventory getShopInventory(Player player) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        for (Currency currency : Currency.values()) {
            placeholders.put("%" + currency.getName() + "%", CurrencyAPI.getCurrency(player, currency) + "");
        }
        Inventory inventory = Bukkit.createInventory(null, (int)this.inventorySize, (String)this.inventoryName);
        for (Map.Entry<ItemBuilder, Integer> itemBuilders : this.customizerItems.entrySet()) {
            itemBuilders.getKey().setNamePlaceholders(placeholders).setLorePlaceholders(placeholders);
            inventory.setItem(itemBuilders.getValue().intValue(), itemBuilders.getKey().build());
        }
        this.shopItems.keySet().forEach(itemBuilder -> inventory.setItem(this.shopItems.get(itemBuilder).intValue(), itemBuilder.build()));
        return inventory;
    }

    public String getInventoryName() {
        return this.inventoryName;
    }

    public int getInventorySize() {
        return this.inventorySize;
    }

    public boolean isEnchantmentTableShop() {
        return this.enchantmentTableShop;
    }
}

