/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.api.managers;

import java.util.ArrayList;
import java.util.List;
import me.badbones69.crazyenchantments.Methods;
import me.badbones69.crazyenchantments.api.CrazyEnchantments;
import me.badbones69.crazyenchantments.api.FileManager;
import me.badbones69.crazyenchantments.api.objects.CEnchantment;
import me.badbones69.crazyenchantments.api.objects.EnchantmentType;
import me.badbones69.crazyenchantments.api.objects.ItemBuilder;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class InfoMenuManager {
    public static final InfoMenuManager instance = new InfoMenuManager();
    private Inventory inventoryMenu;
    private String inventoryName;
    private int inventorySize;
    private ItemStack backRight;
    private ItemStack backLeft;
    private List<EnchantmentType> enchantmentTypes = new ArrayList<EnchantmentType>();
    private CrazyEnchantments ce = CrazyEnchantments.getInstance();

    public static InfoMenuManager getInstance() {
        return instance;
    }

    public void load() {
        this.enchantmentTypes.clear();
        FileConfiguration file = FileManager.Files.ENCHANTMENT_TYPES.getFile();
        String path = "Info-GUI-Settings";
        this.inventoryName = Methods.color(file.getString(path + ".Inventory.Name", "&c&lEnchantment Info"));
        this.inventorySize = file.getInt(path + ".Inventory.Size", 18);
        this.inventoryMenu = Bukkit.createInventory(null, (int)this.inventorySize, (String)this.inventoryName);
        this.backRight = new ItemBuilder().setMaterial(file.getString(path + ".Back-Item.Right.Item", "NETHER_STAR")).setName(file.getString(path + ".Back-Item.Right.Name", "&7&l<<&b&lBack")).setLore(file.getStringList(path + ".Back-Item.Right.Lore")).build();
        this.backLeft = new ItemBuilder().setMaterial(file.getString(path + ".Back-Item.Left.Item", "NETHER_STAR")).setName(file.getString(path + ".Back-Item.Left.Name", "&b&lBack&7&l>>")).setLore(file.getStringList(path + ".Back-Item.Left.Lore")).build();
        for (String type : file.getConfigurationSection("Types").getKeys(false)) {
            EnchantmentType enchantmentType = new EnchantmentType(type);
            this.enchantmentTypes.add(enchantmentType);
            this.inventoryMenu.setItem(enchantmentType.getSlot(), enchantmentType.getDisplayItem());
        }
    }

    public Inventory getInventoryMenu() {
        return this.inventoryMenu;
    }

    public String getInventoryName() {
        return this.inventoryName;
    }

    public int getInventorySize() {
        return this.inventorySize;
    }

    public List<EnchantmentType> getEnchantmentTypes() {
        return this.enchantmentTypes;
    }

    public ItemStack getBackRightButton() {
        return this.backRight;
    }

    public ItemStack getBackLeftButton() {
        return this.backLeft;
    }

    public EnchantmentType getFromName(String name) {
        for (EnchantmentType enchantmentType : this.enchantmentTypes) {
            if (!enchantmentType.getName().equalsIgnoreCase(name)) continue;
            return enchantmentType;
        }
        return null;
    }

    public void openInfoMenu(Player player) {
        player.openInventory(this.inventoryMenu);
    }

    public void openInfoMenu(Player player, EnchantmentType enchantmentType) {
        List<CEnchantment> enchantments = enchantmentType.getEnchantments();
        int slots = 9;
        for (int size = enchantments.size() + 1; size > 9; size -= 9) {
            slots += 9;
        }
        Inventory inventory = Bukkit.createInventory(null, (int)slots, (String)this.inventoryName);
        for (CEnchantment enchantment : enchantments) {
            if (!enchantment.isActivated()) continue;
            inventory.addItem(new ItemStack[]{this.ce.getEnchantmentBook().setName(enchantment.getInfoName()).setLore(enchantment.getInfoDescription()).setGlowing(true).build()});
        }
        inventory.setItem(slots - 1, this.backRight);
        player.openInventory(inventory);
    }
}

